$(document).ready(function () {
  // Solo para debug - verificar valores
  console.log("Valores al cargar:", {
    deposito: $('#ubicacionDeposito').val(),
    rack: $('#ubicacionRack').val(),
    columna: $('#ubicacionColumna').val(),
    nivel: $('#ubicacionNivel').val(),
    fondo: $('#ubicacionFondo').val()
  });

  // Obtener datos del cubo (asegúrate que los campos tienen valores)
  const deposito = $('#ubicacionDeposito').val();
  const rack = $('#ubicacionRack').val(); // Corregido el selector
  const columna = $('#ubicacionColumna').val();
  const nivel = $('#ubicacionNivel').val();
  const fondo = $('#ubicacionFondo').val();

  // Solo hacer la petición si hay valores
  if(deposito && rack && columna && nivel && fondo) {
    $.ajax({
      url: "obtener_pallet.php",
      type: "POST",
      dataType: "json",
      data: { deposito, rack, columna, nivel, fondo },
      success: function(response) {
        if(response.existe) {
          $("#palletId").val(response.datos.id);
          $("#cod").val(response.datos.cod);
          $("#lote").val(response.datos.lote);
          $("#vencimiento").val(response.datos.vencimiento);
        } else {
          console.log("No hay datos para esta ubicación");
        }
      },
      error: function(xhr, status, error) {
        console.error("Error AJAX:", error, "Respuesta:", xhr.responseText);
      }
    });
  } else {
    console.log("Faltan datos de ubicación para hacer la consulta");
  }
});