<?php
session_start();
include_once '../libreria/ezSql/ez_sql_core.php';
include_once '../libreria/ezSql/ez_sql_pdo.php';
include_once '../libreria/ezSql/conect.php';

// Configuración
$deposito = 'N1';
$fechaHoy = date('Y-m-d');
$vencimiento = date('Y-m-d', strtotime('+3 years'));
$cantidad = 100;

// Generar num_pallet únicos
$numPalletsDisponibles = range(24500, 24940);
shuffle($numPalletsDisponibles);

// Obtener posiciones válidas
$posiciones = $db->get_col("SELECT id FROM ope_layout WHERE deposito = '$deposito'");

if (!$posiciones) {
    die("No se encontraron posiciones para el depósito $deposito");
}

$productoActual = rand(1, 150);
$contadorGrupo = 0;

foreach ($posiciones as $posicionId) {
    if (empty($numPalletsDisponibles)) {
        break; // No más códigos disponibles
    }

    // Cambiar producto cada 12 posiciones
    if ($contadorGrupo % 12 === 0) {
        $productoActual = rand(1, 150);
    }
    $contadorGrupo++;

    $numPallet = array_pop($numPalletsDisponibles);
    $lote = 'L' . strtoupper(bin2hex(random_bytes(3)));

    $db->query("
        INSERT INTO ctrl_conteo (posicion_id, num_pallet, producto, lote, vencimiento, cantidad, created_at)
        VALUES ('$posicionId', '$numPallet', '$productoActual', '$lote', '$vencimiento', '$cantidad', '$fechaHoy')
        ON DUPLICATE KEY UPDATE 
            num_pallet = VALUES(num_pallet),
            producto = VALUES(producto),
            lote = VALUES(lote),
            vencimiento = VALUES(vencimiento),
            cantidad = VALUES(cantidad)
    ");
}

echo "Carga completada correctamente con actualización de duplicados.";
