<?php
session_start();

$usuario = $_SESSION['usuario_id'] ?? 42;

require __DIR__ . '/vendor/autoload.php';
include_once '../libreria/ezSql/ez_sql_core.php';
include_once '../libreria/ezSql/ez_sql_pdo.php';
include_once '../libreria/ezSql/conect.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

/* =========================
   CONFIG
   ========================= */
define('MODO_CREACION_PICKING', false);   // true: crea/actualiza paquetes también en modo normal
define('TABLA_CONTEO', 'ctrl_conteo');   // tu tabla de conteo
define('MODO_ENTRADA_DEFAULT', 1);       // valor por defecto para ope_entradas.modo_id

/* =========================
   FECHAS (Asunción -> UTC)
   ========================= */
function hoyUtcRangeByAsuncion() {
    $tz = new DateTimeZone('America/Asuncion');
    $startLocal = new DateTime('today', $tz);
    $endLocal   = (clone $startLocal)->modify('+1 day');
    $utc = new DateTimeZone('UTC');
    $startLocal->setTimezone($utc);
    $endLocal->setTimezone($utc);
    return ['start' => $startLocal->format('Y-m-d H:i:s'), 'end' => $endLocal->format('Y-m-d H:i:s')];
}

/* =========================
   HELPERS DB (robustos)
   ========================= */
function ensureEntradaHoy($db, $usuario) {
    $r = hoyUtcRangeByAsuncion();

    // Reusar entrada de hoy (por created_at)
    $entradaId = $db->get_var("
        SELECT id FROM ope_entradas
        WHERE created_at >= '{$r['start']}' AND created_at < '{$r['end']}'
        ORDER BY id ASC LIMIT 1
    ");
    if ($entradaId) return (int)$entradaId;

    // Crear nueva entrada mínima válida (modo_id y responsable_id NOT NULL)
    $fechaLocal = (new DateTime('now', new DateTimeZone('America/Asuncion')))->format('Y-m-d H:i:s');

    $db->query("
        INSERT INTO ope_entradas
            (fecha_ingreso, modo_id, responsable_id, created_at)
        VALUES
            ('{$fechaLocal}', ".intval(MODO_ENTRADA_DEFAULT).", ".intval($usuario).", NOW())
    ");

    $id = (int)$db->insert_id;
    if (!$id) $id = (int)$db->get_var("SELECT LAST_INSERT_ID()");
    return $id;
}

/** Actualiza posicion_id si cambió (y marca updated_at) */
function ensureBloquePosicion($db, $bloqueId, $posicionId) {
    $bloqueId = intval($bloqueId);
    $posicionId = intval($posicionId);
    $db->query("
        UPDATE ope_bloques
        SET posicion_id = $posicionId, updated_at = NOW()
        WHERE id = $bloqueId AND posicion_id <> $posicionId
    ");
}

/**
 * Asegura un bloque para la posición (hoy). Si viene $forceBloqueId:
 *  - si existe (cualquier fecha/pos.) → actualiza posicion_id y devuelve ese id
 *  - si no existe → lo crea con ese id
 * Si no viene $forceBloqueId: reusa bloque de hoy o crea uno nuevo.
 */
function ensureBloqueHoy($db, $posicionId, $usuario, $forceBloqueId = null) {
    $r = hoyUtcRangeByAsuncion();
    $posicionId = intval($posicionId);

    if ($forceBloqueId !== null && $forceBloqueId !== '') {
        $fid = intval($forceBloqueId);

        // ¿Existe ese bloque ID (sin importar fecha)?
        $existeCualquiera = $db->get_var("SELECT id FROM ope_bloques WHERE id = $fid LIMIT 1");
        if ($existeCualquiera) {
            ensureBloquePosicion($db, $fid, $posicionId);
            return $fid;
        }

        // Crear bloque con ID explícito
        $entradaId = ensureEntradaHoy($db, $usuario);
        $ticket = 'BLK'.(new DateTime('now', new DateTimeZone('America/Asuncion')))->format('ymdHis');

        $db->query("
            INSERT INTO ope_bloques
                (id, ticket, entrada_id, posicion_id, posicion_id_flag, montacarguista_id, estado_id, created_at)
            VALUES
                ($fid, '{$ticket}', ".intval($entradaId).", $posicionId, 1, NULL, 1, NOW())
        ");
        return $fid;
    }

    // Reusar bloque de HOY
    $bloqueId = $db->get_var("
        SELECT id FROM ope_bloques
        WHERE posicion_id = $posicionId
          AND created_at >= '{$r['start']}' AND created_at < '{$r['end']}'
        ORDER BY id ASC LIMIT 1
    ");
    if ($bloqueId) return (int)$bloqueId;

    // Crear
    $entradaId = ensureEntradaHoy($db, $usuario);
    $ticket = 'BLK'.(new DateTime('now', new DateTimeZone('America/Asuncion')))->format('ymdHis');

    $db->query("
        INSERT INTO ope_bloques
            (ticket, entrada_id, posicion_id, posicion_id_flag, montacarguista_id, estado_id, created_at)
        VALUES
            ('{$ticket}', ".intval($entradaId).", $posicionId, 1, NULL, 1, NOW())
    ");

    $id = (int)$db->insert_id;
    if (!$id) $id = (int)$db->get_var("SELECT LAST_INSERT_ID()");
    return $id;
}

/** Deposito (INT) para ope_paquetes: por ahora NULL para no romper. */
function depositoSql($depositoNombre) {
    // TODO: mapear nombre → id si corresponde
    return "NULL";
}

function crearPaquete($db, $bloqueId, $productoId, $lote, $vencimiento, $cantidad, $observacion = null, $depositoNombre = null, $pallets = 1) {
    $bloqueId   = intval($bloqueId);
    $productoId = intval($productoId);
    $cantidad   = ($cantidad === '' || $cantidad === null) ? 0 : intval($cantidad);

    $loteSql = $lote !== '' ? "'" . addslashes($lote) . "'" : "NULL";
    $vencSql = ($vencimiento && $vencimiento !== '--') ? "'" . addslashes($vencimiento) . "'" : "NULL";
    $obsSql  = $observacion !== '' ? "'" . addslashes($observacion) . "'" : "NULL";
    $depSql  = depositoSql($depositoNombre);

    $db->query("
        INSERT INTO ope_paquetes
            (producto_id, bloque_id, pallets, cajas, unidadespicka, unidades, stock, lote, fecha_vencimiento, observacion, estado_id, deposito, created_at)
        VALUES
            ($productoId, $bloqueId, ".intval($pallets).", 0, 0, $cantidad, $cantidad, $loteSql, $vencSql, $obsSql, 1, $depSql, NOW())
    ");
    return (int)($db->insert_id ?: $db->get_var("SELECT LAST_INSERT_ID()"));
}

function actualizarPaquete($db, $paqueteId, $productoId, $lote, $vencimiento, $cantidad, $observacion = null, $depositoNombre = null, $pallets = 1) {
    $paqueteId  = intval($paqueteId);
    $productoId = intval($productoId);
    $cantidad   = ($cantidad === '' || $cantidad === null) ? 0 : intval($cantidad);

    $loteSql = $lote !== '' ? "'" . addslashes($lote) . "'" : "NULL";
    $vencSql = ($vencimiento && $vencimiento !== '--') ? "'" . addslashes($vencimiento) . "'" : "NULL";
    $obsSql  = $observacion !== '' ? "'" . addslashes($observacion) . "'" : "NULL";
    $depSql  = depositoSql($depositoNombre);

    $db->query("
        UPDATE ope_paquetes
        SET producto_id = $productoId,
            pallets = ".intval($pallets).",
            cajas = 0,
            unidadespicka = 0,
            unidades = $cantidad,
            stock = $cantidad,
            lote = $loteSql,
            fecha_vencimiento = $vencSql,
            observacion = $obsSql,
            deposito = $depSql,
            updated_at = NOW()
        WHERE id = $paqueteId
    ");
}

/* =========================
   INPUTS
   ========================= */
$deposito = $_POST['deposito'] ?? '';
$rack     = $_POST['rack'] ?? '';
$columna  = $_POST['columna'] ?? '';
$nivel    = $_POST['nivel'] ?? '';
$fondo    = $_POST['fondo'] ?? '';
$modo     = $_POST['modo'] ?? 'picking'; // 'normal' | 'picking'

$pallets = $_POST['pallets'] ?? [];

if (!$deposito || !$rack || !$columna || !$nivel || !$fondo) {
    echo json_encode(['success' => false, 'error' => 'Faltan datos de ubicación.']); exit;
}

// Posición
$posicion = $db->get_var("
    SELECT id FROM ope_layout
    WHERE deposito = '".$db->escape($deposito)."'
      AND rack     = '".$db->escape($rack)."'
      AND columna  = '".$db->escape($columna)."'
      AND nivel    = '".$db->escape($nivel)."'
      AND fondo    = '".$db->escape($fondo)."'
");
if (!$posicion) {
    echo json_encode(['success' => false, 'error' => 'No se encontró la posición en el layout.']); exit;
}

$rangoHoy = hoyUtcRangeByAsuncion();
$resultados = [];
$bloqueIdUsado = null;

foreach ($pallets as $p) {
    // Para picking:
    $bloqueIdPost  = isset($p['bloque_id'])  ? trim((string)$p['bloque_id'])  : '';
    $paqueteIdPost = isset($p['paquete_id']) ? trim((string)$p['paquete_id']) : '';

    // En NORMAL: pallets[0][id] = bloque_id deseado
    $bloqueIdDesdeId = isset($p['id']) ? trim((string)$p['id']) : '';

    $codigo      = $p['cod'] ?? '';
    $lote        = $p['lote'] ?? '';
    $dia         = $p['dia'] ?? '';
    $mes         = $p['mes'] ?? '';
    $anio        = $p['anio'] ?? '';
    $cantidad    = $p['cantidad'] ?? '';
    $observacion = trim($p['observacion'] ?? '');

    $vencimiento = '';
    if ($anio || $mes || $dia) {
        $vencimiento = str_pad($anio, 4, '0', STR_PAD_LEFT) . '-' .
                       str_pad($mes, 2, '0', STR_PAD_LEFT) . '-' .
                       str_pad($dia, 2, '0', STR_PAD_LEFT);
    }

    // Validar producto
    $rowProducto = $db->get_row("SELECT id, color_web FROM para_productos WHERE cod = '".$db->escape($codigo)."'");
    if (!$rowProducto) {
        $resultados[] = ['id' => null, 'accion' => 'error', 'error' => 'Código de producto no válido.'];
        continue;
    }
    $productoId = (int)$rowProducto->id;
    $color_web  = $rowProducto->color_web;
    $color_web  = $color_web ? (strpos($color_web, '#') === 0 ? $color_web : ('#' . $color_web)) : '#f9f9f9';

    if ($modo === 'normal') {
        /* =========================
           MODO NORMAL (ENTERO)
           ========================= */
        $forceId  = ($bloqueIdDesdeId !== '') ? intval($bloqueIdDesdeId) : null;
        $bloqueId = ensureBloqueHoy($db, $posicion, $usuario, $forceId);
        $bloqueIdUsado = $bloqueId;

        ensureBloquePosicion($db, $bloqueId, $posicion);

        // Upsert en ctrl_conteo (num_pallet = bloque_id)
        $conteoId = $db->get_var("
            SELECT id FROM ".TABLA_CONTEO."
            WHERE posicion_id = ".intval($posicion)."
              AND num_pallet  = '".$db->escape($bloqueId)."'
              AND created_at >= '{$rangoHoy['start']}' AND created_at < '{$rangoHoy['end']}'
            ORDER BY id ASC LIMIT 1
        ");

        $loteSql = $lote !== '' ? "'" . addslashes($lote) . "'" : "NULL";
        $vencSql = $vencimiento !== '' ? "'" . addslashes($vencimiento) . "'" : "NULL";
        $obsSql  = $observacion !== '' ? "'" . addslashes($observacion) . "'" : "NULL";
        $cant    = ($cantidad === '' || $cantidad === null) ? 0 : intval($cantidad);

        if ($conteoId) {
            $db->query("
                UPDATE ".TABLA_CONTEO."
                SET producto = $productoId,
                    lote = $loteSql,
                    vencimiento = $vencSql,
                    cantidad = $cant,
                    observacion = $obsSql,
                    updated_at = NOW(),
                    responsable_id = ".intval($usuario)."
                WHERE id = $conteoId
            ");
            $accion = 'actualizado';
        } else {
            $db->query("
                INSERT INTO ".TABLA_CONTEO."
                    (posicion_id, num_pallet, producto, lote, vencimiento, cantidad, observacion, created_at, responsable_id)
                VALUES
                    (".intval($posicion).", '".$db->escape($bloqueId)."', $productoId, $loteSql, $vencSql, $cant, $obsSql, NOW(), ".intval($usuario).")
            ");
            $accion = 'insertado';
        }

        // (opcional) upsert de paquete del bloque en modo normal
        if (MODO_CREACION_PICKING) {
            $paqueteId = $db->get_var("
                SELECT id FROM ope_paquetes
                WHERE bloque_id = $bloqueId
                  AND created_at >= '{$rangoHoy['start']}' AND created_at < '{$rangoHoy['end']}'
                ORDER BY id ASC LIMIT 1
            ");
            if ($paqueteId) {
                actualizarPaquete($db, $paqueteId, $productoId, $lote, $vencimiento, $cant, $observacion, $deposito, 1);
            } else {
                crearPaquete($db, $bloqueId, $productoId, $lote, $vencimiento, $cant, $observacion, $deposito, 1);
            }
        }

        $resultados[] = [
            'id'        => (string)$bloqueId,
            'accion'    => $accion,
            'color_web' => $color_web,
            'codigo'    => $codigo
        ];

    } else {
        /* =========================
           MODO PICKING
           - paquetes: create/update
           - contar también en ctrl_conteo (num_pallet = paqueteId)
           ========================= */
        $bloqueId = ($bloqueIdPost !== '') ? intval($bloqueIdPost) : ensureBloqueHoy($db, $posicion, $usuario, null);
        $bloqueIdUsado = $bloqueId;

        ensureBloquePosicion($db, $bloqueId, $posicion);

        $cant = ($cantidad === '' || $cantidad === null) ? 0 : intval($cantidad);

        if ($paqueteIdPost !== '') {
            $paqueteId = intval($paqueteIdPost);
            actualizarPaquete($db, $paqueteId, $productoId, $lote, $vencimiento, $cant, $observacion, $deposito, 1);
            $accion = 'actualizado';
        } else {
            $paqueteId = crearPaquete($db, $bloqueId, $productoId, $lote, $vencimiento, $cant, $observacion, $deposito, 1);
            $accion = 'insertado';
        }

        /* ===== NUEVO: UP SERT EN ctrl_conteo PARA PICKING =====
           Clave: num_pallet = paqueteId (1 registro por paquete)
        */
        $conteoPickId = $db->get_var("
            SELECT id FROM ".TABLA_CONTEO."
            WHERE posicion_id = ".intval($posicion)."
              AND num_pallet  = '".$db->escape($paqueteId)."'
              AND created_at >= '{$rangoHoy['start']}' AND created_at < '{$rangoHoy['end']}'
            ORDER BY id ASC LIMIT 1
        ");

        $loteSql = $lote !== '' ? "'" . addslashes($lote) . "'" : "NULL";
        $vencSql = $vencimiento !== '' ? "'" . addslashes($vencimiento) . "'" : "NULL";
        $obsSql  = $observacion !== '' ? "'" . addslashes($observacion) . "'" : "NULL";

        if ($conteoPickId) {
            $db->query("
                UPDATE ".TABLA_CONTEO."
                SET producto = $productoId,
                    lote = $loteSql,
                    vencimiento = $vencSql,
                    cantidad = $cant,
                    observacion = $obsSql,
                    updated_at = NOW(),
                    responsable_id = ".intval($usuario)."
                WHERE id = $conteoPickId
            ");
        } else {
            $db->query("
                INSERT INTO ".TABLA_CONTEO."
                    (posicion_id, num_pallet, producto, lote, vencimiento, cantidad, observacion, created_at, responsable_id)
                VALUES
                    (".intval($posicion).", '".$db->escape($paqueteId)."', $productoId, $loteSql, $vencSql, $cant, $obsSql, NOW(), ".intval($usuario).")
            ");
        }
        /* ===== FIN NUEVO ===== */

        $resultados[] = [
            'id'        => (string)$paqueteId,
            'bloque_id' => (string)$bloqueId,
            'accion'    => $accion,
            'color_web' => $color_web,
            'codigo'    => $codigo
        ];
    }

    /* ========= Email si hay observación ========= */
    if ($observacion !== '') {
        try {
            $mail = new PHPMailer(true);
            $mail->isSMTP();
            $mail->Host       = 'smtp.office365.com';
            $mail->SMTPAuth   = true;
            $mail->Username   = 'no@broumarketpy.onmicrosoft.com';
            $mail->Password   = 'YHgxt137';
            $mail->SMTPSecure = 'tls';
            $mail->Port       = 587;

            $mail->setFrom('sistema@arasait.com', 'Sistema LayoutInteractivo');
            $mail->addAddress('raul@arasait.com');
            $mail->isHTML(false);
            $mail->Subject = "Nueva Observación en Conteo de Pallet";
            $mail->Body    = "Se ha registrado una observación:\n\n" .
                "Depósito: $deposito\nRack: $rack\nColumna: $columna\nNivel: $nivel\nFondo: $fondo\n" .
                "Bloque ID: ".($bloqueIdUsado ?: 'N/D')."\nCódigo: $codigo\nLote: $lote\nVencimiento: $vencimiento\nCantidad: $cantidad\n\n" .
                "Observaciones:\n$observacion\n\n" .
                "Registrado el " . (new DateTime('now', new DateTimeZone('America/Asuncion')))->format('d/m/Y H:i:s');
            $mail->send();
        } catch (Exception $e) {
            error_log("No se pudo enviar el mail. Mailer Error: {$mail->ErrorInfo}");
        }
    }
}

// Respuesta
echo json_encode([
    'success'      => true,
    'posicion_id'  => $posicion,
    'bloque_id'    => $bloqueIdUsado,
    'resultados'   => $resultados
]);
