<?php
session_start();

$usuario = $_SESSION['usuario_id'] ?? 42;

require __DIR__ . '/vendor/autoload.php'; // Ajusta la ruta si tu fnContar.php está en otra carpeta

include_once '../libreria/ezSql/ez_sql_core.php';
include_once '../libreria/ezSql/ez_sql_pdo.php';
include_once '../libreria/ezSql/conect.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$deposito = $_POST['deposito'] ?? '';
$rack = $_POST['rack'] ?? '';
$columna = $_POST['columna'] ?? '';
$nivel = $_POST['nivel'] ?? '';
$fondo = $_POST['fondo'] ?? '';
$idPallet = $_POST['id'] ?? '';
$codigo = $_POST['cod'] ?? '';
$lote = $_POST['lote'] ?? '';
$vencimientodia = $_POST['vencimiento-dia'] ?? '';
$vencimientomes = $_POST['vencimiento-mes'] ?? '';
$vencimientoanio = $_POST['vencimiento-anio'] ?? '';
$vencimiento = str_pad($vencimientoanio, 4, '0', STR_PAD_LEFT) . '-' . str_pad($vencimientomes, 2, '0', STR_PAD_LEFT) . '-' . str_pad($vencimientodia, 2, '0', STR_PAD_LEFT);
$cantidad = $_POST['cantidad'] ?? '';
$observacion = trim($_POST['observacion'] ?? '');

if ($idPallet == 0) {
    // 1. Obtener ID de la posición
    $posicion = $db->get_var("
        SELECT id 
        FROM ope_layout 
        WHERE deposito = '$deposito' 
        AND rack = '$rack' 
        AND columna = '$columna' 
        AND nivel = '$nivel' 
        AND fondo = '$fondo'
    ");

    if (!$posicion) {
        echo json_encode(['success' => false, 'error' => 'No se encontró la posición en el layout.']);
        exit;
    }
    // Si idPallet es 0, permitir pasar sin chequear el resto
    $db->query("
        DELETE FROM ctrl_conteo WHERE posicion_id = $posicion AND DATE(created_at) = CURDATE()
    ");
    echo json_encode(['success' => true, 'message' => 'Posición borrada correctamente.']);
    exit;
} else {
    // Si idPallet no es 0, chequear los campos obligatorios
    if (
        !$deposito ||
        !$rack ||
        !$columna ||
        !$nivel ||
        !$fondo ||
        !$codigo
    ) {
        echo json_encode(['success' => false, 'error' => 'Faltan datos obligatorios.']);
        exit;
    }
}

// 1. Obtener ID de la posición
$posicion = $db->get_var("
    SELECT id 
    FROM ope_layout 
    WHERE deposito = '$deposito' 
      AND rack = '$rack' 
      AND columna = '$columna' 
      AND nivel = '$nivel' 
      AND fondo = '$fondo'
");

if (!$posicion) {
    echo json_encode(['success' => false, 'error' => 'No se encontró la posición en el layout.']);
    exit;
}

// 2. Obtener ID del producto y color
$rowProducto = $db->get_row("
    SELECT id, color_web
    FROM para_productos
    WHERE cod = '$codigo'
");
if (!$rowProducto) {
    echo json_encode(['success' => false, 'error' => 'Código de producto no válido.']);
    exit;
}
$producto = $rowProducto->id;
$color_web = $rowProducto->color_web;
$color_web = $color_web ? (strpos($color_web, '#') === 0 ? $color_web : ('#' . $color_web)) : '#f9f9f9';

// 3. Verificar si ya existe un registro hoy
$conteoExistente = $db->get_var("
    SELECT id 
    FROM ctrl_conteo 
    WHERE posicion_id = $posicion 
      AND DATE(created_at) = CURDATE()
");
// 3.1 Verificar si ya existe un registro hoy
$otraPosicion = null;

if ($idPallet && $idPallet != 0) {
    // Busca si este pallet ya fue contado hoy en otra posición diferente a la actual
    $sqlDuplicado = "
            SELECT posicion_id 
            FROM ctrl_conteo 
            WHERE num_pallet = '$idPallet' 
            AND DATE(created_at) = CURDATE()
            AND posicion_id != $posicion
            LIMIT 1
        ";
    $posicionDuplicada = $db->get_var($sqlDuplicado);

    if ($posicionDuplicada) {
        // Busca la descripción de la otra posición
        $descPos = $db->get_row("
                SELECT CONCAT(deposito, ' - ', rack, ' - ', columna, ' - ', nivel, ' - ', fondo) as posdesc
                FROM ope_layout
                WHERE id = $posicionDuplicada
                LIMIT 1
            ");
        $otraPosicion = $descPos ? $descPos->posdesc : $posicionDuplicada;
    }
}


// 4. Insertar o actualizar
if ($conteoExistente) {

    // Actualizar
    $db->query("
        UPDATE ctrl_conteo 
        SET num_pallet = '$idPallet',
            producto = $producto,
            lote = '$lote',
            vencimiento = '$vencimiento',
            cantidad = '$cantidad',
            observacion = " . ($observacion ? "'" . addslashes($observacion) . "'" : "NULL") . ",
            updated_at = NOW(),
            responsable_id = $usuario
        WHERE id = $conteoExistente
    ");
    $accion = "actualizado";
} else {
    // Insertar
    $db->query("
        INSERT INTO ctrl_conteo 
            (posicion_id, num_pallet, producto, lote, vencimiento, cantidad, observacion, created_at, responsable_id)
        VALUES 
            ($posicion, '$idPallet', $producto, '$lote', '$vencimiento', '$cantidad', " . ($observacion ? "'" . addslashes($observacion) . "'" : "NULL") . ", NOW(), $usuario)
    ");
    $accion = "guardado";
}


if ($otraPosicion) {
    $msg = "⚠️ Atención: Este pallet ya fue contado en la posición:\n$otraPosicion\n(Se actualizó igualmente)";
} else {
    $msg = "✅ Conteo $accion correctamente.";
}



// Enviar mail solo si hay observación

if ($observaciones !== '') {
    $mail = new PHPMailer(true);

    try {
        $mail->isSMTP();
        $mail->Host       = 'smtp.office365.com';   // Cambia por tu SMTP real
        $mail->SMTPAuth   = true;
        $mail->Username   = 'no@broumarketpy.onmicrosoft.com'; // Cambia por tu usuario SMTP
        $mail->Password   = 'YHgxt137';         // Cambia por tu contraseña
        $mail->SMTPSecure = 'ssl';                // tls O 'ssl' si tu servidor lo requiere
        $mail->Port       = 587;                  // O 465 para 'ssl'

        $mail->setFrom('sistema@arasait.com', 'Sistema LayoutInteractivo');
        $mail->addAddress('raul@arasait.com');
        // Si quieres agregar más CC:
        // $mail->addCC('otro@correo.com');

        $mail->isHTML(false);
        $mail->Subject = "Nueva Observación en Conteo de Pallet";
        $mail->Body    = "Se ha registrado una observación:\n\n" .
            "Depósito: $deposito\nRack: $rack\nColumna: $columna\nNivel: $nivel\nFondo: $fondo\n" .
            "ID Pallet: $idPallet\nCódigo: $codigo\nLote: $lote\nVencimiento: $vencimiento\nCantidad: $cantidad\n\n" .
            "Observaciones:\n$observaciones\n\n" .
            "Registrado el " . date('d/m/Y H:i:s');

        $mail->send();
        // Si quieres log o mensaje de éxito, aquí
    } catch (Exception $e) {
        // Puedes registrar el error en un log
        error_log("No se pudo enviar el mail. Mailer Error: {$mail->ErrorInfo}");
    }
}

echo json_encode([
    'success' => true,
    'message' => $msg,
    'color_web' => $color_web,
    'posicion_id' => $posicion,
    'idPallet' => $idPallet,
    'codigo' => $codigo
]);
