function renderLayoutParaFecha(fecha) {
    if (!fecha || !window.depositoLayout) {
        $("#contenedor-layout").html('<div class="text-muted">No hay datos para mostrar.</div>');
        return;
    }
    const posicionesContadas = window.posicionesPorFecha[fecha] || [];
    const posicionesColor = window.coloresPorFecha[fecha] || {};

    let html = `<h4 class="mb-4">Fecha: ${fecha}</h4><div class="row-24">`;
    // Suponiendo que depositoLayout solo tiene el depósito seleccionado:
    for (const deposito in window.depositoLayout) {
        for (const rack in window.depositoLayout[deposito]) {
            for (const columna in window.depositoLayout[deposito][rack]) {
                html += `<div class="col-24 columna text-center">`;
                for (const nivel in window.depositoLayout[deposito][rack][columna]) {
                    html += `<div class="nivel"><div class="titulo-seccion mb-2">${rack} <br> ${columna} - ${nivel}</div>`;
                    let fondos = window.depositoLayout[deposito][rack][columna][nivel];
                    fondos.forEach((fondo, idx) => {
                        // Necesitas saber el ID de la posición, probablemente puedes agregarlo como value en tu layout (ajusta el backend si hace falta)
                        // Por simplicidad, aquí solo uso índices
                        let posicionId = null;
                        // Si en tu estructura puedes saber el id real, úsalo
                        // Ejemplo: posicionId = window.depositoLayout[deposito][rack][columna][nivel][idx].id;
                        // Aquí asumimos que los fondos están ordenados igual
                        posicionId = fondos[idx];
                        let esContado = posicionesContadas.includes(posicionId);
                        let cuboColor = esContado ? '#' + (posicionesColor[posicionId] || 'f9f9f9') : '#f9f9f9';
                        let className = 'cuadro-posicion' + (esContado ? ' contado' : '');
                        html += `<div class="${className}" style="background-color: ${cuboColor}" 
                            data-deposito="${deposito}"
                            data-rack="${rack}"
                            data-columna="${columna}"
                            data-nivel="${nivel}"
                            data-fondo="${fondo}">
                            ${fondo}
                        </div>`;
                    });
                    html += `</div>`;
                }
                html += `</div>`;
            }
        }
    }
    html += `</div>`;
    $("#contenedor-layout").html(html);
}
