<?php
session_start();
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
$error = $_GET['error'] ?? '';
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="utf-8">
    <title>Login BMSA</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap CSS CDN (última versión estable) -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: #f5f5f5;
        }

        .login-container {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .login-card {
            max-width: 400px;
            padding: 2rem;
            border-radius: 1.5rem;
            box-shadow: 0 0 20px #0001;
        }
    </style>
</head>

<body>
    <div class="login-container">
        <div class="login-card bg-white">
            <div class="row justify-content-center mb-2">
                <div class="col-12 text-center">
                    <img src="img/logo.png" alt="BMSA" class="img-fluid mb-3" style="max-height: 16vh; max-width: 80vw;">
                </div>
                <div class="col-12">
                    <h4 class="text-center mb-4 fw-bold">Ingreso al Conteo de depósitos</h4>
                </div>
            </div>
            <?php if ($error): ?>
                <div class="alert alert-danger small"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>
            <form method="post" action="procesar.php" autocomplete="off">
                <div class="mb-3">
                    <label for="usuario" class="form-label">Usuario</label>
                    <input type="text" class="form-control form-control-lg" id="usuario" name="usuario" required autofocus>
                    <!-- <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>"> -->
                </div>
                <div class="mb-3 position-relative">
                    <label for="password" class="form-label">Contraseña</label>
                    <input type="password" class="form-control form-control-lg" id="password" name="password" required>
                    <button type="button" id="togglePassword" tabindex="-1"
                        class="btn btn-link position-absolute end-0 top-0 mt-3 me-3 p-0"
                        style="z-index:10; color: #333;">
                        <i class="bi bi-eye-slash" id="iconoPassword"></i>
                    </button>
                </div>
                <button type="submit" class="btn btn-primary btn-lg w-100">Ingresar</button>
            </form>
            <div class="mt-3 text-center">
                <small class="text-muted">© <?= date('Y') ?> by arasaIT</small>
            </div>
        </div>
    </div>
    <script>
        document.getElementById('togglePassword').addEventListener('click', function() {
            const input = document.getElementById('password');
            const icon = document.getElementById('iconoPassword');
            if (input.type === "password") {
                input.type = "text";
                icon.classList.remove('bi-eye-slash');
                icon.classList.add('bi-eye');
            } else {
                input.type = "password";
                icon.classList.remove('bi-eye');
                icon.classList.add('bi-eye-slash');
            }
        });
    </script>

</body>

</html>