<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include_once '../libreria/ezSql/ez_sql_core.php';
include_once '../libreria/ezSql/ez_sql_pdo.php';
include_once '../libreria/ezSql/conect.php';

$depositoSeleccionado = $_POST['deposito'] ?? '';
$rackSeleccionado = $_POST['rack'] ?? '';

$depositoLayout = [];

if ($depositoSeleccionado && $rackSeleccionado) {
    $depositoSeleccionado = addslashes($depositoSeleccionado);
    $rackSeleccionado = addslashes($rackSeleccionado);

    $query = "
        SELECT deposito, rack, columna, nivel, fondo
        FROM ope_layout
        WHERE deposito = '$depositoSeleccionado'
          AND rack = '$rackSeleccionado'
        ORDER BY columna, nivel, fondo
    ";

    $resultados = $db->get_results($query);

    foreach ($resultados as $fila) {
        $depositoLayout[$fila->deposito][$fila->rack][$fila->columna][$fila->nivel][] = $fila->fondo;
    }
}

// Para el select de depósitos
$depositos = $db->get_results("SELECT DISTINCT deposito FROM ope_layout ORDER BY deposito");


// $deposito = [
//     'Deposito 1' => [
//         'Rack A' => [
//             'Columna A' => [
//                 'Nivel 1' => [1, 2, 3, 4],
//                 'Nivel 2' => [1, 2, 3, 4],
//                 'Nivel 3' => [1, 2, 3, 4],
//             ],
//             'Columna B' => [
//                 'Nivel 1' => [1, 2],
//                 'Nivel 2' => [1, 2],
//             ],
//         ],
//         'Rack B' => [
//             'Columna C' => [
//                 'Nivel 1' => [1, 2],
//                 'Nivel 2' => [1, 2],
//             ],
//         ],
//     ]
// ];

?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <title>Layout Interactivo de Depósito</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="layoutInteractivo.css" rel="stylesheet">

</head>

<body>
    <div class="container py-4">
        <h1 class="text-center mb-5">🗄️ Layout Interactivo de Depósito</h1>


        <div class="container">
            <form method="POST" class="row g-3 mb-4">
                <div class="col-12 col-md-5">
                    <label for="deposito" class="form-label">Depósito</label>
                    <select name="deposito" id="deposito" class="form-select" required>
                        <option value="">Seleccionar...</option>
                        <?php foreach ($depositos as $dep): ?>
                            <option value="<?= $dep->deposito ?>" <?= $depositoSeleccionado === $dep->deposito ? 'selected' : '' ?>><?= $dep->deposito ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="col-12 col-md-5">
                    <label for="rack" class="form-label">Rack</label>
                    <select name="rack" id="rack" class="form-select" required <?= !$depositoSeleccionado ? 'disabled' : '' ?>>
                        <option value="">Seleccionar...</option>
                        <?php if ($rackSeleccionado): ?>
                            <option selected><?= $rackSeleccionado ?></option>
                        <?php endif; ?>
                    </select>
                </div>

                <div class="col-12 col-md-2 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">Ver layout</button>
                </div>
            </form>
        </div>


        <?php if ($depositoSeleccionado && $rackSeleccionado): ?>
            <?php foreach ($depositoLayout as $nombreDeposito => $racks): ?>
                <div class="mb-4">
                    <h3 class="titulo-seccion">🧱 D - <?= $nombreDeposito ?></h3>

                    <?php foreach ($racks as $nombreRack => $columnas): ?>
                        <div class="mb-3 ps-3">
                            <h5 class="titulo-seccion">📦 RACK - <?= $nombreRack ?></h5>
                            <div class="row">
                                <?php foreach ($columnas as $nombreColumna => $niveles): ?>
                                    <div class="col-12 col-md-1 columna">
                                        <div class="titulo-seccion">🏗️ COL - <?= $nombreColumna ?></div>

                                        <?php foreach ($niveles as $nombreNivel => $fondos): ?>
                                            <div class="nivel">
                                                <div class="titulo-seccion">📶 NL <?= $nombreNivel ?></div>
                                                <?php foreach ($fondos as $index => $color): ?>
                                                    <div
                                                        class="fondo-cubo"
                                                        data-deposito="<?= $nombreDeposito ?>"
                                                        data-rack="<?= $nombreRack ?>"
                                                        data-columna="<?= $nombreColumna ?>"
                                                        data-nivel="<?= $nombreNivel ?>"
                                                        data-fondo="<?= $index + 1 ?>">
                                                        <div class="cubo-inner">
                                                            <?php for ($face = 0; $face < 6; $face++): ?>
                                                                <div class="cara <?= ['front', 'back', 'right', 'left', 'top', 'bottom'][$face] ?>"></div>
                                                            <?php endfor; ?>
                                                        </div>
                                                    </div>

                                                <?php endforeach; ?>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="container text-center text-muted">
                <p>Seleccioná un depósito y un rack para ver el layout.</p>
            </div>
        <?php endif; ?>
    </div>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="layoutInteractivo.js"></script>
</body>

</html>