$(document).ready(function() {
    $('.fondo-cubo').on('click', function() {
        const $cubos = $(this).find('.cara');
        const actual = $cubos.css('background-color');
        const naranja = 'rgb(243, 156, 18)'; // color en formato RGB

        // Alternar entre blanco y naranja
        $cubos.css('background-color', actual === naranja ? '#ffffff' : '#f39c12');

        // Alerta con datos
        const deposito = $(this).data('deposito');
        const rack = $(this).data('rack');
        const columna = $(this).data('columna');
        const nivel = $(this).data('nivel');
        const fondo = $(this).data('fondo');

        console.log(`🧱 Selección:
        - Depósito: ${deposito}
        - Rack: ${rack}
        - Columna: ${columna}
        - Nivel: ${nivel}
        - Fondo: ${fondo}`);
    });

    $('#deposito').on('change', function() {
        const deposito = $(this).val();
        $('#rack').prop('disabled', true).html('<option value="">Cargando...</option>');

        if (deposito) {
            $.getJSON('getRacks.php', { deposito }, function(racks) {
                let options = '<option value="">Seleccionar...</option>';
                racks.forEach(function(rack) {
                    options += `<option value="${rack}">${rack}</option>`;
                });
                $('#rack').html(options).prop('disabled', false);
            });
        } else {
            $('#rack').html('<option value="">Seleccionar...</option>');
        }
    });
});
