<?php
session_start();
include_once '../libreria/ezSql/ez_sql_core.php';
include_once '../libreria/ezSql/ez_sql_pdo.php';
include_once '../libreria/ezSql/conect.php';

define('TABLA_CONTEO', 'ctrl_conteo'); // tu tabla de conteo real

// POST
$deposito = $_POST['deposito'] ?? '';
$rack     = $_POST['rack'] ?? '';
$columna  = $_POST['columna'] ?? '';
$nivel    = $_POST['nivel'] ?? '';
$fondo    = $_POST['fondo'] ?? '';

// Posición
$posicion = $db->get_var("
    SELECT id FROM ope_layout
    WHERE deposito = '".$db->escape($deposito)."'
      AND rack     = '".$db->escape($rack)."'
      AND columna  = '".$db->escape($columna)."'
      AND nivel    = '".$db->escape($nivel)."'
      AND fondo    = '".$db->escape($fondo)."'
");

$response = ['existe' => false, 'modo' => 'picking', 'posicion_id' => $posicion ?: null, 'bloque_id' => null, 'datos' => []];

if ($posicion) {
    // ===== 1) Intentar MODO NORMAL primero (ctrl_conteo de HOY para esa posición) =====
    $rowConteo = $db->get_row("
        SELECT c.*, b.id AS bloque_id, pr.cod
        FROM ".TABLA_CONTEO." c
        JOIN ope_bloques b   ON b.id = c.num_pallet
        LEFT JOIN para_productos pr ON pr.id = c.producto
        WHERE c.posicion_id = ".intval($posicion)."
          AND DATE(c.created_at) = CURDATE()
        ORDER BY c.id ASC
        LIMIT 1
    ");

    // $db->debug();

    if ($rowConteo && $rowConteo->bloque_id) {
        $response['modo']      = 'normal';
        $response['existe']    = true;
        $response['bloque_id'] = (string)$rowConteo->bloque_id;

        $vDia = $vMes = $vAnio = '';
        if (!empty($rowConteo->vencimiento)) {
            [$vAnio, $vMes, $vDia] = explode('-', $rowConteo->vencimiento);
        }

        $response['datos'][] = [
            // IMPORTANTE: id == bloque_id para NORMAL
            'id_conteo'       => (string)$rowConteo->id,
            'id'              => (string)$rowConteo->bloque_id,
            'cod'             => $rowConteo->cod,
            'lote'            => $rowConteo->lote,
            'vencimientodia'  => $vDia,
            'vencimientomes'  => $vMes,
            'vencimientoanio' => $vAnio,
            'observacion'     => $rowConteo->observacion,
            'cantidad'        => $rowConteo->cantidad,
            'bloque_id'       => (string)$rowConteo->bloque_id
        ];
        $bloqueId = $rowConteo->bloque_id;

        header('Content-Type: application/json');
        echo json_encode($response);
        exit;
    }

    // ===== 2) Si no hay NORMAL hoy, ver si hay BLOQUE hoy → MODO PICKING =====
    // $bloqueId = $db->get_var("
    //     SELECT id FROM ope_bloques
    //     WHERE posicion_id = ".intval($posicion)." AND DATE(created_at) = CURDATE()
    //     ORDER BY id ASC LIMIT 1
    // ");






    if ($bloqueId) {
        $response['modo']      = 'picking';
        $response['bloque_id'] = (string)$bloqueId;

        $paqs = $db->get_results("
            SELECT p.id AS paquete_id,
                   pr.cod AS cod,
                   p.lote,
                   p.fecha_vencimiento AS vencimiento,
                   p.unidades AS cantidad,
                   p.observacion
            FROM ope_paquetes p
            LEFT JOIN para_productos pr ON pr.id = p.producto_id
            WHERE p.bloque_id = ".intval($bloqueId)." AND DATE(p.created_at) = CURDATE()
            ORDER BY p.id ASC
        ");

        if ($paqs) {
            $response['existe'] = true;
            foreach ($paqs as $row) {
                $vDia = $vMes = $vAnio = '';
                if (!empty($row->vencimiento)) {
                    [$vAnio, $vMes, $vDia] = explode('-', $row->vencimiento);
                }
                $response['datos'][] = [
                    'paquete_id'     => (string)$row->paquete_id,
                    'bloque_id'      => (string)$bloqueId,
                    'cod'            => $row->cod,
                    'lote'           => $row->lote,
                    'vencimientodia' => $vDia,
                    'vencimientomes' => $vMes,
                    'vencimientoanio'=> $vAnio,
                    'observacion'    => $row->observacion,
                    'cantidad'       => $row->cantidad
                ];
            }
        }
    } else {
        // Sin conteo ni bloque hoy => default picking sin datos
        $response['modo'] = 'picking';
    }
}

header('Content-Type: application/json');
echo json_encode($response);
