let fechas = window.fechasDisponibles || [];

// console.log("window.fechasDisponibles:", window.fechasDisponibles);
// console.log("fechas:", fechas);

if (!Array.isArray(fechas) || fechas.length === 0) {
  // No hay fechas, no inicies carrusel
  document.getElementById("contenedor-layout").innerHTML =
    "<div class='text-center text-muted'>No hay fechas disponibles para mostrar.</div>";
} else {
  let idx = 0;
  function siguienteFechaCarrusel() {
    renderLayoutParaFecha(fechas[idx]);
    idx = (idx + 1) % fechas.length;
  }
  siguienteFechaCarrusel();
  setInterval(siguienteFechaCarrusel, 3000);
}

let cuboSeleccionado = null;
$(document).ready(function () {
  $(".fondo-cubo").on("click", function () {
    cuboSeleccionado = $(this);

    // Limpiar campos primero
    $("#formCubo")[0].reset();

    // Obtener datos del cubo
    const deposito = $(this).data("deposito");
    const rack = $(this).data("rack");
    const columna = $(this).data("columna");
    const nivel = $(this).data("nivel");
    const fondo = $(this).data("fondo");

    // Cargar en campos ocultos
    $("#ubicacionDeposito").val(deposito);
    $("#ubicacionRack").val(rack);
    $("#ubicacionColumna").val(columna);
    $("#ubicacionNivel").val(nivel);
    $("#ubicacionFondo").val(fondo);

    // Título informativo del modal
    $("#modalFormularioLabel").html(
      `📦 Pallet: ${deposito} / ${rack} / ${columna} / Nivel ${nivel} / Fondo ${fondo}`
    );

    // Mostrar el modal
    const modal = new bootstrap.Modal(
      document.getElementById("modalFormulario")
    );
    modal.show();

    // Hacer petición AJAX para obtener datos existentes
    $.ajax({
      url: "obtener_pallet.php", // Archivo PHP que consultará la base de datos
      type: "POST",
      dataType: "json",
      data: {
        deposito: deposito,
        rack: rack,
        columna: columna,
        nivel: nivel,
        fondo: fondo,
      },
      success: function (response) {
        if (response.existe) {
          // Si existe el pallet, llenamos los campos
          $("#palletId").val(response.datos.id);
          $("#cod").val(response.datos.cod);
          $("#lote").val(response.datos.lote);
          $("#vencimiento").val(response.datos.vencimiento);
          $("#cantidad").val(response.datos.cantidad);
        } else {
          // Si no existe, dejamos los campos vacíos (ya están reseteados)
          console.log("No hay datos para esta ubicación");
        }
      },
      error: function (xhr, status, error) {
        console.error("Error al obtener datos del pallet:", error);
      },
    });
  });
});

$(document).ready(function () {
  $("#formVerLayout").on("submit", function (e) {
    e.preventDefault();
    cargarLayoutPorAjax();
  });

  // Cuando cambie algún filtro, dispara el submit (NO hace ajax aquí, solo submit)
  $("#deposito, #fechaConteo1, #fechaConteo2").on("change", function () {
    $("#formVerLayout").submit();
  });

  $("#formCubo").on("submit", function (e) {
    e.preventDefault();

    const datos = $(this).serialize();

    $.ajax({
      url: "fnContar.php",
      method: "POST",
      data: datos,
      dataType: "json",
      success: function (respuesta) {
        if (respuesta.success) {
          alert("✅ " + respuesta.message);

          // Remover foco activo antes de cerrar el modal
          document.activeElement.blur();

          // Cerrar el modal
          const modalElement = document.getElementById("modalFormulario");
          const modalInstance = bootstrap.Modal.getInstance(modalElement);
          if (modalInstance) {
            modalInstance.hide();
          }

          // Marcar visualmente el cubo como contabilizado
          if (cuboSeleccionado) {
            cuboSeleccionado.addClass("cubo-contado");
          }

          // Resetear formulario
          $("#formCubo")[0].reset();
        } else {
          alert("⚠️ " + respuesta.error);
        }
      },
      error: function (xhr) {
        let mensaje = "Error inesperado. Intente de nuevo.";
        if (xhr.responseJSON?.error) {
          mensaje = xhr.responseJSON.error;
        } else if (xhr.responseText) {
          mensaje = xhr.responseText;
        }
        alert("❌ " + mensaje);
      },
    });
  });

  document
    .getElementById("vencimiento-dia")
    .addEventListener("blur", function () {
      let val = this.value.padStart(2, "0");
      // Si el campo está vacío, no lo llenes con ceros
      this.value = this.value.length ? val : "";
    });
});

function cargarLayoutPorAjax() {
  let datos = $("#formVerLayout").serialize();
  $.ajax({
    url: "ajaxGetLayout.php", // El backend PHP que te paso abajo
    type: "POST",
    data: datos,
    dataType: "json",
    success: function (response) {
      window.depositoLayout = response.depositoLayout;
      window.posicionesPorFecha = response.posicionesPorFecha;
      window.coloresPorFecha = response.coloresPorFecha;
      window.fechasDisponibles = response.fechasDisponibles;

      // --- CARRUSEL ---
      if (
        !Array.isArray(window.fechasDisponibles) ||
        window.fechasDisponibles.length === 0
      ) {
        $("#contenedor-layout").html(
          "<div class='text-center text-muted'>No hay fechas disponibles para mostrar.</div>"
        );
      } else {
        let idx = 0;
        function siguienteFechaCarrusel() {
          renderLayoutParaFecha(window.fechasDisponibles[idx]);
          idx = (idx + 1) % window.fechasDisponibles.length;
        }
        siguienteFechaCarrusel();
        setInterval(siguienteFechaCarrusel, 3000);
      }

      // Opción 2: Solo la primera fecha
      // renderLayoutParaFecha(window.fechasDisponibles[0] || null);
    },
    error: function (xhr) {
      $("#contenedor-layout").html(
        "<div class='text-danger'>Error cargando layout.</div>"
      );
    },
  });
}

function renderLayoutParaFecha(fecha) {
  if (!fecha || !window.depositoLayout) {
    $("#contenedor-layout").html(
      '<div class="text-muted">No hay datos para mostrar.</div>'
    );
    return;
  }
  const posicionesContadas = window.posicionesPorFecha[fecha] || [];
  const posicionesColor = window.coloresPorFecha[fecha] || {};

  let html = `<h4 class="mb-4">Fecha: ${fecha}</h4><div class="row-24">`;
  // Suponiendo que depositoLayout solo tiene el depósito seleccionado:
  for (const deposito in window.depositoLayout) {
    for (const rack in window.depositoLayout[deposito]) {
      for (const columna in window.depositoLayout[deposito][rack]) {
        html += `<div class="col-24 columna text-center">`;
        for (const nivel in window.depositoLayout[deposito][rack][columna]) {
          html += `<div class="nivel"><div class="titulo-seccion mb-2">${rack} <br> ${columna} - ${nivel}</div>`;
          let fondos = window.depositoLayout[deposito][rack][columna][nivel];
          fondos.forEach((fondo, idx) => {
            // Antes: fondo = 1, 2, 3, ...
            // let posicionId = fondoObj.id;  // (esto da error si fondo no es objeto)
            // Debe ser:
            let posicionId = fondo.id;
            const esContado = posicionesContadas.includes(String(posicionId));
            const cuboColor = esContado
              ? "#" + (posicionesColor[String(posicionId)] || "f9f9f9")
              : "#f9f9f9";
            const className = "cuadro-posicion" + (esContado ? " contado" : "");

            html += `<div class="${className}" style="background-color: ${cuboColor}" 
                        data-deposito="${deposito}"
                        data-rack="${rack}"
                        data-columna="${columna}"
                        data-nivel="${nivel}"
                        data-fondo="${fondo.fondo}">
                        ${fondo.fondo}
                    </div>`;
          });
          html += `</div>`;
        }
        html += `</div>`;
      }
    }
  }
  html += `</div>`;
  $("#contenedor-layout").html(html);
}
