<?php
session_start();
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

include_once '../libreria/ezSql/ez_sql_core.php';
include_once '../libreria/ezSql/ez_sql_pdo.php';
include_once '../libreria/ezSql/conect.php';

$depositoSeleccionado = $_POST['deposito'] ?? '';

$fechaConteo1 = $_POST['fechaConteo1'] ?? date('Y-m-d');
$fechaConteo2 = $_POST['fechaConteo2'] ?? date('Y-m-d');

$depositoLayout = [];


// Para el select de depósitos
$depositos = $db->get_results("SELECT DISTINCT deposito FROM ope_layout ORDER BY deposito");
// $db->debug();

// Traer todas las posiciones contadas hoy
$resultado = $db->get_results("SELECT DATE(cc.created_at) AS fecha_conteo, cc.posicion_id, pp.color_web 
                               FROM ctrl_conteo cc 
                               LEFT JOIN para_productos pp ON pp.id = cc.producto 
                               WHERE DATE(cc.created_at) BETWEEN '$fechaConteo1' AND '$fechaConteo2'
                               GROUP BY fecha_conteo, cc.posicion_id
                               ;
");

// $db->debug();
// Layout
foreach ($resultados as $fila) {
    $depositoLayout[$fila->deposito][$fila->rack][$fila->columna][$fila->nivel][] = [
        'id' => $fila->id,
        'fondo' => $fila->fondo
    ];
}

// Posiciones por fecha
// $resultado = $db->get_results("SELECT DATE(cc.created_at) AS fecha_conteo, cc.posicion_id, pp.color_web 
//                                FROM ctrl_conteo cc 
//                                LEFT JOIN para_productos pp ON pp.id = cc.producto 
//                                WHERE DATE(cc.created_at) BETWEEN '$fechaConteo1' AND '$fechaConteo2'
//                                GROUP BY fecha_conteo, cc.posicion_id
//                                ;
// ");

// $posicionesPorFecha = [];
// $coloresPorFecha = [];

// if ($resultado) {
//     foreach ($resultado as $row) {
//         $fecha = $row->fecha_conteo;
//         $posicionesPorFecha[$fecha][] = $row->posicion_id;
//         $coloresPorFecha[$fecha][$row->posicion_id] = $row->color_web;
//     }
// }

// $fechasDisponibles = array_keys($posicionesPorFecha);


?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Conteo de depósitos</title>

    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <link href="layoutInteractivo.css" rel="stylesheet">
</head>

<body class="bg-dark1">

    <div class="container py-4">
        <div class="card shadow-lg rounded-4 border-0 bg-white mb-4">
            <div class="card-header border-0 bg-primary text-white rounded-top-4 text-center py-4">
                <div class="row">
                    <div class="col-6">
                        <img src="img/logo.png" alt="BMSA" class="img-fluid" style="max-height: 20vh;">
                    </div>
                    <div class="col-6">
                        <h1 class="mb-0 fw-bold fs-2"><?php echo $rackSeleccionado != '' ? 'CONTEO de<br> DEPÓSITO: ' . $depositoSeleccionado . ' - RACK: ' . $rackSeleccionado : 'SELECCIONAR PARA CONTAR'; ?></h1>
                    </div>
                </div>
            </div>
            <div class="card-body py-4">
                <form id="formVerLayout" method="POST" class="row g-4 mb-4 px-2">
                    <div class="col-4">
                        <label for="deposito" class="form-label">Depósito</label>
                        <select name="deposito" id="deposito" class="form-select form-select-lg rounded-3" required>
                            <option value="">DEPÓSITO...</option>
                            <?php foreach ($depositos as $dep): ?>
                                <option value="<?= htmlspecialchars($dep->deposito) ?>" <?= $depositoSeleccionado === $dep->deposito ? 'selected' : '' ?>><?= htmlspecialchars($dep->deposito) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-4">
                        <label for="fechaConteo1" class="form-label">Fecha de inicio</label>
                        <input type="date" class="form-control form-control-lg rounded-3" id="fechaConteo1" name="fechaConteo1" value="<?= $fechaConteo1 ?>" required>
                    </div>
                    <div class="col-4">
                        <label for="fechaConteo2" class="form-label">Fecha de fin</label>
                        <input type="date" class="form-control form-control-lg rounded-3" id="fechaConteo2" name="fechaConteo2" value="<?= $fechaConteo2 ?>" required>
                    </div>

                </form>

                <div id="contenedor-layout"></div>

            </div>
        </div>

        <div class="modal fade" id="modalFormulario" tabindex="-1" aria-labelledby="modalFormularioLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <form id="formCubo">
                        <div class="modal-header">
                            <h5 class="modal-title" id="modalFormularioLabel">Información del pallet</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                        </div>
                        <div class="modal-body">

                            <input type="hidden" id="posicion_id" name="posicion_id">
                            <input type="hidden" id="ubicacionDeposito" name="deposito">
                            <input type="hidden" id="ubicacionRack" name="rack">
                            <input type="hidden" id="ubicacionColumna" name="columna">
                            <input type="hidden" id="ubicacionNivel" name="nivel">
                            <input type="hidden" id="ubicacionFondo" name="fondo">


                            <div class="mb-3">
                                <label for="palletId" class="form-label">ID (Nº de pallet)</label>
                                <input type="number" class="form-control form-control-lg" id="palletId" name="id">
                            </div>

                            <div class="mb-3">
                                <label for="cod" class="form-label">Código</label>
                                <input type="number" class="form-control form-control-lg" id="cod" name="cod">
                            </div>

                            <div class="mb-3">
                                <label for="lote" class="form-label">Lote</label>
                                <input type="number" class="form-control form-control-lg" id="lote" name="lote">
                            </div>

                            <div class="mb-3">
                                <label for="vencimiento" class="form-label">Vencimiento</label>
                                <div class="row">
                                    <div class="col">
                                        <input
                                            type="number"
                                            class="form-control form-control-lg"
                                            id="vencimiento-dia"
                                            name="vencimiento-dia"
                                            placeholder="DD"
                                            min="1"
                                            max="31"
                                            maxlength="2"
                                            oninput="if(this.value.length > 2) this.value = this.value.slice(0,2);">
                                    </div>
                                    <div class="col">
                                        <input
                                            type="number"
                                            class="form-control form-control-lg"
                                            id="vencimiento-mes"
                                            name="vencimiento-mes"
                                            placeholder="MM"
                                            min="1"
                                            max="12"
                                            maxlength="2"
                                            oninput="if(this.value.length > 2) this.value = this.value.slice(0,2);">
                                    </div>
                                    <div class="col">
                                        <input
                                            type="number"
                                            class="form-control form-control-lg"
                                            id="vencimiento-anio"
                                            name="vencimiento-anio"
                                            placeholder="YYYY"
                                            min="2025"
                                            max="2100"
                                            oninput="if(this.value.length > 4) this.value = this.value.slice(0,4);">
                                    </div>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label for="vencimiento" class="form-label">Cantidad</label>
                                <input type="number" class="form-control form-control-lg" id="cantidad" name="cantidad">
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-success">Guardar</button>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Esto debe estar ANTES del reporteLayoutDpto.js -->
    <script src="fnRenderLayout.js.php"></script>
    <script>
    window.depositoLayout = <?php echo json_encode($depositoLayout); ?>;
    window.posicionesPorFecha = <?php echo json_encode($posicionesPorFecha); ?>;
    window.coloresPorFecha = <?php echo json_encode($coloresPorFecha); ?>;
    window.fechasDisponibles = <?php echo json_encode($fechasDisponibles); ?>;
    </script>
    <script src="reporteLayoutDpto.js"></script>
    




</body>

</html>