<?php
session_start();
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

include_once '../libreria/ezSql/ez_sql_core.php';
include_once '../libreria/ezSql/ez_sql_pdo.php';
include_once '../libreria/ezSql/conect.php';

$depositoSeleccionado = $_POST['deposito'] ?? '';

$fechaConteo = $_POST['fechaConteo'] ?? date('Y-m-d');

$depositoLayout = [];


// Para el select de depósitos
$depositos = $db->get_results("SELECT DISTINCT deposito FROM ope_layout ORDER BY deposito");
// $db->debug();


?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Resumen de conteo de depósitos</title>

    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">



    <link href="layoutInteractivo.css" rel="stylesheet">
</head>

<body class="bg-dark1">

    <div class="container py-4">
        <div class="card shadow-lg rounded-4 border-0 bg-white mb-4">
            <div class="card-header border-0 bg-primary text-white rounded-top-4 text-center py-4">
                <!-- ... header con logo ... -->
            </div>
            <div class="card-body py-4">
                <form id="formVerLayout" method="POST" class="row g-4 mb-4 px-2">
                    <div class="col-4">
                        <label for="deposito" class="form-label">Depósito</label>
                        <select name="deposito" id="deposito" class="form-select form-select-lg rounded-3" required>
                            <option value="">DEPÓSITO...</option>
                            <?php foreach ($depositos as $dep): ?>
                                <option value="<?= htmlspecialchars($dep->deposito) ?>"><?= htmlspecialchars($dep->deposito) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-4">
                        <label for="fechaConteo1" class="form-label">Fecha</label>
                        <input type="date" class="form-control form-control-lg rounded-3" id="fechaConteo1" name="fechaConteo" value="<?= date('Y-m-d') ?>" required>
                    </div>
                    <div class="col-4 d-flex align-items-end">
                        <button type="button" class="btn btn-primary btn-lg w-100" onclick="cargarReporte()">
                            <i class="bi bi-arrow-repeat"></i> Actualizar
                        </button>
                    </div>
                </form>

                <div id="contenedor"></div>
            </div>
        </div>
    </div>


    <!-- Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Esto debe estar ANTES del reporteLayoutDpto.js -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <!-- Plugins -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <script>
        function cargarReporte() {
            let deposito = $("#deposito").val();
            let fecha = $("#fechaConteo1").val();
            if (!deposito || !fecha) {
                $("#contenedor").html("<div class='alert alert-info'>Seleccione depósito y fecha.</div>");
                return;
            }
            $.post("backendReporteResumenDpto.php", {
                deposito: deposito,
                fecha: fecha
            }, function(data) {
                let r = {};
                try {
                    r = JSON.parse(data);
                } catch (e) {
                    $("#contenedor").html("<div class='alert alert-danger'>Error en respuesta.</div>");
                    return;
                }
                let html = `
                <div class="card shadow-lg rounded-4 border-0 bg-white mb-4">
                    <div class="card-header border-0 bg-primary text-white rounded-top-4 text-center py-4">
                        <h2 class="mb-0 fw-bold fs-3">Resumen de Ocupación: Depósito ${deposito}</h2>
                        <div class="fs-6 mt-2"><b>Fecha:</b> ${fecha}</div>
                    </div>
                    <div class="card-body py-4">
                        <div class="row mb-4">
                            <div class="col-md-4">
                                <h4 class="mt-2 mb-3">Detalle por Código de Producto</h4>
                                <table class="table table-bordered table-sm mt-2">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Código</th>
                                            <th class="text-end">Cantidad</th>
                                        </tr>
                                    </thead>
                                    <tbody>`;
                if (r.detalle && r.detalle.length) {
                    r.detalle.forEach(function(row) {
                        html += `<tr><td>${row.cod}</td><td class="text-end">${row.cantidad}</td></tr>`;
                    });
                } else {
                    html += `<tr><td colspan="2" class="text-center text-muted">No hay datos</td></tr>`;
                }
                html += `
                                    </tbody>
                                </table>
                                <div class="d-flex gap-2 mt-3">
                                    <button class="btn btn-outline-success btn-sm" onclick="exportarExcel()"><i class="bi bi-file-earmark-excel"></i> Excel</button>
                                    <button class="btn btn-outline-danger btn-sm" onclick="exportarPDF()"><i class="bi bi-file-earmark-pdf"></i> PDF</button>
                                    <button class="btn btn-outline-primary btn-sm" onclick="window.print()"><i class="bi bi-printer"></i> Imprimir</button>
                                </div>
                            </div>
                            <div class="col-md-8 d-flex flex-column align-items-center justify-content-center">
                                <div class="row w-100">
                                    <div class="col-md-6 mb-4">
                                        <canvas id="graficoOcupacion"></canvas>
                                    </div>
                                    <div class="col-md-6 mb-4">
                                        <canvas id="graficoDetalle"></canvas>
                                    </div>
                                </div>
                                <div class="row w-100 mt-2">
                                    <div class="col-4 text-center">
                                        <div class="fs-4 fw-bold">${(r.total ?? 0)}</div>
                                        <div class="text-muted">Total de posiciones</div>
                                    </div>
                                    <div class="col-4 text-center">
                                        <div class="fs-4 fw-bold text-success">${(r.ocupadas ?? 0)}</div>
                                        <div class="text-muted">Ocupadas</div>
                                        <div class="small text-success">${(r.porcentaje_ocupadas ?? 0)}%</div>
                                    </div>
                                    <div class="col-4 text-center">
                                        <div class="fs-4 fw-bold text-danger">${(r.vacias ?? 0)}</div>
                                        <div class="text-muted">Vacías</div>
                                        <div class="small text-danger">${(r.porcentaje_vacias ?? 0)}%</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>`;

                $("#contenedor").html(html);
                renderGraficosReporte(r);
            });
        }

        // Auto-carga al cambiar select o fecha
        $("#deposito, #fechaConteo").on("change", cargarReporte);

        // Cargar al iniciar si ambos están seteados
        $(document).ready(cargarReporte);

        function renderGraficosReporte(r) {
            // -------- Gráfico de Ocupación --------
            const ctxOcupacion = document.getElementById('graficoOcupacion').getContext('2d');
            new Chart(ctxOcupacion, {
                type: 'doughnut',
                data: {
                    labels: ['Ocupadas', 'Vacías'],
                    datasets: [{
                        data: [r.ocupadas ?? 0, r.vacias ?? 0],
                        backgroundColor: ['#198754', '#dc3545'],
                    }]
                },
                options: {
                    plugins: {
                        title: {
                            display: true,
                            text: 'Ocupación de Posiciones',
                            font: {
                                size: 16
                            }
                        },
                        legend: {
                            display: true
                        }
                    }
                }
            });

            // -------- Gráfico Detalle por Código --------
            const topCodigos = (r.detalle || [])
                .sort((a, b) => b.cantidad - a.cantidad)
                .slice(0, 5);

            const ctxDetalle = document.getElementById('graficoDetalle').getContext('2d');
            new Chart(ctxDetalle, {
                type: 'doughnut',
                data: {
                    labels: topCodigos.map(row => row.cod),
                    datasets: [{
                        data: topCodigos.map(row => row.cantidad),
                        backgroundColor: [
                            '#0d6efd', '#6610f2', '#20c997', '#ffc107', '#fd7e14'
                        ],
                    }]
                },
                options: {
                    plugins: {
                        title: {
                            display: true,
                            text: 'Top 5 Códigos de Producto',
                            font: {
                                size: 16
                            }
                        },
                        legend: {
                            display: true
                        }
                    }
                }
            });
        }
    </script>






</body>

</html>