<?php
session_start();
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

include_once '../libreria/ezSql/ez_sql_core.php';
include_once '../libreria/ezSql/ez_sql_pdo.php';
include_once '../libreria/ezSql/conect.php';

$depositoSeleccionado = $_POST['deposito'] ?? '';
$rackSeleccionado = $_POST['rack'] ?? '';

$depositoLayout = [];

if ($depositoSeleccionado && $rackSeleccionado) {
    $depositoSeleccionado = addslashes($depositoSeleccionado);
    $rackSeleccionado = addslashes($rackSeleccionado);

    $query = "
        SELECT deposito, rack, columna, nivel, fondo
        FROM ope_layout
        WHERE deposito = '$depositoSeleccionado'
          AND rack = '$rackSeleccionado'
        ORDER BY columna, nivel, fondo
    ";

    $resultados = $db->get_results($query);

    foreach ($resultados as $fila) {
        $depositoLayout[$fila->deposito][$fila->rack][$fila->columna][$fila->nivel][] = $fila->fondo;
    }
}

// Para el select de depósitos
$depositos = $db->get_results("SELECT DISTINCT deposito FROM ope_layout ORDER BY deposito");

?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Formulario Móvil - Test</title>

    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <link href="layoutInteractivo.css" rel="stylesheet">
</head>

<body>

    <div class="container">
        <div class="card">
            <div class="card-header">
                <h1 class="text-center mb-5"><?php echo $rackSeleccionado != '' ? 'CONTEO de<br> Depósito ' . $depositoSeleccionado . ' - Rack: ' . $rackSeleccionado : 'SELECCIONAR PARA CONTAR'; ?></h1>
            </div>
            <div class="card-body">


                <form method="POST" class="row g-3 mb-4">
                    <div class="col-12">
                        <label for="deposito" class="form-label fs-5">Depósito</label>
                        <select name="deposito" id="deposito" class="form-select form-select-lg" required>
                            <option value="">Seleccionar...</option>
                            <?php foreach ($depositos as $dep): ?>
                                <option value="<?= $dep->deposito ?>" <?= $depositoSeleccionado === $dep->deposito ? 'selected' : '' ?>><?= $dep->deposito ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="col-12">
                        <label for="rack" class="form-label fs-5">Rack</label>
                        <select name="rack" id="rack" class="form-control form-control-lg" required <?= !$depositoSeleccionado ? 'disabled' : '' ?>>
                            <option value="">Seleccionar...</option>
                            <?php if ($rackSeleccionado): ?>
                                <option selected><?= $rackSeleccionado ?></option>
                            <?php endif; ?>
                        </select>
                    </div>

                    <div class="col-12">
                        <button class="btn btn-primary btn-lg w-100">Ver layout</button>
                    </div>
                </form>


                <?php if ($depositoSeleccionado && $rackSeleccionado): ?>
                    <?php foreach ($depositoLayout as $nombreDeposito => $racks): ?>
                        <div class="mb-4">
                            

                            <?php foreach ($racks as $nombreRack => $columnas): ?>
                                <div class="mb-3 ps-3">
                                    <div class="row">
                                        <?php foreach ($columnas as $nombreColumna => $niveles): ?>
                                            <div class="col-2 col-lg-1 columna text-center">
                                                <?php foreach ($niveles as $nombreNivel => $fondos): ?>
                                                    <div class="nivel">
                                                        <div class="titulo-seccion"><?= $nombreDeposito.' - '.$nombreRack.' <br> '.$nombreColumna.' - '.$nombreNivel ?></div>
                                                        <?php foreach ($fondos as $index => $color): ?>
                                                            <div
                                                                class="fondo-cubo"
                                                                data-deposito="<?= $nombreDeposito ?>"
                                                                data-rack="<?= $nombreRack ?>"
                                                                data-columna="<?= $nombreColumna ?>"
                                                                data-nivel="<?= $nombreNivel ?>"
                                                                data-fondo="<?= $index + 1 ?>">
                                                                <div class="cubo-inner">
                                                                    <?php for ($face = 0; $face < 6; $face++): ?>
                                                                        <div class="cara <?= ['front', 'back', 'right', 'left', 'top', 'bottom'][$face] ?>"></div>
                                                                    <?php endfor; ?>
                                                                </div>
                                                            </div>

                                                        <?php endforeach; ?>
                                                    </div>
                                                <?php endforeach; ?>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="container text-center text-muted">
                        <p>Seleccioná un depósito y un rack para ver el layout.</p>
                    </div>
                <?php endif; ?>

            </div>
        </div>

        <div class="modal fade" id="modalFormulario" tabindex="-1" aria-labelledby="modalFormularioLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <form id="formCubo">
                        <div class="modal-header">
                            <h5 class="modal-title" id="modalFormularioLabel">📦 Información del pallet</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                        </div>
                        <div class="modal-body">

                            <div class="mb-3">
                                <label for="palletId" class="form-label">ID (Nº de pallet)</label>
                                <input type="text" class="form-control" id="palletId" name="id">
                            </div>

                            <div class="mb-3">
                                <label for="cod" class="form-label">Código</label>
                                <input type="text" class="form-control" id="cod" name="cod">
                            </div>

                            <div class="mb-3">
                                <label for="lote" class="form-label">Lote</label>
                                <input type="text" class="form-control" id="lote" name="lote">
                            </div>

                            <div class="mb-3">
                                <label for="vencimiento" class="form-label">Vencimiento</label>
                                <input type="date" class="form-control" id="vencimiento" name="vencimiento">
                            </div>

                            <!-- Podés guardar estas coordenadas si lo necesitás -->
                            <input type="hidden" id="ubicacionDeposito" name="deposito">
                            <input type="hidden" id="ubicacionRack" name="rack">
                            <input type="hidden" id="ubicacionColumna" name="columna">
                            <input type="hidden" id="ubicacionNivel" name="nivel">
                            <input type="hidden" id="ubicacionFondo" name="fondo">

                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-success">Guardar</button>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Bootstrap JS -->
        <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

        <script src="conteoInteractivo.js"></script>

</body>

</html>