function initializeBaseDataTable(config) {
  const {
    tableId,
    ajaxUrl,
    columns,
    columnDefs = [],
    order = [],
    editorFields = false, // Si es falso, desactiva el Editor
    tableButtons = [], // Botones personalizados adicionales
  } = config;

  let editor = null; // Inicializamos editor como null por defecto

  // Solo inicializar el editor si editorFields está definido
  if (editorFields) {
    editor = new DataTable.Editor({
      i18n: {
        create: {
          button: "Nuevo",
          title: "Crear un nuevo registro",
          submit: "Crear",
        },
        edit: {
          button: "Modificar",
          title: "Modificar registro",
          submit: "Actualizar",
        },
        remove: {
          button: "Eliminar",
          title: "Eliminar registro",
          submit: "Eliminar",
          confirm: {
            _: "¿Estás seguro de que quieres eliminar %d registros?",
            1: "¿Estás seguro de que quieres eliminar este registro?",
          },
        },
        error: {
          system:
            "Ocurrió un error, por favor contacta al administrador del sistema.",
        },
        upload: {
          choose: "Seleccionar archivo...",
          drag: "Arrastra y suelta un archivo aquí para subirlo",
          drop: "Suelta el archivo aquí para subirlo",
          remove: "Eliminar archivo",
          noDrop: "La carga de archivos no está permitida",
          confirm: {
            title: "¿Estás seguro?",
            message: "El archivo será eliminado. ¿Deseas continuar?",
          },
        },
        multi: {
          title: "Valores múltiples",
          info: "Los elementos seleccionados contienen valores diferentes para este campo. Para editar y establecer todos los elementos en el mismo valor, haz clic aquí; de lo contrario, conservarán sus valores individuales.",
          restore: "Cancelar cambios",
          noMulti:
            "Este campo se puede editar individualmente, pero no como parte de un grupo.",
        },
        datetime: {
          previous: "Anterior",
          next: "Siguiente",
          months: [
            "Enero",
            "Febrero",
            "Marzo",
            "Abril",
            "Mayo",
            "Junio",
            "Julio",
            "Agosto",
            "Septiembre",
            "Octubre",
            "Noviembre",
            "Diciembre",
          ],
          weekdays: ["Dom", "Lun", "Mar", "Mié", "Jue", "Vie", "Sáb"],
        },
      },
      ajax: ajaxUrl,
      fields: editorFields,
      table: `#${tableId}`,
    });
  }
  // Configurar los botones del DataTable
  const buttons = [];
  if (editor) {
    // Solo agregar botones del editor si está habilitado
    buttons.push(
      { extend: "create", editor: editor },
      { extend: "edit", editor: editor },
      { extend: "remove", editor: editor }
    );
  }
  // Botones del DataTable
  buttons.push({
    extend: "collection",
    text: "Exportar",
    buttons: [
      { extend: "copyHtml5", text: "Copiar", footer: true },
      { extend: "excelHtml5", footer: true },
      { extend: "csvHtml5", text: "CSV", footer: true },
      { extend: "pdfHtml5", footer: true },
    ],
  });
  buttons.push(...tableButtons); // Agregar botones personalizados adicionales

  // Inicializar DataTable
  const table = new DataTable(`#${tableId}`, {
    ajax: ajaxUrl,
    scrollY: "750px",
    scrollX: "true",
    scrollCollapse: true,
    autoWidth: false,
    lengthMenu: [
      [10, 25, 50, -1],
      [10, 25, 50, "Todos"],
    ],
    language: {
      sProcessing: "Procesando...",
      sLengthMenu: "_MENU_",
      sZeroRecords: "No se encontraron resultados",
      sEmptyTable: "Ningún dato disponible en esta tabla",
      sInfo:
        "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
      sInfoEmpty: "Mostrando registros del 0 al 0 de un total de 0 registros",
      sInfoFiltered: "(filtrado de un total de _MAX_ registros)",
      sInfoPostFix: "",
      search: "",
      searchPlaceholder: "Buscar",
      sUrl: "",
      sInfoThousands: ",",
      sLoadingRecords: "Cargando...",
      decimal: ",",
      thousands: ".",
      oPaginate: {
        sFirst: "<<",
        sLast: ">>",
        sNext: ">",
        sPrevious: "<",
      },
      clearText: "Limpiar",
      noImageText: "Sin Imagen",
      dragDropText: "Suelte un archivo aquí para descargarlo",
      noFileText: "No hay archivos subidos",
      uploadText: "Subir archivo...",
      oAria: {
        sSortAscending:
          ": Activar para ordenar la columna de manera ascendente",
        sSortDescending:
          ": Activar para ordenar la columna de manera descendente",
      },
      select: {
        rows: {
          _: "Tienes %d registros seleccionados",
          0: "Haz click en un registro para seleccionarlo",
          1: "Solo 1 registro seleccionado",
        },
      },
    },
    order: order,
    ordering: false,
    columns: columns,
    columnDefs: columnDefs,
    layout: {
      topStart: {
        buttons: buttons,
      },
    },
    select: true,
    initComplete: function () {
      const api = this.api();

      // Obtener el header original
      const header = $(api.table().header());

      // Crear una fila adicional debajo del thead
      const searchRow = $("<tr>").appendTo(header);

      // Iterar por cada columna
      api.columns().every(function () {
        const column = this;
        const title = column.header().textContent;

        // Crear un nuevo th para el input de búsqueda
        const th = $("<th>").appendTo(searchRow);

        // Crear el input para la búsqueda
        const input = $("<input>", {
          type: "text",
          placeholder: `Buscar ${title}`,
          class: "form-control form-control-sm",
        }).appendTo(th);

        // Evento de búsqueda cuando el usuario escribe en el input
        input.on("keyup change", function () {
          if (column.search() !== this.value) {
            column.search(this.value).draw();
          }
        });
        // Ajustar el texto de los inputs de búsqueda si existen
        $(header).find('th').addClass('text-center');        
      });
    },
  });
  table.columns.adjust().draw();
  // Activate an inline edit on click of a table cell
  $(`#${tableId}`).on("click", "tbody td:not(:first-child)", function (e) {
    editor.inline(this, {
      onBlur: "submit",
    });
  });
  return { editor, table };
}
