function initializeBaseDataTable(config) {
  const {
    tableId,
    ajaxUrl,
    columns,
    editorFields = false, // Si es falso, desactiva el Editor
    grupo, // Si es falso, desactiva RowGroup
    tableButtons = [], // Botones personalizados adicionales
  } = config;

  let editor = null; // Inicializamos editor como null por defecto

  // Solo inicializar el editor si editorFields está definido
  if (editorFields) {
    editor = new $.fn.dataTable.Editor({
      i18n: {
        create: {
          button: "Nuevo",
          title: "Crear un nuevo registro",
          submit: "Crear",
        },
        edit: {
          button: "Modificar",
          title: "Modificar registro",
          submit: "Actualizar",
        },
        remove: {
          button: "Eliminar",
          title: "Eliminar registro",
          submit: "Eliminar",
          confirm: {
            _: "¿Seguro que deseas eliminar %d registros?",
            1: "¿Seguro que deseas eliminar 1 registro?",
          },
        },
        error: { system: "Error en el sistema. Contacte al administrador." },
      },
      ajax: ajaxUrl,
      table: `#${tableId}`,
      fields: editorFields,
    });
  }

  // Configurar los botones del DataTable
  const buttons = [];
  if (editor) {
    // Solo agregar botones del editor si está habilitado
    buttons.push(
      { extend: "create", editor: editor, className: "btn btn-primary btn-sm" },
      { extend: "edit", editor: editor, className: "btn btn-secondary btn-sm" },
      { extend: "remove", editor: editor, className: "btn btn-danger btn-sm" }
    );
  }
  buttons.push(...tableButtons); // Agregar botones personalizados adicionales

  // Inicializar DataTable
  const table = $(`#${tableId}`).DataTable({
    dom:
      "<'row'<'col-sm-12 col-md-6'B><'col-sm-12 col-md-6'f>>" +
      "<'row'<'col-sm-12'tr>>" +
      "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
    scrollY: "750px",
    scrollX: true,
    ajax: ajaxUrl,
    columns: columns,
    ordering: false,
    select: !!editor, // Solo habilitar select si el editor está presente
    autoWidth: false,
    layout: {
      topStart: {
        buttons: buttons,
      },
    },
    rowGroup: grupo
      ? {
          dataSrc: grupo, // Agrupar por esta columna si está habilitado
          startRender: function (rows, group) {
            return $('<tr class="dt-group-row" style="cursor: pointer;">')
              .append(
                '<td colspan="100%">' + group + " (" + rows.count() + ")</td>"
              )
              .attr("data-group", group);
          },
        }
      : undefined, // Deshabilitar RowGroup si grupo es falso
    initComplete: function () {
      const api = this.api();

      // Ajustar las cabeceras de las columnas
      api.columns().every(function () {
        const column = this;
        const title = $(column.header()).text(); // Obtener el texto del header original

        // Asegúrate de no borrar el header al insertar el input
        $(column.header()).html(
          '<input type="text" placeholder="' +
            title +
            '" class="form-control form-control-sm" style="width: 100%;" />'
        );

        // Agregar funcionalidad de búsqueda
        $("input", column.header()).on("keyup change clear", function () {
          if (column.search() !== this.value) {
            column.search(this.value).draw();
          }
        });
      });

      // Ajustar el tamaño de las columnas para que coincidan con el header
      api.columns.adjust();

      // Ocultar todas las filas no agrupadas al cargar la tabla
      //   api.rows().every(function () {
      //     const row = this.node();
      //     // console.log("Ocultando fila:", row);
      // //    $(row).hide().addClass("hidden-group-row"); // Ocultar todas las filas inicialmente
      //   });

      // Configurar toggle para los grupos
      //   $(`#${tableId}`).on("click", "tr.dt-group-row", function () {
      //     const group = 'row_'+$(this).data("group");

      //     const rows = api.rows().nodes();
      //     $(rows).each(function () {
      //       const rowData = api.row(this).data();
      //       console.log("Grupo clicado:", rowData);
      //       if (rowData && rowData[grupo] === group) {
      //         console.log("Afectando fila:", rowData); // Verificar la fila procesada
      //         $(this).toggleClass("hidden-group-row");
      //       }
      //     });
      //   });
    },
  });

  // Configurar inline editing solo si el editor está habilitado
  if (editor) {
    $(`#${tableId}`).on("click", "tbody td:not(:first-child)", function () {
      editor.inline(this, { onBlur: "submit" });
    });
  }

  return { editor, table };
}
