$(document).ready(function () {
  // Configuración específica para la tabla "clientes"
  const tableId = "clientesTable";
  const ajaxUrl = "/backend/control/historial/editor.php";

  const columns = [
    {
      data: "sys_log.log_date",
      title: "Fecha y hora",
      className: "text-start",
    }, 
    {
      data: "sys_users.u_userfullname",
      title: "Usuario",
      className: "text-start",
    }, 
    {
      data: "sys_log.objeto",
      title: "Tabla afectada",
      className: "text-start",
    }, 
    {
      data: "sys_log.action",
      title: "Acción realizada",
      className: "text-start",
      render: function (data, type, row) {
        if (type === "display" || type === "filter") {
          const traducciones = {
            create: "Creación",
            edit: "Edición",
            delete: "Eliminación",
          };
          return traducciones[data] || "Desconocido"; // Traducir si existe, si no "Desconocido"
        }
        return data; // Para otros tipos, devolver el valor sin cambios
      },
    },    
    {
      data: "sys_log.message",
      title: "Valores",
      className: "text-start",
      render: function (data, type, row) {
        if (type === "display" && data) {
          try {
            const message = JSON.parse(data);
            const fieldsToShow = ["respuesta", "documento", "estado"]; // Claves específicas a mostrar
      
            // Mapeo de estados a descripciones
            const estadoMapping = {
              0: "solicitado",
              1: "recibido",
              2: "procesado",
              3: "enviado",
              4: "finalizado",
              9: "rechazado",
            };
      
            // Construimos el listado de valores filtrados
            const values = message.values && message.values.oper_solicitudes
              ? `<ul>${Object.entries(message.values.oper_solicitudes)
                  .filter(([key]) => fieldsToShow.includes(key)) // Filtrar solo las claves deseadas
                  .map(([key, value]) => {
                    // Mostrar el texto del estado en lugar del número
                    if (key === "estado" && estadoMapping.hasOwnProperty(value)) {
                      value = estadoMapping[value];
                    }
                    return `<li><strong>${key}:</strong> ${value}</li>`;
                  })
                  .join("")}</ul>`
              : "<strong>Valores:</strong> N/A";
      
            return `<div>
                      ${values}
                    </div>`;
          } catch (e) {
            console.error("Error al parsear JSON:", e);
            return "Error en el formato de datos.";
          }
        }

        return data; // Devuelve los datos sin cambios si no es tipo "display"
      },
    },    
  ];

  // Inicializar DataTable base
  const { editor, table } = initializeBaseDataTable({
    tableId,
    ajaxUrl,
    columns,
  });
});
