// Depósito · Pallets en Cuarentena
(function(){
  "use strict";

  const $ = window.jQuery;
  if (!$) return;

  const meta = document.querySelector('meta[name="base-url"]');
  const BASE = (meta && meta.content ? meta.content : '/').replace(/\/+$/,'');
  const joinUrl = (p) => (BASE.endsWith('/') ? BASE : BASE + '/') + p.replace(/^\/+/, '');
  const nfmt = (v, d=0) => new Intl.NumberFormat('es-PY', { minimumFractionDigits:d, maximumFractionDigits:d }).format(v ?? 0);

  const $form = $("#frmCuar");
  const $ingreso = $("#fIngresoId");
  const $btnAsig = $("#btnIrAsignacion");
  const $btnRefresh = $("#btnRefrescar");
  const $btnClear = $("#btnLimpiar");
  const $msg = $("#msgInfo");

  let ingresoId = null;

  function enableAssignLink() {
    if (ingresoId && Number(ingresoId) > 0) {
      $btnAsig.removeClass('disabled').attr('href', joinUrl(`/ingresos/asignar_posiciones?ingreso_id=${ingresoId}`));
    } else {
      $btnAsig.addClass('disabled').attr('href', '#');
    }
  }

  // DataTable
  const dt = $("#palletsCuarentenaTable").DataTable({
    searching: false,
    paging: true,
    lengthChange: false,
    pageLength: 25,
    ordering: true,
    order: [[1, 'asc']],
    ajax: function (data, cb) {
      if (!ingresoId) { cb({ data: [] }); return; }
      fetch(joinUrl(`/api/operaciones/pallets_en_cuarentena.php?ingreso_id=${encodeURIComponent(ingresoId)}`), { credentials: 'same-origin' })
        .then(r => r.json())
        .then(json => {
          const rows = Array.isArray(json) ? json : (json.data || []);
          cb({ data: rows });
          $msg.toggleClass('d-none', true);
        })
        .catch(err => {
          console.error('[cuarentena] load error', err);
          cb({ data: [] });
          $msg.removeClass('d-none').text('Error al cargar datos.');
        });
    },
    columns: [
      { data: 'id', title: 'ID', width: 60 },
      { data: 'codigo_pallet', title: 'Código Pallet' },
      { data: 'producto_nombre', title: 'Producto' },
      { data: 'lote', title: 'Lote', defaultContent: '—' },
      { data: 'fecha_vencimiento', title: 'Vencimiento', defaultContent: '—' },
      { data: 'posicion_codigo', title: 'Posición actual', defaultContent: 'Sin posición' }
    ],
    language: { url: 'https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json' }
  });

  $form.on('submit', function (e) {
    e.preventDefault();
    ingresoId = ($ingreso.val() || '').trim();
    if (!ingresoId) {
      $msg.removeClass('d-none').text('Indicá un Ingreso para consultar.');
      dt.clear().draw();
      enableAssignLink();
      return;
    }
    enableAssignLink();
    dt.ajax.reload();
  });

  $btnRefresh.on('click', function(){ if (ingresoId){ dt.ajax.reload(null, false); } });
  $btnClear.on('click', function(){ ingresoId=null; $ingreso.val(''); enableAssignLink(); $msg.removeClass('d-none').text('Indicá un Ingreso para consultar.'); dt.clear().draw(); });

  // Prefill from query string and auto-run
  try {
    const params = new URLSearchParams(window.location.search);
    const qs = params.get('ingreso_id');
    if (qs) {
      ingresoId = qs;
      $ingreso.val(qs);
      enableAssignLink();
      dt.ajax.reload();
      $msg.addClass('d-none');
    }
  } catch {}

})();
