// Depósito · Productos inmovilizados
$(function () {
  const $form = $("#frmInmov");
  const nfmt = (v, d=0) => new Intl.NumberFormat('es-PY', { minimumFractionDigits:d, maximumFractionDigits:d }).format(v ?? 0);

  const dt = $("#inmovilizadosTable").DataTable({
    ajax: {
      url: joinUrl("api/deposito/inmovilizados.php"),
      data: d => Object.assign(d, Object.fromEntries(new FormData($form[0]).entries())),
      dataSrc: "data",
    },
    order: [["dias_sin_out", "desc"]],
    columns: [
      { data: "cliente",      title: "Cliente" },
      { data: "operativa",    title: "Operativa" },
      { data: "sku",          title: "SKU" },
      { data: "denominacion", title: "Producto" },
      { data: "stock_uc",     title: "Stock (uc)", className: "text-end", render: v => nfmt(v) },
      { data: "ultimo_out",   title: "Último Salida", render: d => d || "—" },
      { data: "dias_sin_out", title: "Días sin Salida", className: "text-end",
        render: v => {
          if (v === null || v === undefined) return '<span class="badge bg-dark">N/C</span>';
          const cls = v >= 180 ? "bg-danger" : v >= 90 ? "bg-warning text-dark" : "bg-secondary";
          return `<span class="badge ${cls}">${nfmt(v)}</span>`;
        }
      },
      { data: "out_en_periodo", title: "OUT en N días", className: "text-end", render: v => nfmt(v) },
    ],
    footerCallback: function (row, data) {
      const api = this.api();
      const sum = (k) => data.reduce((a, r) => a + (Number(r[k]) || 0), 0);
      $(api.column(0).footer()).html("Totales");
      $(api.column(4).footer()).html(nfmt(sum("stock_uc")));
      $(api.column(7).footer()).html(nfmt(sum("out_en_periodo")));
    },
    language: { url: "https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json" },
  });

  $form.on("submit", function (e) { e.preventDefault(); dt.ajax.reload(); });
});
