// Clean implementation for Asignar Posiciones UI
(function(){
  const BASE = (typeof window !== 'undefined' && window.BASE_URL) ? window.BASE_URL : '/';
  const joinUrl = (p) => (BASE.endsWith('/') ? BASE : BASE + '/') + p.replace(/^\/+/, '');

  function notify(icon, title, text){ if (window.Swal) Swal.fire({ icon, title, text, confirmButtonText:'OK' }); else alert(title+': '+text); }
  function showLoading(){ if (window.Swal) Swal.fire({ title:'Procesando...', text:'Por favor espere', allowOutsideClick:false, showConfirmButton:false, willOpen:()=>Swal.showLoading() }); }
  function debugLog(){ try{ console.log.apply(console, ['[ASIG]'].concat([].slice.call(arguments))); }catch(_){} }

  $(function(){
  const $root = $('#asignarPosiciones');
  const ingresoId = $root.data('ingreso-id');
  const defaultDepositoId = $root.data('deposito-id') ? String($root.data('deposito-id')) : null;
    if (!ingresoId){ notify('error','Error','Falta ingreso_id'); return; }

    // State
    let positionsData = [];
    let selectedPosition = null;
    let selectedPallets = [];
    let currentLayoutReq = 0;

    // Style once
    (function ensureStyles(){
      if (document.getElementById('asig-layout-styles')) return;
      const css = [
        '.deposito-layout-rack{margin-bottom:18px}',
        '.rack-header{font-weight:700;margin-bottom:6px;font-size:1rem}',
        '.grid-row{display:flex;gap:8px;align-items:flex-start;flex-wrap:wrap;margin-top:8px}',
        '.layout-col{flex:0 0 84px;display:flex;flex-direction:column;gap:6px;align-items:stretch}',
        '.col-header{font-weight:600;text-align:center;margin-bottom:6px;font-size:.85rem;color:#0f766e}',
        '.pos-tile{width:84px;height:84px;border-radius:6px;background:#fff;border:1px solid #e6e6e6;display:flex;flex-direction:column;align-items:center;justify-content:center;font-weight:700;color:#10403a;box-sizing:border-box;cursor:pointer;transition:all .12s ease;padding:6px;text-align:center}',
        '.pos-tile.available{background:#e6ffef;border-color:#c7f0d9}',
        '.pos-tile.occupied{background:#fff7e6;border-color:#ffe2a8;cursor:not-allowed}',
        '.pos-tile.blocked{background:#fff0f2;border-color:#f6c2c9;cursor:not-allowed}',
        '.pos-tile.selected{background:#e6f6ff;border-color:#bfe6ff;border-width:2px}',
        '.pos-code{font-size:.68rem;color:#334155;margin-top:4px;font-weight:600;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;max-width:90%}',
        '.pos-cap{font-size:.68rem;color:#075985;margin-top:4px;background:#e0f2fe;padding:2px 6px;border-radius:12px;display:inline-block;font-weight:700}',
        '.pallet-item{padding:8px 10px;border:1px solid #dee2e6;border-radius:4px;cursor:pointer;transition:all .12s ease;background:#fff}',
        '.pallet-item:hover{background-color:#e9ecef;border-color:#adb5bd}',
        '.pallet-item.selected{background-color:#d1ecf1;border-color:#bee5eb;color:#0c5460}',
        '@keyframes asig-pulse{0%{box-shadow:0 0 0 0 rgba(59,130,246,.5)}70%{box-shadow:0 0 0 10px rgba(59,130,246,0)}100%{box-shadow:0 0 0 0 rgba(59,130,246,0)}}',
        '.pos-pulse{animation:asig-pulse 520ms ease-out}'
      ].join('\n');
      const st=document.createElement('style'); st.id='asig-layout-styles'; st.appendChild(document.createTextNode(css)); document.head.appendChild(st);
    })();

    function escapeHtml(s){ return String(s).replace(/[&<>\"]/g, c=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;'}[c])); }
    function stateFor(pos){ const cap=parseInt(pos.capacidad_pallets)||0; if(!cap) return {cls:'blocked',txt:'Bloqueada'}; if(pos.ocupado||pos.ocupada||pos.is_ocupado) return {cls:'occupied',txt:'Ocupada'}; const cur=(pos.pallets_actuales!=null?parseInt(pos.pallets_actuales):0); return {cls:(cur>=cap?'occupied':'available'), txt:cur+'/'+cap}; }

    function renderTile(pos){
      const st=stateFor(pos);
      const clases=['pos-tile',st.cls];
      if(selectedPosition && String(selectedPosition.id)===String(pos.id)) clases.push('selected');
      const code=escapeHtml(String(pos.code||pos.pos_code||'N/A'));
      const cap=escapeHtml(String(pos.capacidad_pallets||0));
      return '<div class="'+clases.join(' ')+'" data-position-id="'+pos.id+'">'
        + '<div class="pos-code" title="'+code+'">'+code+'</div>'
        + '<div style="margin-top:6px;display:flex;gap:8px;align-items:center;">'
        +   '<div class="pos-cap">'+cap+'</div>'
        +   '<div class="pos-stat" style="font-size:.65rem;color:#334155;">'+escapeHtml(st.txt)+'</div>'
        + '</div>'
        + '</div>';
    }

    function populateRackSelect(data){
      const rackSel=document.getElementById('fRack'); if(!rackSel) return;
      // allow multi-select racks
      rackSel.multiple = true;
      const prevSelected = Array.isArray($(rackSel).val()) ? $(rackSel).val() : (rackSel.value ? [rackSel.value] : []);
      const racks=new Set(); (Array.isArray(data)?data:[]).forEach(p=>racks.add(String(p.rack??'')));
      rackSel.innerHTML='';
      Array.from(racks).sort().forEach(rk=>{ if(!rk) return; const o=document.createElement('option'); o.value=rk; o.textContent='Rack '+rk; rackSel.appendChild(o); });
      // restore selection if still valid
      try{ if(prevSelected && prevSelected.length){ $(rackSel).val(prevSelected.filter(v=>racks.has(String(v)))); } else { $(rackSel).val([]); } }catch(_){ }
      // refresh decorators safely
      try{ if($(rackSel).data('select2')||$(rackSel).hasClass('select2-hidden-accessible')){ $(rackSel).select2('destroy'); } }catch(_){ }
      try{ if($.fn.select2){ $(rackSel).select2({ width:'resolve', placeholder:'Seleccione rack(s)', allowClear:true, closeOnSelect:false }); } }catch(_){ }
      try{ if($(rackSel).hasClass('selectpicker')) $(rackSel).selectpicker('refresh'); }catch(_){ }
      try{ $(rackSel).trigger('chosen:updated'); }catch(_){ }
    }

    function fetchDepositos(){
      return fetch(joinUrl('api/parametros/depositos.php'))
        .then(r=>r.json())
        .then(list=>{
          const sel=document.getElementById('fDeposito');
          if(!sel) return;
          sel.innerHTML='<option value="">(Seleccionar)</option>';
          if(!Array.isArray(list)){
            console.error('Depositos inesperados', list);
            return;
          }
          list.forEach(d=>{ const o=document.createElement('option'); o.value=d.id; o.textContent=d.nombre; sel.appendChild(o); });

          let preselect = null;
          if (defaultDepositoId && list.some(d=>String(d.id)===defaultDepositoId)) {
            preselect = defaultDepositoId;
          } else if (list.length === 1) {
            preselect = String(list[0].id);
          }

          if (preselect) {
            sel.value = preselect;
            fetchAmbientes(preselect, function(){
              loadLayoutData(preselect, '', { render:false });
            });
          }
        });
    }
    function fetchAmbientes(depId, cb){
      const sel=document.getElementById('fAmbiente');
      if(!sel) return;
      sel.innerHTML='<option value="">(Seleccionar)</option>';
      if(!depId) return;
      fetch(joinUrl('api/parametros/ambientes.php?deposito_id='+depId))
        .then(r=>r.json())
        .then(list=>{
          if(!Array.isArray(list)){
            console.error('Ambientes inesperados', list);
            return;
          }
          list.forEach(a=>{ const o=document.createElement('option'); o.value=a.id; o.textContent=a.nombre; sel.appendChild(o); });
          if(list.length===1){ sel.value=String(list[0].id); }
          if(typeof cb==='function') cb();
        });
    }

    function loadLayoutData(depId, ambId, opts){
      opts = opts || { render:false };
      const grid=document.getElementById('layoutGrid');
      if(!depId){ if(grid) grid.innerHTML='<p class="text-muted">Seleccione depósito</p>'; return; }
      const reqId=++currentLayoutReq;
      if(grid) grid.innerHTML='<p class="text-info">Cargando layout...</p>';
      let url='/api/deposito/layout.php?deposito_id='+depId; if(ambId) url+='&ambiente_id='+ambId;
      fetch(url).then(r=>r.json()).then(data=>{ if(reqId!==currentLayoutReq) return; positionsData=Array.isArray(data)?data:[]; populateRackSelect(positionsData); if (opts.render) { renderLayout(); } else { if(grid) grid.innerHTML='<p class="text-muted">Seleccione rack(s) y presione Refrescar para ver el layout</p>'; } }).catch(e=>{ if(grid) grid.innerHTML='<p class="text-danger">Error al cargar layout</p>'; console.error(e); }); }

    function renderLayout(){
      const grid=document.getElementById('layoutGrid'); if(!grid) return;
      const msg=document.getElementById('layoutMsg'); if(msg) msg.style.display='none';
      let val = $('#fRack').val();
      const selectedRacks = Array.isArray(val) ? val.filter(Boolean) : (val ? [val] : []);
      if (selectedRacks.length === 0){ grid.innerHTML='<p class="text-muted">Seleccione rack(s) y presione Refrescar</p>'; return; }
      const data = positionsData.filter(p=> selectedRacks.includes(String(p.rack??'')) );
      if(!data.length){ grid.innerHTML='<p class="text-muted">No hay datos para los rack(s) seleccionados</p>'; return; }
      const racks=new Map(); data.forEach(p=>{ const rid=String(p.rack??'sin_rack'); if(!racks.has(rid)) racks.set(rid,[]); racks.get(rid).push(p); });
      const out=[]; racks.forEach((positions,rackId)=>{ out.push('<div class="deposito-layout-rack">'); out.push('<div class="rack-header">Rack '+(rackId==='sin_rack'?'Sin Rack':rackId)+'</div>'); const cols=new Map(); positions.forEach(p=>{ const c=String(p.columna||1); if(!cols.has(c)) cols.set(c,[]); cols.get(c).push(p); }); out.push('<div class="grid-row">'); Array.from(cols.keys()).sort((a,b)=>parseInt(a)-parseInt(b)).forEach(colKey=>{ const col=cols.get(colKey).slice().sort((a,b)=>(parseInt(a.nivel)||1)-(parseInt(b.nivel)||1)); out.push('<div class="layout-col">'); out.push('<div class="col-header">Col '+colKey+'</div>'); col.forEach(pos=>out.push(renderTile(pos))); out.push('</div>'); }); out.push('</div>'); out.push('</div>'); });
      grid.innerHTML=out.join(''); attachPositionHandlers();
    }

    function attachPositionHandlers(){ document.querySelectorAll('.pos-tile.available').forEach(t=>{ t.addEventListener('click', function(){ const id=this.dataset.positionId; const pos=positionsData.find(p=>String(p.id)===String(id)); if(!pos) return; selectPosition(pos); if(selectedPallets.length>0) assignPallets(); }); t.addEventListener('contextmenu', function(e){ e.preventDefault(); const id=this.dataset.positionId; if(!id) return; Swal.fire({title:'Desasignar posición',text:'¿Desea desasignar todos los pallets de esta posición (mover a CUARENTENA)?',icon:'warning',showCancelButton:true,confirmButtonText:'Sí, desasignar',cancelButtonText:'Cancelar'}).then(res=>{ if(res.isConfirmed) desasignarPorPosicion(id); }); }); }); }
    function selectPosition(position){ document.querySelectorAll('.pos-tile.selected').forEach(t=>t.classList.remove('selected')); const tile=document.querySelector('[data-position-id="'+position.id+'"]'); if(tile) tile.classList.add('selected'); selectedPosition=position; updateAssignButton(); }

    function loadPallets(){ fetch(joinUrl('/api/operaciones/pallets_en_cuarentena.php?ingreso_id='+ingresoId)).then(r=>r.json()).then(d=>{ if(d.error){ notify('error','Error',d.error); return;} renderPallets(d.success&&d.data?d.data:[]); }).catch(e=>{ console.error(e); notify('error','Error','Error al cargar pallets'); }); }
    function renderPallets(pallets){ const c=$('#palletsList'); if(!pallets.length){ c.html('<p class="text-muted">No hay pallets en cuarentena</p>'); return;} const out=pallets.map(p=>'<div class="pallet-item'+(selectedPallets.includes(p.id)?' selected':'')+'" data-pallet-id="'+p.id+'">'+'<strong>Pallet '+p.codigo_pallet+'</strong><br>'+'<small>Producto: '+p.producto_nombre+'</small><br>'+'<small>Lote: '+p.lote+' | Venc: '+p.fecha_vencimiento+'</small><br>'+'<small>Cantidad: '+p.cantidad_recibida+'</small>'+'</div>'); c.html(out.join('')); attachPalletHandlers(); }
    function attachPalletHandlers(){ $('.pallet-item').off('click').on('click', function(){ const id=$(this).data('pallet-id'); togglePalletSelection(id); }); $('.pallet-item').off('contextmenu').on('contextmenu', function(e){ e.preventDefault(); const id=$(this).data('pallet-id'); if(!id) return; Swal.fire({title:'Desasignar pallet',text:'¿Desea desasignar este pallet y moverlo a CUARENTENA?',icon:'warning',showCancelButton:true,confirmButtonText:'Sí, desasignar',cancelButtonText:'Cancelar'}).then(res=>{ if(res.isConfirmed) desasignarPorPallet(id); }); }); }
    function togglePalletSelection(id){ const idx=selectedPallets.indexOf(id); if(idx>-1){ selectedPallets.splice(idx,1); $('.pallet-item[data-pallet-id="'+id+'"]').removeClass('selected'); } else { selectedPallets.push(id); $('.pallet-item[data-pallet-id="'+id+'"]').addClass('selected'); } updateAssignButton(); }
    function updateAssignButton(){ const btn=$('#btnAsignar'); const can=selectedPallets.length>0 && selectedPosition!==null; btn.prop('disabled', !can); btn.text(can?('Asignar '+selectedPallets.length+' pallet(s) a '+(selectedPosition.code||selectedPosition.pos_code||'N/A')):'Seleccione pallets y posición'); }

    function assignPallets(){
      if(selectedPallets.length===0||!selectedPosition){ notify('warning','Atención','Debe seleccionar pallets y una posición'); return; }
      showLoading();
      const depId=document.getElementById('fDeposito').value;
      const payload={ pallet_ids:selectedPallets, posicion_id:selectedPosition.id, deposito_id:depId, usuario_id:1 };
      fetch(joinUrl('/api/operaciones/asignar_posicion.php'),{ method:'POST', headers:{'Content-Type':'application/json'}, body:JSON.stringify(payload)})
        .then(r=>r.json())
        .then(res=>{
          if(window.Swal) Swal.close();
          if(res&&res.ok){
            const codigo=selectedPosition.code||selectedPosition.pos_code||'N/A';
            const moved=res.moves_created||(res.moves?res.moves.length:selectedPallets.length);
            notify('success','Éxito','Se asignaron '+moved+' pallets a la posición '+codigo);
            // Remove pallets from the list (immediate UI feedback)
            selectedPallets.forEach(pid=>{ const el=document.querySelector('.pallet-item[data-pallet-id="'+pid+'"]'); if(el){ el.style.transition='opacity .25s,height .25s,margin .25s,padding .25s'; el.style.opacity='0'; setTimeout(()=>{ if(el.parentNode) el.parentNode.removeChild(el); },260); } });
            // Update internal position counters/state
            const pos = positionsData.find(p=>String(p.id)===String(selectedPosition.id));
            if (pos){
              const cap = parseInt(pos.capacidad_pallets)||0;
              const curr = parseInt(pos.pallets_actuales||0)||0;
              const next = curr + (parseInt(moved)||selectedPallets.length||1);
              pos.pallets_actuales = next;
              pos.ocupado = (cap>0 && next >= cap) ? true : false;
              updatePositionTile(pos);
            } else {
              // fallback: mark occupied visually
              markPositionOccupied(selectedPosition.id);
            }
            // Reset selection and button state
            selectedPallets=[]; selectedPosition=null; updateAssignButton();
            // Refresh pallets list from server (keeps UI consistent)
            loadPallets();
            if(res.warnings&&Array.isArray(res.warnings)&&res.warnings.length) notify('warning','Advertencia',res.warnings.join('\n'));
          } else {
            const err=(res&&(res.error||(Array.isArray(res.warnings)?res.warnings.join('\n'):null)))||'Error al asignar pallets';
            notify('error','Error',err);
          }
        })
        .catch(e=>{ if(window.Swal) Swal.close(); console.error(e); notify('error','Error','Error al asignar pallets'); });
    }
    function desasignarPorPallet(id){ showLoading(); fetch(joinUrl('/api/operaciones/desasignar_posicion.php'),{ method:'POST', headers:{'Content-Type':'application/json'}, body:JSON.stringify({ pallet_id:id })}).then(r=>r.json()).then(res=>{ if(window.Swal) Swal.close(); if(res.ok){ notify('success','Éxito','Pallet desasignado'); loadPallets(); const dep=document.getElementById('fDeposito').value; const amb=(document.getElementById('fAmbiente')||{}).value||''; if(dep) loadLayoutData(dep, amb);} else { notify('error','Error',res.error||'Error al desasignar'); } }).catch(e=>{ if(window.Swal) Swal.close(); console.error(e); notify('error','Error','Error en servidor'); }); }
    function desasignarPorPosicion(id){ showLoading(); fetch(joinUrl('/api/operaciones/desasignar_posicion.php'),{ method:'POST', headers:{'Content-Type':'application/json'}, body:JSON.stringify({ posicion_id:id })}).then(r=>r.json()).then(res=>{ if(window.Swal) Swal.close(); if(res.ok){ notify('success','Éxito','Posición desasignada'); loadPallets(); const dep=document.getElementById('fDeposito').value; const amb=(document.getElementById('fAmbiente')||{}).value||''; if(dep) loadLayoutData(dep, amb);} else { notify('error','Error',res.error||'Error al desasignar'); } }).catch(e=>{ if(window.Swal) Swal.close(); console.error(e); notify('error','Error','Error en servidor'); }); }

    function markPositionOccupied(id){ try{ const t=document.querySelector('[data-position-id="'+id+'"]'); if(!t) return; t.classList.remove('available','selected'); t.classList.add('occupied'); }catch(_){} }

    // Update a single tile DOM according to the data in positionsData
    function updatePositionTile(pos){
      try{
        const tile = document.querySelector('[data-position-id="'+pos.id+'"]');
        if(!tile) return;
        const st = stateFor(pos);
        tile.classList.remove('available','occupied','blocked');
        tile.classList.add(st.cls);
        const capEl = tile.querySelector('.pos-cap'); if (capEl) capEl.textContent = String(pos.capacidad_pallets||0);
        const statEl = tile.querySelector('.pos-stat'); if (statEl) statEl.textContent = String(st.txt);
        // Visual pulse feedback
        tile.classList.remove('pos-pulse');
        void tile.offsetWidth; // reflow to restart animation
        tile.classList.add('pos-pulse');
        setTimeout(()=>tile.classList.remove('pos-pulse'), 600);
        // If becomes occupied, it should not be clickable for assignment; if available, ensure click works
        // Easiest: reattach handlers only on this tile if it stays available
        const isAvailable = st.cls === 'available';
        const clone = tile.cloneNode(true);
        tile.parentNode.replaceChild(clone, tile);
        if (isAvailable){
          clone.addEventListener('click', function(){ const id=this.dataset.positionId; const p=positionsData.find(pp=>String(pp.id)===String(id)); if(!p) return; selectPosition(p); if(selectedPallets.length>0) assignPallets(); });
          clone.addEventListener('contextmenu', function(e){ e.preventDefault(); const id=this.dataset.positionId; if(!id) return; Swal.fire({title:'Desasignar posición',text:'¿Desea desasignar todos los pallets de esta posición (mover a CUARENTENA)?',icon:'warning',showCancelButton:true,confirmButtonText:'Sí, desasignar',cancelButtonText:'Cancelar'}).then(res=>{ if(res.isConfirmed) desasignarPorPosicion(id); }); });
        }
      }catch(e){ console.error('updatePositionTile error', e); }
    }

    function setupEventHandlers(){
  $('#fDeposito').off('change').on('change', function(){ const v=this.value; positionsData=[]; populateRackSelect([]); const grid=document.getElementById('layoutGrid'); if(grid) grid.innerHTML='<p class="text-muted">Seleccione ambiente y presione Refrescar</p>'; fetchAmbientes(v); });
  $('#fAmbiente').off('change').on('change', function(){ const grid=document.getElementById('layoutGrid'); if(grid) grid.innerHTML='<p class="text-muted">Presione Refrescar para cargar el layout</p>'; });
  $('#fRack').off('change'); // no auto-render on rack change
      $('#btnAsignar').off('click').on('click', assignPallets);
  $('#btnRefreshLayout').off('click').on('click', function(){ const dep=(document.getElementById('fDeposito')||{}).value; const amb=(document.getElementById('fAmbiente')||{}).value||''; if(dep) loadLayoutData(dep, amb, { render:true }); });
      $('#btnAutoPicking').off('click').on('click', function(){
        const depId = (document.getElementById('fDeposito')||{}).value;
        if(!depId){ notify('warning','Atención','Seleccione un depósito primero'); return; }
        const capacity = parseInt(document.getElementById('autoCap').value||'20')||20;
        const limitVal = document.getElementById('autoLimit') ? parseInt(document.getElementById('autoLimit').value||'0')||0 : 0;
        const simulate = document.getElementById('autoSim').checked ? 1 : 0;
        const includeWithPos = document.getElementById('autoIncludePos') && document.getElementById('autoIncludePos').checked ? 1 : 0;
        const changeState = document.getElementById('autoChangeState') && document.getElementById('autoChangeState').checked ? 1 : 0;
        const targetState = document.getElementById('autoTargetState') ? (document.getElementById('autoTargetState').value||'').trim() : '';
        Swal.fire({
          title: simulate? 'Simular carga automática a picking' : 'Ejecutar carga automática a picking',
          text: simulate? 'Se calculará el plan sin aplicar cambios.' : 'Se asignarán pallets de Cuarentena a posiciones PICKING hasta completar la capacidad.',
          icon: simulate? 'info' : 'question',
          showCancelButton: true,
          confirmButtonText: simulate? 'Simular' : 'Ejecutar',
          cancelButtonText: 'Cancelar'
        }).then(res=>{
          if(!res.isConfirmed) return;
          // Button loading state
          const btn = document.getElementById('btnAutoPicking');
          const oldHtml = btn ? btn.innerHTML : '';
          if (btn){ btn.disabled = true; btn.innerHTML = '<span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span>Procesando...'; }
          showLoading();
          fetch(joinUrl('/api/ingresos/auto_assign_picking.php'),{
            method:'POST', headers:{'Content-Type':'application/json'},
            body: JSON.stringify({ ingreso_id: ingresoId, capacity, simulate, deposito_id: depId, limit: limitVal, include_with_position: includeWithPos, change_state: changeState, target_state_code: targetState })
          }).then(r=>r.json()).then(data=>{
            if(window.Swal) Swal.close();
            if (btn){ btn.disabled = false; btn.innerHTML = oldHtml; }
            if(!data || data.ok!==true){ notify('error','Error', (data&&data.error)||'Error al ejecutar'); return; }
            const assigned = data.assigned||0;
            const lines = (Array.isArray(data.positions)?data.positions:[]).map(p=>`Pos #${p.posicion_id}: ${p.count}`);
            const title = data.simulate? 'Simulación realizada' : 'Carga completada';
            const summary = (data.simulate? 'Simulación: ' : '') + `Total pallets ${data.simulate? 'planificados':'asignados'}: ${assigned}`;
            let htmlDetail = '<div style="text-align:left">'
              + '<p class="mb-2">' + summary + '</p>'
              + (lines.length ? '<div style="max-height:260px;overflow:auto"><pre class="small mb-0">'+ lines.join('\n') +'</pre></div>' : '<small class="text-muted">Sin detalle por posición.</small>');
            if (data.changed_state && data.changed_state.count){
              htmlDetail += '<p class="mt-2 mb-0">Estados actualizados: <b>'+ data.changed_state.count +'</b>' + (data.changed_state.code? ' → <code>'+data.changed_state.code+'</code>' : '') + '</p>';
            }
            if (Array.isArray(data.rehomed_from) && data.rehomed_from.length){
              htmlDetail += '<p class="mt-1 mb-0 small text-muted">Recalculo de ocupación aplicado a '+ data.rehomed_from.length +' posiciones de origen.</p>';
            }
            htmlDetail += '</div>';
            if (window.Swal) Swal.fire({ icon:'success', title, html: htmlDetail }); else alert(summary);
            // Badge de último resultado
            try {
              const badge = document.getElementById('autoPickingBadge');
              if (badge){
                badge.style.display = 'inline-block';
                badge.className = 'badge ' + (data.simulate? 'bg-info text-dark' : 'bg-success');
                badge.textContent = (data.simulate? 'Simulado: ' : 'Aplicado: ') + assigned;
              }
            } catch (_){}
            // Refresh UI
            loadPallets();
            const amb=(document.getElementById('fAmbiente')||{}).value||''; if(depId) loadLayoutData(depId, amb, { render:true });
          }).catch(e=>{ if(window.Swal) Swal.close(); console.error(e); notify('error','Error','No se pudo ejecutar la carga automática'); });
        });
      });
      // enable/disable target state input based on checkbox
      $('#autoChangeState').off('change').on('change', function(){
        const on = $(this).is(':checked');
        $('#autoTargetState').prop('disabled', !on);
      });
    }

    // Init
    setupEventHandlers();
    fetchDepositos();
    loadPallets();
    updateAssignButton();

    window.__asig_force_load=function(){ try{ const dep=(document.getElementById('fDeposito')||{}).value; const amb=(document.getElementById('fAmbiente')||{}).value||''; if(dep) loadLayoutData(dep, amb);}catch(_){}};
  });
})();