// public/page-scripts/pages/ingresos/detalle_scripts.js
(function () {
  const BASE =
    typeof window !== "undefined" && window.BASE_URL ? window.BASE_URL : "/";
  const joinUrl = (p) =>
    (BASE.endsWith("/") ? BASE : BASE + "/") + p.replace(/^\/+/, "");

  function notify(icon, title, text) {
    Swal.fire({ icon, title, text, confirmButtonText: "OK" });
  }

  $(function () {
    const root = $("#ingresoDetalle");
    const ingresoId = root.data("ingreso-id");

    if (!ingresoId) {
      notify("error", "Error", "Falta ingreso_id");
      return;
    }

    // Cabecera (ligera): lo sacamos de pl_ingreso + joins (endpoint simple inline aquí)
    $.getJSON(
      joinUrl(`api/operaciones/ingresos_header.php?ingreso_id=${ingresoId}`)
    ).done((res) => {
      if (!res || res.ok !== true) return;
      const h = res.data || {};
      $("#hdr-packing-list").text(h.packing_list || "-");
      $("#hdr-deposito").text(h.deposito || "-");
      $("#hdr-movil").text(h.movil || "-");
      $("#hdr-chofer").text(h.chofer || "-");
      $("#hdr-fecha").text(h.fecha_ingreso || "-");
      $("#hdr-inicio").text(h.descarga_inicio_at || "-");
      $("#hdr-ops").text(h.operarios_cant ?? "-");
      $("#hdr-obs").text(h.observacion || "-");
      $("#hdr-doc").text(`${h.doc_tipo || ""} ${h.doc_numero || ""}`.trim() || "-");
      $("#hdr-doc-fecha").text(h.doc_fecha || "-");
    });

    // Mostrar/ocultar botón Asignar según estado de posicionamiento
    function updateAssignButtonVisibility() {
      fetch(joinUrl('api/operaciones/ingresos_pos_status.php?ids=' + ingresoId))
        .then(r => r.json())
        .then(j => {
          if (!j || j.ok !== true || !j.data) return;
          const info = j.data[ingresoId];
          if (!info) return;
          const completo = info.estado === 'completo';
          const $btn = $("#btnAsignarPosiciones");
          if (completo) $btn.addClass('d-none'); else $btn.removeClass('d-none');
        })
        .catch(() => {/* noop */});
    }

    // Pallets
    const dtPallets = $("#tblIngresoPallets").DataTable({
      ajax: {
        url: joinUrl(
          `api/operaciones/ingresos_pallets.php?ingreso_id=${ingresoId}`
        ),
        dataSrc: "data",
      },
      columns: [
        { data: "pallet_id", title: "ID" },
        { data: "pallet_codigo", title: "Código pallet" },
        { data: "posicion", title: "Posición" },
        {
          data: "items_count",
          title: "Ítems",
          render: $.fn.dataTable.render.number(".", ",", 0, ""),
        },
        {
          data: "uv_total",
          title: "UV total",
          render: $.fn.dataTable.render.number(".", ",", 0, ""),
        },
        {
          data: "uc_total",
          title: "UC totales",
          render: $.fn.dataTable.render.number(".", ",", 0, ""),
        },
      ],
      order: [[0, "asc"]],
      language: {
        url: "https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json",
      },
      footerCallback: function (row, data, start, end, display) {
        const api = this.api();

        // función para parsear los números
        const intVal = (i) =>
          typeof i === "string"
            ? parseInt(i.replace(/\./g, ""), 10) || 0
            : typeof i === "number"
            ? i
            : 0;

        // columnas que se deben sumar (índices desde 0)
        [3, 4, 5].forEach(function (colIdx) {
          const total = api
            .column(colIdx, { page: "current" })
            .data()
            .reduce((a, b) => a + intVal(b), 0);

          $(api.column(colIdx).footer()).html(
            new Intl.NumberFormat("es-ES").format(total, { style: "decimal" })
          );
        });
      },
    });

    // Chequear visibilidad del botón luego de cargar pallets
    $("#tblIngresoPallets").on('xhr.dt', function(){
      updateAssignButtonVisibility();
    });
    // Y una vez al inicio
    setTimeout(updateAssignButtonVisibility, 200);

    // Items
    const dtItems = $("#tblIngresoItems").DataTable({
      ajax: {
        url: joinUrl(
          `api/operaciones/ingresos_items.php?ingreso_id=${ingresoId}`
        ),
        dataSrc: "data",
      },
      columns: [
        { data: "pallet_codigo", title: "Pallet" },
        { data: "sku", title: "SKU" },
        { data: "denominacion", title: "Producto" },
        { data: "lote", title: "Lote" },
        { data: "fecha_produccion", title: "F.Prod" },
        { data: "fecha_vencimiento", title: "F.Vto" },
        {
          data: "uv_cajas",
          title: "UV cajas",
          render: $.fn.dataTable.render.number(".", ",", 0, ""),
        },
        {
          data: "uc_por_caja",
          title: "UC x caja",
          render: $.fn.dataTable.render.number(".", ",", 0, ""),
        },
        {
          data: "uc_sueltas",
          title: "UC sueltas",
          render: $.fn.dataTable.render.number(".", ",", 0, ""),
        },
        {
          data: "uc_total",
          title: "UC totales",
          render: $.fn.dataTable.render.number(".", ",", 0, ""),
        },
      ],
      order: [[0, "asc"]],
      language: {
        url: "https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json",
      },
      footerCallback: function (row, data, start, end, display) {
        const api = this.api();
        const intVal = (i) =>
          typeof i === "string"
            ? parseInt(i.replace(/\./g, ""), 10) || 0
            : typeof i === "number"
            ? i
            : 0;

        // columnas numéricas: uv_cajas(6), uc_por_caja(7), uc_sueltas(8), uc_total(9)
        [6, 7, 8, 9].forEach(function (colIdx) {
          const total = api
            .column(colIdx, { page: "current" })
            .data()
            .reduce((a, b) => a + intVal(b), 0);

          $(api.column(colIdx).footer()).html(
            new Intl.NumberFormat("es-ES").format(total)
          );
        });
      },
    });

    // Movimientos de Ingreso
    const dtMoves = $("#tblIngresoMoves").DataTable({
      ajax: {
        url: joinUrl(
          `api/operaciones/moves_por_ingreso.php?ingreso_id=${ingresoId}`
        ),
        dataSrc: "data",
      },
      columns: [
        { data: "id", title: "ID" },
        { data: "tipo", title: "Tipo" },
        { data: "motivo", title: "Motivo" },
        { data: "pallet_codigo", title: "Pallet" },
        { data: "posicion_desde", title: "Desde" },
        { data: "posicion_hacia", title: "Hacia" },
        {
          data: "delta_uv",
          title: "ΔUV",
          render: $.fn.dataTable.render.number(".", ",", 0, ""),
        },
        {
          data: "delta_uc",
          title: "ΔUC",
          render: $.fn.dataTable.render.number(".", ",", 0, ""),
        },
        { data: "referencia", title: "Referencia" },
        {
          data: "created_at",
          title: "Fecha",
          render: function (data) {
            if (!data) return "-";
            const date = new Date(data);
            return date.toLocaleString("es-ES");
          },
        },
      ],
      order: [[0, "desc"]],
      language: {
        url: "https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json",
      },
    });

    // Botón para asignar posiciones
    $("#btnAsignarPosiciones").on("click", function () {
      const url = joinUrl(`/ingresos/asignar_posiciones?ingreso_id=${ingresoId}`);
      window.open(url, "_self");
    });
  });
})();
