// public/page-scripts/pages/ingresos/ingresos_scripts.js
// DataTables + Editor: Operaciones → Ingresos (pl_ingreso)

$(document).ready(function () {
  // Helper para construir URLs
  const BASE = typeof window !== "undefined" && window.BASE_URL ? window.BASE_URL : "/";
  const joinUrl = (p) => (BASE.endsWith("/") ? BASE : BASE + "/") + p.replace(/^\/+/, "");

  const tableId = "ingresosTable";
  const ajaxUrl = "/api/operaciones/ingresos.php";

  // -------- Editor fields (pl_ingreso.*) --------
  // Los options para selects vienen del servidor (Editor PHP).
  const editorFields = [
    { name: "pl_ingreso.id", type: "hidden" },

    { label: "Packing List", name: "pl_ingreso.packinglist_id", type: "select", placeholder: "Seleccione packing list" },
    { label: "Depósito", name: "pl_ingreso.deposito_id", type: "select", placeholder: "Seleccione depósito" },

    {
      label: "Fecha de ingreso",
      name: "pl_ingreso.fecha_ingreso",
      type: "datetime",
      format: "YYYY-MM-DD",
      def: function () {
        const pad = (n) => String(n).padStart(2, "0");
        const d = new Date();
        return `${d.getFullYear()}-${pad(d.getMonth() + 1)}-${pad(d.getDate())}`;
      },
    },

    { label: "Hora llegada",         name: "pl_ingreso.llegada_at",         type: "datetime", format: "HH:mm:ss" },
    { label: "Inicio descarga",      name: "pl_ingreso.descarga_inicio_at", type: "datetime", format: "HH:mm:ss" },
    { label: "Fin descarga",         name: "pl_ingreso.descarga_fin_at",    type: "datetime", format: "HH:mm:ss" },

    {
      label: "Tipo documento",
      name: "pl_ingreso.doc_tipo",
      type: "select",
      options: [
        { label: "Factura", value: "FACTURA" },
        { label: "Remito",  value: "REMITO" },
        { label: "Otro",    value: "OTRO" }
      ]
    },
    { label: "Número documento", name: "pl_ingreso.doc_numero" },
    { label: "Fecha documento",  name: "pl_ingreso.doc_fecha", type: "datetime", format: "YYYY-MM-DD" },

    { label: "Móvil (camión)", name: "pl_ingreso.movil_id", type: "select", placeholder: "Seleccione móvil" },
    { label: "Chofer",         name: "pl_ingreso.chofer_id", type: "select", placeholder: "Seleccione chofer" },

    { label: "Operarios (cant.)", name: "pl_ingreso.operarios_cant" },

    { label: "Observación", name: "pl_ingreso.observacion", type: "textarea" },

    // Auditoría (hidden) - solo created_at y updated_at en nueva tabla
    { name: "pl_ingreso.created_at", type: "hidden" },
    { name: "pl_ingreso.updated_at", type: "hidden" },
  ];

  // -------- Columnas DataTable --------
  const columns = [
    {
      data: null,
      defaultContent: "",
      className: "select-checkbox",
      orderable: false,
      searchable: false,
      title: "",
      width: "20px"
    },
    {
      data: "pl_ingreso.id",
      title: "Acciones",
      orderable: false,
      render: (id) => `
        <div class="btn-group btn-group-sm" role="group">
          <a data-ingreso-id="${id}" class="btn btn-outline-primary btn-ver-detalle" href="${joinUrl('ingresos/detalle')}?ingreso_id=${id}">Ver</a>
          <a class="btn btn-outline-warning" href="${joinUrl('deposito/cuarentena')}?ingreso_id=${id}" title="Ubicar pallets en cuarentena">
            Cuarentena
          </a>
        </div>`
    },
    { data: "pl_ingreso.id", title: "ID", visible: false },

    {
      data: "pl_ingreso.fecha_ingreso",
      title: "Fecha ingreso",
      render: (val) => val ? `<span class="text-nowrap">${val}</span>` : ""
    },
    { data: "pl_ingreso.llegada_at",         title: "Llegada", render: (v)=> v||"" },
    { data: "pl_ingreso.descarga_inicio_at", title: "Inicio", render: (v)=> v||"" },
    { data: "pl_ingreso.descarga_fin_at",    title: "Fin",    render: (v)=> v||"" },

    {
      data: null,
      title: "Documento",
      render: (r) => `${r.pl_ingreso.doc_tipo ?? ''} ${r.pl_ingreso.doc_numero ?? ''}`.trim()
    },

    { data: "pl_packinglist.codigo", title: "Packing List", defaultContent: "" },
    { data: "wh_deposito.nombre",    title: "Depósito",     defaultContent: "" },
    { data: "para_moviles.chapa",    title: "Camión",       defaultContent: "" },
    { data: "para_choferes.nombre",  title: "Chofer",       defaultContent: "" },

    {
      data: "pl_ingreso.operarios_cant",
      title: "Operarios",
      className: "text-end",
      render: (v)=> v ?? ""
    },

    { data: "pl_ingreso.observacion", title: "Observación", defaultContent: "" },

    // Fechas (ocultas)
    { data: "pl_ingreso.created_at", title: "Creado", visible: false },
    { data: "pl_ingreso.updated_at", title: "Actualizado", visible: false },
  ];

  // THEAD dinámico si falta
  const $table = $("#" + tableId);
  if ($table.find("thead").length === 0) {
    let thead = "<thead><tr>";
    columns.forEach(col => thead += `<th>${col.title ? col.title : ""}</th>`);
    thead += "</tr></thead>";
    $table.prepend(thead);
  }

  // Inicialización (usa tu helper común)
  const { editor, tableInstance } = initializeBaseDataTable({
    tableId,
    ajaxUrl,
    editorFields,
    columns,
    buttons: ["create", "edit", "remove", "excel", "csv", "pdf"],
    select: { style: "os", selector: "td.select-checkbox" },
    order: [[3, "desc"]], // fecha_ingreso desc
  });

  // --- Colorear botón "Ver" según estado de posicionamiento ---
  function updateStatusColors() {
    const api = $('#' + tableId).DataTable();
    const ids = [];
    api.rows({ page: 'current' }).every(function() {
      const data = this.data();
      if (data && data.pl_ingreso && data.pl_ingreso.id) ids.push(parseInt(data.pl_ingreso.id, 10));
    });
    if (!ids.length) return;

    // Fetch estado for these ids
    fetch(joinUrl('api/operaciones/ingresos_pos_status.php?ids=' + ids.join(',')))
      .then(r => r.json())
      .then(json => {
        if (!json || json.ok !== true || !json.data) return;
        const map = json.data;
        // Colors: completo -> success, parcial -> warning, ninguno -> outline-primary (default)
        $('#' + tableId + ' a.btn-ver-detalle').each(function() {
          const $btn = $(this);
          const id = parseInt($btn.attr('data-ingreso-id'), 10);
          if (!id || !(id in map)) return;
          const estado = map[id].estado;
          $btn.removeClass('btn-outline-primary btn-primary btn-success btn-warning');
          if (estado === 'completo') {
            $btn.addClass('btn-success');
          } else if (estado === 'parcial') {
            $btn.addClass('btn-warning');
          } else {
            $btn.addClass('btn-outline-primary');
          }
        });

        // Show/Hide Cuarentena button only if there are pallets in CUARENTENA
        $('#' + tableId + ' a[href*="/deposito/cuarentena"]').each(function(){
          const $btn = $(this);
          // Previous sibling Ver button has data-ingreso-id
          const id = parseInt($btn.closest('.btn-group').find('a.btn-ver-detalle').attr('data-ingreso-id'), 10);
          if (!id || !(id in map)) return;
          const cant = map[id].pallets_cuarentena || 0;
          if (cant > 0) {
            $btn.removeClass('d-none');
          } else {
            $btn.addClass('d-none');
          }
        });
      })
      .catch(() => {/*noop*/});
  }

  // Hook on draw to recolor
  $('#' + tableId).on('draw.dt', function() {
    updateStatusColors();
  });

  // Also initial after load (some helpers draw immediately)
  setTimeout(updateStatusColors, 300);
});
