/* public/page-scripts/pages/inventario/a_caducar_scripts.js */
/* global $, Intl */

$(function () {
  const tableId = '#aCaducarTable';
  const $form = $('#frmFiltrosACaducar');

  // ---------- Helpers ----------
  const fmtInt = (v) => {
    const n = Number(v ?? 0);
    try { return new Intl.NumberFormat('es-PY').format(n); }
    catch { return (n || 0).toString(); }
  };

  function renderEstado(v) {
    const t = String(v || '').toUpperCase();
    if (t === 'VENCIDO') return '<span class="badge bg-danger">Vencido</span>';
    if (t === 'PROXIMO') return '<span class="badge bg-warning text-dark">Próximo</span>';
    return '<span class="badge bg-success">OK</span>';
  }

  // ---------- Cargar combos (clientes / operativas) ----------
  function cargarCombos() {
    // Clientes
    $.getJSON('/api/inventario/a_caducar.php?meta=clientes')
      .done((res) => {
        const $c = $('#fCliente');
        if (res && Array.isArray(res.clientes)) {
          res.clientes.forEach((r) => $c.append(new Option(`${r.razon_social} (ID ${r.id})`, r.id)));
        }
      });

    // Operativas
    $.getJSON('/api/inventario/a_caducar.php?meta=operativas')
      .done((res) => {
        const $o = $('#fOperativa');
        if (res && Array.isArray(res.operativas)) {
          res.operativas.forEach((r) => $o.append(new Option(`${r.nombre} (ID ${r.id})`, r.id)));
        }
      });
  }

  // ---------- DataTable ----------
  const dt = $(tableId).DataTable({
    processing: true,
    serverSide: true,
    searching: false,
    lengthChange: true,
    pageLength: 25,
    ajax: {
      url: '/api/inventario/a_caducar.php',
      type: 'GET',
      data: function (d) {
        const params = Object.fromEntries(new FormData($form[0]).entries());
        return Object.assign({}, d, params, { action: 'list' });
      },
      dataSrc: function (json) {
        return json.data || [];
      }
    },
    columns: [
      { data: 'cliente',        title: 'Cliente' },
      { data: 'operativa',      title: 'Operativa' },
      { data: 'sku',            title: 'SKU' },
      { data: 'denominacion',   title: 'Producto' },
      { data: 'lote',           title: 'Lote' },
      { data: 'vencimiento',    title: 'Vencimiento' },
      { data: 'dias_restantes', title: 'Días restantes', className: 'text-end' },
      { data: 'ubicacion',      title: 'Ubicación' },

      { data: 'pallets',        title: 'Pallets',     className: 'text-end', render: (d)=> fmtInt(d) },
      { data: 'cajas',          title: 'Cajas',       className: 'text-end', render: (d)=> fmtInt(d) },
      { data: 'unidades',       title: 'Unidades',    className: 'text-end', render: (d)=> fmtInt(d) },
      { data: 'stock',          title: 'Stock',       className: 'text-end', render: (d)=> fmtInt(d) },
      { data: 'reservados',     title: 'Reservados',  className: 'text-end', render: (d)=> fmtInt(d) },
      { data: 'disponibles',    title: 'Disponibles', className: 'text-end', render: (d)=> fmtInt(d) },

      { data: 'estado',         title: 'Estado', render: (d)=> renderEstado(d) },
    ],
  order: [[ 6, 'asc' ], [ 5, 'asc' ]], // por defecto: menor "días restantes" primero, luego fecha vto
    language: { url: 'https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json' },

    // Totales en footer (página actual)
    footerCallback: function () {
      const api = this.api();
      const sumCol = (idx) =>
        api.column(idx, { page: 'current' }).data()
          .reduce((a, b) => (Number(a) || 0) + (Number(b) || 0), 0);

      // Índices: pallets(8) cajas(9) unidades(10) stock(11) reservados(12) disponibles(13)
      const cols = { pallets:8, cajas:9, unidades:10, stock:11, reserv:12, disp:13 };
      $(api.column(cols.pallets ).footer()).html(fmtInt(sumCol(cols.pallets )));
      $(api.column(cols.cajas   ).footer()).html(fmtInt(sumCol(cols.cajas   )));
      $(api.column(cols.unidades).footer()).html(fmtInt(sumCol(cols.unidades)));
      $(api.column(cols.stock   ).footer()).html(fmtInt(sumCol(cols.stock   )));
      $(api.column(cols.reserv  ).footer()).html(fmtInt(sumCol(cols.reserv  )));
      $(api.column(cols.disp    ).footer()).html(fmtInt(sumCol(cols.disp    )));
    }
  });

  // Filtros → recargar
  $form.on('submit', function (e) {
    e.preventDefault();
    dt.ajax.reload();
  });

  // ---------- Botón PDF: filtros + orden actual ----------
  $('#btnPdfACaducar').on('click', function () {
    const base = '/api/inventario/a_caducar_pdf.php';
    const data = Object.fromEntries(new FormData(document.getElementById('frmFiltrosACaducar')).entries());
    const qp = new URLSearchParams();

    Object.entries(data).forEach(([k, v]) => {
      if (v !== null && v !== '') qp.append(k, v);
    });

    // Orden actual del DataTable
    const order = dt.order(); // [[idx,'asc'|'desc'], ...]
    if (order && order.length) qp.append('dt_order', JSON.stringify(order));

    const href = qp.toString() ? `${base}?${qp.toString()}` : base;
    $(this).attr('href', href);
    // dejar que <a target="_blank"> navegue normalmente
  });

  cargarCombos();
});
