/* public/page-scripts/pages/inventario/fisico_vs_registrado_scripts.js */
/* global $, Intl */

$(function () {
  const tableId = '#fisicoVsRegistradoTable';
  const $form = $('#frmFiltrosFvR');

  // ---------- Helpers ----------
  const fmtInt = (v) => {
    const n = Number(v ?? 0);
    try { return new Intl.NumberFormat('es-PY').format(n); }
    catch { return (n || 0).toString(); }
  };

  function renderTipo(t) {
    const s = String(t || '').toUpperCase();
    if (s === 'REGISTRADO_SIN_FISICO') return '<span class="badge bg-warning text-dark">Registrado sin físico</span>';
    if (s === 'FISICO_SIN_REGISTRO')  return '<span class="badge bg-danger">Físico sin registro</span>';
    return '<span class="badge bg-secondary">—</span>';
  }

  // ---------- Cargar combos (clientes / operativas) ----------
  function cargarCombos() {
    // Clientes
    $.getJSON('/api/inventario/fisico_vs_registrado.php?meta=clientes')
      .done((res) => {
        const $c = $('#fCliente');
        if (res && Array.isArray(res.clientes)) {
          res.clientes.forEach((r) => $c.append(new Option(`${r.razon_social} (ID ${r.id})`, r.id)));
        }
      });

    // Operativas
    $.getJSON('/api/inventario/fisico_vs_registrado.php?meta=operativas')
      .done((res) => {
        const $o = $('#fOperativa');
        if (res && Array.isArray(res.operativas)) {
          res.operativas.forEach((r) => $o.append(new Option(`${r.nombre} (ID ${r.id})`, r.id)));
        }
      });
  }

  // ---------- DataTable ----------
  const dt = $(tableId).DataTable({
    processing: true,
    serverSide: true,
    searching: false,
    lengthChange: true,
    pageLength: 25,
    ajax: {
      url: '/api/inventario/fisico_vs_registrado.php',
      type: 'GET',
      data: function (d) {
        // payload filtros → backend
        const params = Object.fromEntries(new FormData($form[0]).entries());
        return Object.assign({}, d, params, { action: 'list' });
      },
      dataSrc: function (json) {
        return json.data || [];
      }
    },
    columns: [
      { data: 'tipo',             title: 'Tipo', render: (d)=> renderTipo(d) },
      { data: 'cliente',          title: 'Cliente' },
      { data: 'operativa',        title: 'Operativa' },
      { data: 'pallet_codigo',    title: 'Pallet' },
      { data: 'ubicacion',        title: 'Ubicación' },
      { data: 'items_count',      title: 'Ítems',        className: 'text-end', render: (d)=> fmtInt(d) },
      { data: 'unidades',         title: 'Unidades',     className: 'text-end', render: (d)=> fmtInt(d) },
      { data: 'productos_distintos', title: 'Productos', className: 'text-end', render: (d)=> fmtInt(d) },
      { data: 'observacion',      title: 'Observación' },
    ],
    order: [[ 0, 'asc' ], [ 3, 'asc' ]], // Tipo, Pallet
    language: { url: 'https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json' },

    // Totales en footer (página actual)
    footerCallback: function () {
      const api = this.api();
      const sumCol = (idx) =>
        api.column(idx, { page: 'current' }).data()
          .reduce((a, b) => (Number(a) || 0) + (Number(b) || 0), 0);

      const cols = {
        items: 5,
        unidades: 6,
        productos: 7
      };

      $(api.column(cols.items    ).footer()).html(fmtInt(sumCol(cols.items)));
      $(api.column(cols.unidades ).footer()).html(fmtInt(sumCol(cols.unidades)));
      $(api.column(cols.productos).footer()).html(fmtInt(sumCol(cols.productos)));
    }
  });

  // Filtros → recargar
  $form.on('submit', function (e) {
    e.preventDefault();
    dt.ajax.reload();
  });

  // ---------- Botón PDF: filtros + orden actual ----------
  $('#btnPdfFisicoVsRegistrado').on('click', function () {
    const base = '/api/inventario/fisico_vs_registrado_pdf.php';
    const data = Object.fromEntries(new FormData(document.getElementById('frmFiltrosFvR')).entries());
    const qp = new URLSearchParams();

    Object.entries(data).forEach(([k, v]) => {
      if (v !== null && v !== '') qp.append(k, v);
    });

    // Orden actual del DataTable
    const order = dt.order(); // [[idx,'asc'|'desc'], ...]
    if (order && order.length) qp.append('dt_order', JSON.stringify(order));

    const href = qp.toString() ? `${base}?${qp.toString()}` : base;
    $(this).attr('href', href);
  });

  cargarCombos();
});
