/* public/page-scripts/pages/inventario/ubicacion_scripts.js */
/* global $, Intl */

$(function () {
  const tableId = "#ubicacionTable";
  const $form = $("#frmFiltrosUbicacion");

  // ---------- Helpers ----------
  const fmtInt = (v) => {
    const n = Number(v ?? 0);
    try {
      return new Intl.NumberFormat("es-PY").format(n);
    } catch {
      return (n || 0).toString();
    }
  };

  function renderEstadoPos(v) {
    const t = String(v || "").toLowerCase();
    if (t === "ocupada") return '<span class="badge bg-success">Ocupada</span>';
    if (t === "libre") return '<span class="badge bg-secondary">Libre</span>';
    return `<span class="badge bg-light text-dark">${v ?? "-"}</span>`;
  }

  function solEnsureFooterCells(dt, tableSelector) {
    const $tf = $(tableSelector + " tfoot");
    if ($tf.find("th, td").length === 0) {
      const cols = dt.columns().count();
      const cells = Array.from({ length: cols }, () => "<th></th>").join("");
      $tf.html("<tr>" + cells + "</tr>");
    }
  }

  // ---------- Cargar combos (clientes / operativas) ----------
  function cargarCombos() {
    // Clientes
    $.getJSON("/api/inventario/ubicacion.php?meta=clientes").done((res) => {
      const $c = $("#fCliente");
      if (res && Array.isArray(res.clientes)) {
        res.clientes.forEach((r) =>
          $c.append(new Option(`${r.razon_social} (ID ${r.id})`, r.id))
        );
      }
    });

    // Operativas
    $.getJSON("/api/inventario/ubicacion.php?meta=operativas").done((res) => {
      const $o = $("#fOperativa");
      if (res && Array.isArray(res.operativas)) {
        res.operativas.forEach((r) =>
          $o.append(new Option(`${r.nombre} (ID ${r.id})`, r.id))
        );
      }
    });
  }

  // ---------- DataTable ----------
  const dt = $(tableId).DataTable({
    processing: true,
    serverSide: true,
    searching: false,
    lengthChange: true,
    pageLength: 25,
    ajax: {
      url: "/api/inventario/ubicacion.php",
      type: "GET",
      data: function (d) {
        // filtros → backend
        const params = Object.fromEntries(new FormData($form[0]).entries());
        return Object.assign({}, d, params, { action: "list" });
      },
      dataSrc: function (json) {
        return json.data || [];
      },
    },
    columns: [
      { data: "ubicacion", title: "Ubicación" }, // R1-C02-N3-F1
      { data: "rack", title: "Rack" },
      { data: "columna", title: "Columna", className: "text-end" },
      { data: "nivel", title: "Nivel", className: "text-end" },
      { data: "fondo", title: "Fondo", className: "text-end" },
      {
        data: "estado_pos",
        title: "Estado",
        render: (d) => renderEstadoPos(d),
      },
      { data: "pallet_codigo", title: "Pallet" },
      { data: "cliente", title: "Cliente" },
      { data: "operativa", title: "Operativa" },
      { data: "sku", title: "SKU" },
      { data: "denominacion", title: "Producto" },

      // Totales asociados a la posición (si ocupada)
      {
        data: "cajas",
        title: "Cajas",
        className: "text-end",
        render: (d) => fmtInt(d),
      },
      {
        data: "unidades",
        title: "Unidades",
        className: "text-end",
        render: (d) => fmtInt(d),
      },
      {
        data: "stock",
        title: "Stock",
        className: "text-end",
        render: (d) => fmtInt(d),
      },
      {
        data: "reservados",
        title: "Reservados",
        className: "text-end",
        render: (d) => fmtInt(d),
      },
      {
        data: "disponibles",
        title: "Disponibles",
        className: "text-end",
        render: (d) => fmtInt(d),
      },
    ],
    order: [
      [1, "asc"],
      [2, "asc"],
      [3, "asc"],
      [4, "asc"],
    ], // rack, columna, nivel, fondo
    language: {
      url: "https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json",
    },

    // Totales en footer (página actual)
    footerCallback: function () {
      const api = this.api();
      const sumCol = (idx) =>
        api
          .column(idx, { page: "current" })
          .data()
          .reduce((a, b) => (Number(a) || 0) + (Number(b) || 0), 0);

      // Índices numéricos: cajas(11) unidades(12) stock(13) reservados(14) disponibles(15)
      const cols = { cajas: 11, unidades: 12, stock: 13, reserv: 14, disp: 15 };
      $(api.column(cols.cajas).footer()).html(fmtInt(sumCol(cols.cajas)));
      $(api.column(cols.unidades).footer()).html(fmtInt(sumCol(cols.unidades)));
      $(api.column(cols.stock).footer()).html(fmtInt(sumCol(cols.stock)));
      $(api.column(cols.reserv).footer()).html(fmtInt(sumCol(cols.reserv)));
      $(api.column(cols.disp).footer()).html(fmtInt(sumCol(cols.disp)));
    },
  });
  
  solEnsureFooterCells(dt, tableId);
  
  // Filtros → recargar
  $form.on("submit", function (e) {
    e.preventDefault();
    dt.ajax.reload();
  });

  // ---------- Botón PDF: filtros + orden actual ----------
  $("#btnPdfUbicacion").on("click", function () {
    const base = "/api/inventario/ubicacion_pdf.php";
    const formEl = document.getElementById("frmFiltrosUbicacion");
    const data = formEl
      ? Object.fromEntries(new FormData(formEl).entries())
      : {};
    const qp = new URLSearchParams();

    Object.entries(data).forEach(([k, v]) => {
      if (v !== null && v !== "") qp.append(k, v);
    });

    // Orden actual del DataTable
    if (typeof dt?.order === "function") {
      const order = dt.order();
      if (order && order.length) qp.append("dt_order", JSON.stringify(order));
    }

    const href = qp.toString() ? `${base}?${qp.toString()}` : base;
    $(this).attr("href", href);
  });

  cargarCombos();
});
