(function(){
  // pages/operaciones/deposito_layout.js
  document.addEventListener('DOMContentLoaded', function(){
    var btnRefresh = document.getElementById('btnRefreshLayout');
    var btnExport = document.getElementById('btnExportLayoutJson');
    var form = document.getElementById('frmLayoutFilters');

    function fetchDepositos(){
      fetch('/api/parametros/depositos.php')
        .then(r=>r.json())
        .then(j=>{
          var sel = document.getElementById('fDeposito');
          if (!sel) return;
          sel.innerHTML = '';
          j.forEach(function(d){
            var opt = document.createElement('option'); opt.value = d.id; opt.textContent = d.code + ' - ' + d.nombre; sel.appendChild(opt);
          });
        }).catch(e=>console.error('fetch depositos', e));
    }

    function refreshLayout(e){
      if (e) e.preventDefault();
      var dep = document.getElementById('fDeposito').value;
      var amb = document.getElementById('fAmbiente').value;
      var msg = document.getElementById('layoutMsg');
      var grid = document.getElementById('layoutGrid');
      msg.textContent = 'Cargando...';
      grid.innerHTML = '';
      fetch('/api/operaciones/layout_get.php?deposito_id=' + encodeURIComponent(dep) + '&ambiente_id=' + encodeURIComponent(amb))
        .then(r=>r.json())
        .then(function(data){
          msg.style.display = 'none';
          grid.textContent = JSON.stringify(data, null, 2);
        }).catch(function(err){
          msg.textContent = 'Error al cargar: ' + err.message;
        });
    }

    form.addEventListener('submit', refreshLayout);
    btnRefresh.addEventListener('click', refreshLayout);
    btnExport.addEventListener('click', function(){
      var grid = document.getElementById('layoutGrid');
      if (!grid) return;
      var blob = new Blob([grid.textContent || ''], {type: 'application/json'});
      var url = URL.createObjectURL(blob);
      var a = document.createElement('a'); a.href = url; a.download = 'layout.json'; document.body.appendChild(a); a.click(); a.remove();
      URL.revokeObjectURL(url);
    });

    fetchDepositos();
  });
})();
