// DataTables + Editor: Operaciones → Móviles disponibles (tabla oper_movil_disponible)
$(document).ready(function () {
  const notify = (type, title, text) => {
    const fallback = () => {
      const message = [title, text].filter(Boolean).join(': ');
      if (message) alert(message); else alert(type || 'Aviso');
    };
    if (window.Swal && Swal.fire) {
      const cfg = { icon: type || 'info', title: title || '', confirmButtonText: 'OK' };
      if (text) {
        if (text.indexOf('\n') >= 0) {
          cfg.html = text.replace(/\n/g, '<br>');
        } else {
          cfg.text = text;
        }
      }
      Swal.fire(cfg).catch(fallback);
    } else {
      fallback();
    }
  };

  // Ensure consistent button sizing and styles for toggles and read-only pills
  (function injectToggleStyles(){
    if (document.getElementById('moviles-toggle-styles')) return;
    const css = `
      .toggle-flag, .btn-fixed { min-width: 64px; }
    `;
    const style = document.createElement('style');
    style.id = 'moviles-toggle-styles';
    style.type = 'text/css';
    style.appendChild(document.createTextNode(css));
    document.head.appendChild(style);
  })();
  const tableId = "movilesDisponiblesTable";
  const baseAjaxUrl = "/api/operaciones/moviles_disponibles_list.php";
  const $fecha = $("#filtroFecha");
  let showAll = false;
  // Default to today's date if empty
  if (!$fecha.val()) {
    const today = new Date().toISOString().slice(0, 10);
    $fecha.val(today);
  }
  const makeAjaxUrl = () => {
    const params = new URLSearchParams();
    if (!showAll) params.append('date', $fecha.val());
    if (showAll) params.append('all', '1');
    if (!showAll && !$fecha.val()) {
      const today = new Date().toISOString().slice(0, 10);
      params.set('date', today);
    }
    const query = params.toString();
    return query ? `${baseAjaxUrl}?${query}` : baseAjaxUrl;
  };

  // -------- Editor fields (oper_movil_disponible.*) --------
  const editorFields = [
    { name: "oper_movil_disponible.id", type: "hidden" },

  { label: "Fecha",         name: "oper_movil_disponible.fecha", type: "datetime", format: "YYYY-MM-DD" },
    { label: "Móvil",         name: "oper_movil_disponible.movil_id", type: "select" },
  { label: "Disponible",    name: "oper_movil_disponible.disponible", type: "checkbox", separator: "|", options: [{ label: "Sí", value: 1 }], unselectedValue: 0 },
  { label: "Llegada",       name: "oper_movil_disponible.llegada_time", type: "datetime", format: "HH:mm" },
  { label: "Asistió",       name: "oper_movil_disponible.no_asistio", type: "checkbox", separator: "|", options: [{ label: "Sí", value: 1 }], unselectedValue: 0 },
  { label: "Utilizado",     name: "oper_movil_disponible.no_utilizado", type: "checkbox", separator: "|", options: [{ label: "Sí", value: 1 }], unselectedValue: 0 },
    { label: "Ventana ini",   name: "oper_movil_disponible.ventana_ini" },
    { label: "Ventana fin",   name: "oper_movil_disponible.ventana_fin" },
    { label: "Notas",         name: "oper_movil_disponible.notas" },

    // Auditoría (readonly/hidden)
    { name: "oper_movil_disponible.created_at", type: "hidden" },
    { name: "oper_movil_disponible.updated_at", type: "hidden" }
  ];

  // -------- Columnas DataTable --------
  const columns = [
    {
      data: null,
      defaultContent: "",
      className: "select-checkbox",
      orderable: false,
      searchable: false,
      title: "",
      width: "20px"
    },

    { data: 'para_moviles.chapa', title: 'Móvil', editField: 'oper_movil_disponible.movil_id' },
    { data: 'para_transportadoras.nombre', title: 'Transportadora' },
    { data: 'oper_movil_disponible.disponible', title: 'Disponible', render: function(v){
        const on = (String(v)==='1' || v===1 || v===true);
        return `<span class="btn btn-sm btn-fixed ${on ? 'btn-success' : 'btn-danger'}">${on ? 'Sí' : 'No'}</span>`;
      }
    },
    { data: 'oper_movil_disponible.llegada_time', title: 'Llegada' },
    { data: 'oper_movil_disponible.no_asistio', title: 'Asistió', render: function(v){
        const on = (String(v)==='1' || v===1 || v===true);
        return `<span class="btn btn-sm btn-fixed ${on ? 'btn-success' : 'btn-danger'}">${on ? 'Sí' : 'No'}</span>`;
      }
    },
    { data: 'oper_movil_disponible.no_utilizado', title: 'Utilizado', render: function(v){
        const on = (String(v)==='1' || v===1 || v===true);
        return `<span class="btn btn-sm btn-fixed ${on ? 'btn-success' : 'btn-danger'}">${on ? 'Sí' : 'No'}</span>`;
      }
    },
    { data: 'oper_movil_disponible.ventana_ini', title: 'Ventana ini' },
    { data: 'oper_movil_disponible.ventana_fin', title: 'Ventana fin' },
    { data: 'oper_movil_disponible.notas', title: 'Notas' }
  ];

  // --- THEAD dinámico si falta ---
  const $table = $("#" + tableId);
  if ($table.find("thead").length === 0) {
    let thead = "<thead><tr>";
    columns.forEach(col => thead += `<th>${col.title ? col.title : ""}</th>`);
    thead += "</tr></thead>";
    $table.prepend(thead);
  }

  // --- Inicializar DataTable base (tu helper) ---
  const { editor, tableInstance } = initializeBaseDataTable({
    tableId,
    ajaxUrl: makeAjaxUrl(),
    editorFields,
    columns,
    buttons: ["create", "edit", "remove", "excel", "csv", "pdf"],
    select: { style: "os", selector: "td.select-checkbox" },
    order: [[1, "asc"]], // Móvil asc (primera columna después del checkbox)
    pageLength: -1, // Mostrar todos los registros
    ordering: false // Deshabilitar reordenamiento al hacer click
  });

  // Botón aplicar filtro → recargar (usando API DataTables directamente)
  $(document).on('click', '#btnAplicarFiltro', function(){
    showAll = false;
    try {
      $('#' + tableId).DataTable().ajax.url(makeAjaxUrl()).load();
    } catch (e) {
      console.error('Error al recargar tabla:', e);
    }
  });

  // Botón ver todos → cargar listado completo
  $(document).on('click', '#btnVerTodos', function(){
    showAll = true;
    try {
      $('#' + tableId).DataTable().ajax.url(makeAjaxUrl()).load();
    } catch (e) {
      console.error('Error al recargar tabla:', e);
    }
  });

  $(document).on('click', '#btnSeedMoviles', function(){
    const $btn = $(this);
    const fechaVal = ($fecha.val() || new Date().toISOString().slice(0, 10));
    const run = () => {
      const payload = { fecha: fechaVal };
      showAll = false;
      $fecha.val(fechaVal);
      $btn.prop('disabled', true);
      $.ajax({
        url: '/api/operaciones/moviles_disponibles_seed.php',
        method: 'POST',
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        data: JSON.stringify(payload)
      }).done(function(resp){
        if (resp && resp.ok) {
          const data = resp.data || {};
          const inserted = parseInt(data.inserted, 10) || 0;
          const total = parseInt(data.candidatos, 10) || 0;
          const existing = parseInt(data.ya_existentes, 10) || 0;
          const summary = `Insertados: ${inserted}\nDisponibles en catálogo: ${total}\nYa existentes: ${existing}`;
          notify('success', 'Catálogo cargado', summary);
          try {
            const dt = $('#' + tableId).DataTable();
            dt.ajax.url(makeAjaxUrl()).load(function(){
              dt.page.len(-1).draw(false);
            }, false);
          } catch (err) {
            console.error('Error al recargar tabla tras seed:', err);
          }
        } else {
          const message = resp && resp.error ? resp.error : 'No se pudo cargar el catálogo';
          notify('error', 'Error', message);
        }
      }).fail(function(jq){
        const message = jq && jq.responseJSON && jq.responseJSON.error ? jq.responseJSON.error : (jq.responseText || jq.statusText || 'Error desconocido');
        notify('error', 'Error', message);
      }).always(function(){
        $btn.prop('disabled', false);
      });
    };

    if (window.Swal && Swal.fire) {
      Swal.fire({
        icon: 'question',
        title: 'Generar catálogo diario',
        text: `Se insertarán los móviles disponibles del catálogo para la fecha ${fechaVal} y quedarán como "No disponibles". ¿Continuar?`,
        showCancelButton: true,
        confirmButtonText: 'Sí, cargar',
        cancelButtonText: 'Cancelar',
        reverseButtons: true
      }).then(function(result){
        if (result.isConfirmed) run();
      });
    } else if (window.confirm(`Insertar móviles disponibles del catálogo para ${fechaVal}?`)) {
      run();
    }
  });

  // En crear, predefinir la fecha con el filtro actual
  if (editor && typeof editor.on === 'function') {
    editor.on('open', function(){
      try {
        if (editor.mode && editor.mode() === 'create') {
          editor.field('oper_movil_disponible.fecha').set($fecha.val());
        }

        // Botón "Ahora" para Llegada (HH:mm)
        const $fldLlegada = $(editor.field('oper_movil_disponible.llegada_time').node());
        if ($fldLlegada.find('.btn-now-llegada').length === 0) {
          const $grp = $('<div class="mt-1"></div>');
          const $btnNow = $('<button type="button" class="btn btn-sm btn-outline-secondary btn-now-llegada">Ahora</button>');
          $btnNow.on('click', function(){
            const d = new Date();
            const hh = String(d.getHours()).padStart(2,'0');
            const mm = String(d.getMinutes()).padStart(2,'0');
            editor.field('oper_movil_disponible.llegada_time').set(`${hh}:${mm}`);
          });
          $grp.append($btnNow);
          $fldLlegada.append($grp);
        }

        // UI toggle buttons for flags
        const makeToggle = function(fieldName){
          const $wrap = $(editor.field(fieldName).node());
          // Limpia instancias previas
          $wrap.find('.toggle-flag, .toggle-container').remove();
          // Ocultar controles nativos dentro del contenedor del campo
          $wrap.children().hide();

          const getVal = () => editor.field(fieldName).val();
          const setVal = (v) => editor.field(fieldName).set(v);
          const $btn = $('<button type="button" class="btn btn-sm toggle-flag"></button>');
          const render = () => {
            const v = getVal();
            const on = (String(v)==='1' || v===1 || v===true);
            $btn.removeClass('btn-success btn-danger')
                .addClass(on ? 'btn-success' : 'btn-danger')
                .text(on ? 'Sí' : 'No');
          };
          // Click: alternar Sí/No
          $btn.on('click', function(){
            const v = getVal();
            const on = (String(v)==='1' || v===1 || v===true);
            setVal(on ? 0 : 1);
            render();
            afterToggle(fieldName);
          });
          render();
          const $host = $('<div class="mt-1 toggle-container"></div>').append($btn);
          $wrap.append($host);
        };

        // After toggle hook (e.g., disable llegada if no_asistio)
        const afterToggle = function(fieldName){
          if (fieldName === 'oper_movil_disponible.no_asistio') syncLlegadaDisabled();
        };

        // Deshabilitar llegada si "Asistió" está en No (inverted logic)
        const syncLlegadaDisabled = function(){
          const v = editor.field('oper_movil_disponible.no_asistio').val();
          const asistio = (String(v) === '1' || v === 1 || v === true);
          const $input = $(editor.field('oper_movil_disponible.llegada_time').node()).find('input');
          if (!asistio) { // Si NO asistió, deshabilitar llegada
            editor.field('oper_movil_disponible.llegada_time').set('');
            $input.prop('disabled', true);
          } else {
            $input.prop('disabled', false);
          }
        };

        // Create toggles
        makeToggle('oper_movil_disponible.no_asistio');
        makeToggle('oper_movil_disponible.no_utilizado');
        syncLlegadaDisabled();
      } catch (_) {}
    });
  }

  // Botón PDF → abrir reporte con la misma fecha
  $(document).on('click', '#btnPdfMoviles', function(){
    const url = `/api/operaciones/moviles_disponibles_pdf.php?date=${encodeURIComponent($fecha.val())}`;
    window.open(url, '_blank');
  });

  // (Sin FKs extra: options ya vienen del endpoint Editor)
});
