// DataTables + Editor: Parámetros → Clases (tabla para_clases)
$(document).ready(function () {
  const tableId = "clasesTable";
  const ajaxUrl = "/api/parametros/clases.php";

  // -------- Editor fields (para_clases.*) --------
  const editorFields = [
    { name: "para_clases.id", type: "hidden" },

    { label: "Nombre",       name: "para_clases.nombre" },
    { label: "Descripción",  name: "para_clases.descripcion" },

    { 
      label: "Activo", 
      name: "para_clases.activo",
      type: "checkbox",
      separator: "|",
      options: [{ label: "Sí", value: 1 }]
    },

    // Auditoría (readonly/hidden)
    { name: "para_clases.created_at", type: "hidden" },
    { name: "para_clases.updated_at", type: "hidden" },
    { name: "para_clases.deleted_at", type: "hidden" },
    { name: "para_clases.created_by", type: "hidden" },
    { name: "para_clases.updated_by", type: "hidden" },
    { name: "para_clases.deleted_by", type: "hidden" },
  ];

  // -------- Columnas DataTable --------
  const columns = [
    {
      data: null,
      defaultContent: "",
      className: "select-checkbox",
      orderable: false,
      searchable: false,
      title: "",
      width: "20px"
    },

    { data: "para_clases.nombre",      title: "Nombre" },
    { data: "para_clases.descripcion", title: "Descripción" },

    {
      data: "para_clases.activo",
      title: "Estado",
      className: "text-center",
      width: "110px",
      render: function (val) {
        const on = String(val) === "1";
        return on
          ? '<span class="badge bg-success">Activo</span>'
          : '<span class="badge bg-secondary">Inactivo</span>';
      }
    },

    // Fechas (ocultas por defecto)
    { data: "para_clases.created_at", title: "Creado",      visible: false },
    { data: "para_clases.updated_at", title: "Actualizado", visible: false },
  ];

  // --- THEAD dinámico si falta ---
  const $table = $("#" + tableId);
  if ($table.find("thead").length === 0) {
    let thead = "<thead><tr>";
    columns.forEach(col => thead += `<th>${col.title ? col.title : ""}</th>`);
    thead += "</tr></thead>";
    $table.prepend(thead);
  }

  // --- Inicializar DataTable base (tu helper) ---
  const { editor, tableInstance } = initializeBaseDataTable({
    tableId,
    ajaxUrl,
    editorFields,
    columns,
    buttons: ["create", "edit", "remove", "excel", "csv", "pdf"],
    select: { style: "os", selector: "td.select-checkbox" },
    order: [[1, "asc"]] // Nombre asc
  });

  // (Sin FKs -> no hace falta cargar options)
});
