// public/page-scripts/pages/parametros/clientes_scripts.js
// DataTables + Editor: Parámetros → Clientes (tabla para_clientes)

$(document).ready(function () {
  const tableId = "clientesTable";
  const ajaxUrl = "/api/parametros/clientes.php";

  // -------- Editor fields (para_clientes.*) --------
  const editorFields = [
    { name: "para_clientes.id", type: "hidden" },

    { label: "Razón social", name: "para_clientes.razon_social" },
    { label: "RUC",          name: "para_clientes.ruc" },

    { 
      label: "Activo", 
      name: "para_clientes.activo",  
      type: "checkbox", 
      separator: "|", 
      options: [{ label: "Sí", value: 1 }]
    },

    // Auditoría (readonly/hidden)
    { name: "para_clientes.created_at", type: "hidden" },
    { name: "para_clientes.updated_at", type: "hidden" },
    { name: "para_clientes.deleted_at", type: "hidden" },
    { name: "para_clientes.created_by", type: "hidden" },
    { name: "para_clientes.updated_by", type: "hidden" },
    { name: "para_clientes.deleted_by", type: "hidden" },
  ];

  // -------- Columnas DataTable --------
  const columns = [
    // Selector (si usas select-checkbox)
    {
      data: null,
      defaultContent: "",
      className: "select-checkbox",
      orderable: false,
      searchable: false,
      title: "",
      width: "20px"
    },

    // Datos
    { data: "para_clientes.razon_social", title: "Razón social" },
    { data: "para_clientes.ruc",          title: "RUC" },

    {
      data: "para_clientes.activo",
      title: "Estado",
      className: "text-center",
      width: "110px",
      render: function (val) {
        const on = String(val) === "1";
        return on
          ? '<span class="badge bg-success">Activo</span>'
          : '<span class="badge bg-secondary">Inactivo</span>';
      }
    },

    // Fechas (ocultas por defecto)
    { data: "para_clientes.created_at", title: "Creado",     visible: false },
    { data: "para_clientes.updated_at", title: "Actualizado", visible: false },
  ];

  // --- Generar THEAD dinámico si falta ---
  const $table = $("#" + tableId);
  if ($table.find("thead").length === 0) {
    let thead = "<thead><tr>";
    columns.forEach(col => thead += `<th>${col.title ? col.title : ""}</th>`);
    thead += "</tr></thead>";
    $table.prepend(thead);
  }

  // --- Inicializar DataTable base (tu helper) ---
  const { editor, tableInstance } = initializeBaseDataTable({
    tableId,
    ajaxUrl,
    editorFields,
    columns,
    buttons: ["create", "edit", "remove", "excel", "csv", "pdf"],
    select: {
      style: "os",
      selector: "td.select-checkbox"
    },
    order: [[1, "asc"]] // Razón social asc
  });

  // (No hay FKs aquí, así que no hace falta cargar options para selects)
});
