// public/page-scripts/pages/parametros/destinatarios_scripts.js
// DataTables + Editor: Parámetros → Destinatarios (tabla para_destinatarios)

$(document).ready(function () {
  const tableId = "destinatariosTable";
  const ajaxUrl = "/api/parametros/destinatarios.php";

  // -------- Editor fields (para_destinatarios.*) --------
  const editorFields = [
    { name: "para_destinatarios.id", type: "hidden" },

    // Básicos
    { label: "Código",    name: "para_destinatarios.cod" },
    { label: "Nombre",    name: "para_destinatarios.nombre" },
    { label: "Fantasia",  name: "para_destinatarios.fantasia" },
    { label: "RUC",       name: "para_destinatarios.razon_social" },
    { label: "Teléfono",  name: "para_destinatarios.telefono" },
    { label: "Dirección", name: "para_destinatarios.direccion", type: "textarea" },

    // FKs
    { label: "Ciudad",        name: "para_destinatarios.ciudad_id", type: "select" },
    { label: "Cliente",       name: "para_destinatarios.cliente_id", type: "select" },

    // Contactos
    { label: "Contacto destinatario", name: "para_destinatarios.contacto_destinatario", type: "textarea" },
    { label: "Contacto vendedor",     name: "para_destinatarios.contacto_vendedor",     type: "textarea" },

    // Auditoría (hidden)
    { name: "para_destinatarios.created_at", type: "hidden" },
    { name: "para_destinatarios.updated_at", type: "hidden" },
    { name: "para_destinatarios.deleted_at", type: "hidden" }
  ];

  // -------- Columnas DataTable --------
  const columns = [
    {
      data: null,
      defaultContent: "",
      className: "select-checkbox",
      orderable: false,
      searchable: false,
      title: "",
      width: "20px"
    },

    { data: "para_destinatarios.cod",     title: "Código", width: "90px" },
    { data: "para_destinatarios.nombre",  title: "Nombre" },
    { data: "para_destinatarios.fantasia",title: "Fantasia" },
    { data: "para_destinatarios.razon_social",     title: "RUC", width: "110px" },
    { data: "para_destinatarios.telefono",title: "Teléfono", width: "120px" },

    // FKs (muestran label, editan id)
    {
      data: "para_ciudades.nombre",
      title: "Ciudad",
      editField: "para_destinatarios.ciudad_id"
    },
    {
      data: "para_clientes.razon_social",
      title: "Cliente",
      editField: "para_destinatarios.cliente_id"
    },

    { data: "para_destinatarios.direccion", title: "Dirección", visible: false },
    { data: "para_destinatarios.contacto_destinatario", title: "Contacto destinat.", visible: false },
    { data: "para_destinatarios.contacto_vendedor",     title: "Contacto vendedor",  visible: false },

    // Auditoría
    { data: "para_destinatarios.created_at", title: "Creado",     visible: false },
    { data: "para_destinatarios.updated_at", title: "Actualizado",visible: false }
  ];

  // --- THEAD dinámico si falta ---
  const $table = $("#" + tableId);
  if ($table.find("thead").length === 0) {
    let thead = "<thead><tr>";
    columns.forEach(col => thead += `<th>${col.title ? col.title : ""}</th>`);
    thead += "</tr></thead>";
    $table.prepend(thead);
  }

  // --- Inicializar DataTable base (tu helper global) ---
  const { editor, tableInstance } = initializeBaseDataTable({
    tableId,
    ajaxUrl,
    editorFields,
    columns,
    buttons: ["create", "edit", "remove", "excel", "csv", "pdf"],
    select: { style: "os", selector: "td.select-checkbox" },
    order: [[2, "asc"]] // Nombre
  });

  // Si tu helper no carga automáticamente las Options de los <select>, puedes luego:
  // editor.field('para_destinatarios.cliente_id').update([{label:'Acme S.A.', value:1}, ...]);
  // editor.field('para_destinatarios.ciudad_id').update([...]);
  // editor.field('para_destinatarios.tipo_id').update([...]);
});
