// DataTables + Editor: Parámetros → Grupos (tabla para_grupos)
$(document).ready(function () {
  const tableId = "gruposTable";
  const ajaxUrl = "/api/parametros/grupos.php";

  // -------- Editor fields (para_grupos.*) --------
  const editorFields = [
    { name: "para_grupos.id", type: "hidden" },

    { 
      label: "Nombre", 
      name: "para_grupos.nombre"
      // required en server; aquí podría ponerse required client-side si querés
    },
    { label: "Descripción", name: "para_grupos.descripcion" },

    { 
      label: "Activo", 
      name: "para_grupos.activo",
      type: "checkbox",
      separator: "|",
      options: [{ label: "Sí", value: 1 }]
    },

    // Auditoría (readonly/hidden)
    { name: "para_grupos.created_at", type: "hidden" },
    { name: "para_grupos.updated_at", type: "hidden" },
    { name: "para_grupos.deleted_at", type: "hidden" },
    { name: "para_grupos.created_by", type: "hidden" },
    { name: "para_grupos.updated_by", type: "hidden" },
    { name: "para_grupos.deleted_by", type: "hidden" },
  ];

  // -------- Columnas DataTable --------
  const columns = [
    {
      data: null,
      defaultContent: "",
      className: "select-checkbox",
      orderable: false,
      searchable: false,
      title: "",
      width: "20px"
    },

    { data: "para_grupos.nombre",      title: "Nombre" },
    { data: "para_grupos.descripcion", title: "Descripción" },

    {
      data: "para_grupos.activo",
      title: "Estado",
      className: "text-center",
      width: "110px",
      render: function (val) {
        const on = String(val) === "1";
        return on
          ? '<span class="badge bg-success">Activo</span>'
          : '<span class="badge bg-secondary">Inactivo</span>';
      }
    },

    // Fechas (ocultas por defecto)
    { data: "para_grupos.created_at", title: "Creado",      visible: false },
    { data: "para_grupos.updated_at", title: "Actualizado", visible: false },
  ];

  // --- THEAD dinámico si falta ---
  const $table = $("#" + tableId);
  if ($table.find("thead").length === 0) {
    let thead = "<thead><tr>";
    columns.forEach(col => thead += `<th>${col.title ? col.title : ""}</th>`);
    thead += "</tr></thead>";
    $table.prepend(thead);
  }

  // --- Inicializar DataTable base (tu helper) ---
  const { editor, tableInstance } = initializeBaseDataTable({
    tableId,
    ajaxUrl,
    editorFields,
    columns,
    buttons: ["create", "edit", "remove", "excel", "csv", "pdf"],
    select: { style: "os", selector: "td.select-checkbox" },
    order: [[1, "asc"]] // Nombre asc
  });

  // (Sin FKs -> no hace falta cargar options)
});
