// public/page-scripts/pages/parametros/moviles_scripts.js
// DataTables + Editor: Parámetros → Móviles (tabla para_moviles)

$(document).ready(function () {
  const tableId = "movilesTable";
  const ajaxUrl = "/api/parametros/moviles.php";

  // -------- Editor fields (para_moviles.*) --------
  const editorFields = [
    { name: "para_moviles.id", type: "hidden" },

    // Datos principales
    { label: "Chapa", name: "para_moviles.chapa" },
    { label: "Tipo",  name: "para_moviles.tipo_id", type: "select" },

    // Datos extra
    { label: "GPS (ID/enlace)", name: "para_moviles.gps" },
    { label: "Transportadora",  name: "para_moviles.transportadora_id", type: "select" },

    // Auditoría (hidden)
    { name: "para_moviles.created_at", type: "hidden" },
    { name: "para_moviles.updated_at", type: "hidden" },
    { name: "para_moviles.deleted_at", type: "hidden" }
  ];

  // -------- Columnas DataTable --------
  const columns = [
    {
      data: null,
      defaultContent: "",
      className: "select-checkbox",
      orderable: false,
      searchable: false,
      title: "",
      width: "20px"
    },

    { data: "para_moviles.chapa", title: "Chapa" },

    // FKs mostrando label y editando id
    {
      data: "para_movil_tipos.nombre", // ajusta si tu tabla/col difiere
      title: "Tipo",
      editField: "para_moviles.tipo_id"
    },
    {
      data: "para_transportadoras.nombre", // ajusta si tu tabla/col difiere
      title: "Transportadora",
      editField: "para_moviles.transportadora_id"
    },

    { data: "para_moviles.gps", title: "GPS", visible: false },

    // Auditoría
    { data: "para_moviles.created_at",  title: "Creado",      visible: false },
    { data: "para_moviles.updated_at",  title: "Actualizado", visible: false }
  ];

  // --- THEAD dinámico si falta ---
  const $table = $("#" + tableId);
  if ($table.find("thead").length === 0) {
    let thead = "<thead><tr>";
    columns.forEach(col => thead += `<th>${col.title ? col.title : ""}</th>`);
    thead += "</tr></thead>";
    $table.prepend(thead);
  }

  // --- Inicializar DataTable base (helper global) ---
  const { editor, tableInstance } = initializeBaseDataTable({
    tableId,
    ajaxUrl,
    editorFields,
    columns,
    buttons: ["create", "edit", "remove", "excel", "csv", "pdf"],
    select: { style: "os", selector: "td.select-checkbox" },
    order: [[1, "asc"]] // Chapa asc
  });

  // Si tu helper no carga automáticamente las options, luego puedes:
  // editor.field('para_moviles.tipo_id').update([{label:'Camión 3/4', value:1}, ...]);
  // editor.field('para_moviles.transportadora_id').update([{label:'Trans ARA', value:7}, ...]);
});
