$(document).ready(function () {
  const tableId = "productosTable";
  const ajaxUrl = "/api/parametros/productos.php";

  // -------- Editor fields (para_productos.*) --------
  const editorFields = [
    // Clave primaria (normalmente manejada por el server)
    { name: "para_productos.id", type: "hidden" },

    // Operativa / Cliente (FK)
    { label: "Operativa", name: "para_productos.operativa_id", type: "select" },
    { label: "Cliente",   name: "para_productos.cliente_id",   type: "select" },

    // Identificación básica
    { label: "SKU",           name: "para_productos.sku" },
    { label: "Denominación",  name: "para_productos.denominacion" },

    // Clasificación (FK)
    { label: "Clase",               name: "para_productos.clase_id",             type: "select" },
    { label: "Grupo",               name: "para_productos.grupo_id",             type: "select" },
    { label: "Método de rotación",  name: "para_productos.metodo_rotacion_id",   type: "select" },

    // Atributos libres
    { label: "Marca",        name: "para_productos.marca" },
    { label: "Material",     name: "para_productos.material" },
    { label: "Conservación", name: "para_productos.conservacion" },

    // Color (hex)
    { label: "Color web (HEX)", name: "para_productos.color_web" },

    // Parámetros de stock / vida útil
    { label: "Stock mínimo",           name: "para_productos.stock_min_default",    },
    { label: "Vida útil (días)",       name: "para_productos.vida_util_dias",       },
    { label: "Venc. amarillo (días)",  name: "para_productos.venc_amarillo_dias",   },
    { label: "Venc. rojo (días)",      name: "para_productos.venc_rojo_dias",       },
    { label: "Estadía amar. (días)",   name: "para_productos.estadia_amarillo_dias",  },
    { label: "Estadía rojo (días)",    name: "para_productos.estadia_rojo_dias",      },

    // Imágenes
    { label: "Img principal", name: "para_productos.img_main" },
    { label: "Img UC",        name: "para_productos.img_uc" },
    { label: "Img UV",        name: "para_productos.img_uv" },

    // Nota
    { label: "Nota",          name: "para_productos.nota", type: "textarea" },

    // Estado
    { label: "Activo",        name: "para_productos.activo",  type: "checkbox", separator: "|", options: [{ label: "Sí", value: 1 }] },

    // Auditoría (normalmente readonly/hidden en UI)
    { name: "para_productos.created_at", type: "hidden" },
    { name: "para_productos.updated_at", type: "hidden" },
    { name: "para_productos.deleted_at", type: "hidden" },
    { name: "para_productos.created_by", type: "hidden" },
    { name: "para_productos.updated_by", type: "hidden" },
    { name: "para_productos.deleted_by", type: "hidden" },
  ];

  // -------- Columnas DataTable --------
  const columns = [
    // Selector (si usas select-checkbox; quítalo si no)
    {
      data: null,
      defaultContent: '',
      className: 'select-checkbox',
      orderable: false,
      searchable: false
    },

    // { data: "para_productos.id",           title: "ID", width: "80px" },
    { data: "para_productos.sku",          title: "SKU" },
    { data: "para_productos.denominacion", title: "Denominación" },

    // FKs con display desde tablas relacionadas (ajusta el alias si tu API difiere)
    {
      data: "sys_operativas.nombre",
      title: "Operativa",
      editField: "para_productos.operativa_id"
    },
    {
      data: "para_clientes.razon_social",
      title: "Cliente",
      editField: "para_productos.cliente_id"
    },
    {
      data: "para_clases.nombre",
      title: "Clase",
      editField: "para_productos.clase_id"
    },
    {
      data: "para_grupos.nombre",
      title: "Grupo",
      editField: "para_productos.grupo_id"
    },
    {
      data: "para_metodos_rotacion.nombre",
      title: "Rotación",
      editField: "para_productos.metodo_rotacion_id"
    },

    { data: "para_productos.marca",        title: "Marca" },
    { data: "para_productos.material",     title: "Material" },
    { data: "para_productos.conservacion", title: "Conservación" },

    {
      data: "para_productos.color_web",
      title: "Color",
      render: function (hex) {
        if (!hex) return "";
        const safe = String(hex).replace(/[^0-9a-fA-F]/g, "").slice(0, 6);
        return `
          <span class="d-inline-flex align-items-center gap-2">
            <span style="display:inline-block;width:14px;height:14px;border-radius:3px;border:1px solid #ccc;background:#${safe}"></span>
            <code>#${safe.toUpperCase()}</code>
          </span>`;
      }
    },

    { data: "para_productos.stock_min_default",   title: "Stock mín.", className: "text-end" },
    { data: "para_productos.vida_util_dias",      title: "Vida útil",  className: "text-end" },
    { data: "para_productos.venc_amarillo_dias",  title: "Venc. Amar.", className: "text-end" },
    { data: "para_productos.venc_rojo_dias",      title: "Venc. Rojo",  className: "text-end" },
    { data: "para_productos.estadia_amarillo_dias", title: "Estadía Amar.", className: "text-end" },
    { data: "para_productos.estadia_rojo_dias",     title: "Estadía Rojo",  className: "text-end" },

    // Imágenes (muestra URL cruda; puedes mejorar con thumbnail si deseas)
    { data: "para_productos.img_main", title: "Img principal", visible: false },
    { data: "para_productos.img_uc",   title: "Img UC",        visible: false },
    { data: "para_productos.img_uv",   title: "Img UV",        visible: false },

    // Nota (puede ser larga; oculto por defecto)
    { data: "para_productos.nota",     title: "Nota", visible: false },

    {
      data: "para_productos.activo",
      title: "Estado",
      render: function (val) {
        const on = String(val) === "1";
        return on
          ? '<span class="badge bg-success">Activo</span>'
          : '<span class="badge bg-secondary">Inactivo</span>';
      },
      className: "text-center", width: "100px"
    },

    // Fechas (readonly en tabla)
    { data: "para_productos.created_at", title: "Creado",   visible: false },
    { data: "para_productos.updated_at", title: "Actualizado", visible: false },
  ];

  // --- Generar THEAD dinámico si falta ---
  const table = $("#" + tableId);
  if (table.find("thead").length === 0) {
    let thead = "<thead><tr>";
    columns.forEach(col => thead += `<th>${col.title ? col.title : ""}</th>`);
    thead += "</tr></thead>";
    table.prepend(thead);
  }

  // --- Inicializar DataTable base (tu helper) ---
  const { editor, tableInstance } = initializeBaseDataTable({
    tableId,
    ajaxUrl,
    editorFields,
    columns,
    // Ajusta botones según necesites
    buttons: ["create", "edit", "remove", "excel", "csv", "pdf"],
    // Si usas selección por checkbox:
    select: {
      style: "os",
      selector: "td.select-checkbox"
    },
    // Orden inicial sugerido
    order: [[1, "desc"]]    
  });

  // (Opcional) Cargar opciones para select2 de FKs si tu helper no lo hace automáticamente:
  // editor.field('para_productos.cliente_id').update( /* [{label, value}, ...] */ );
  // ...
});
