// public/page-scripts/pages/parametros/transportadoras_scripts.js
// DataTables + Editor: Parámetros → Transportadoras (tabla para_transportadoras)

$(document).ready(function () {
  const tableId = "transportadorasTable";
  const ajaxUrl = "/api/parametros/transportadoras.php";

  // -------- Editor fields --------
  const editorFields = [
    { name: "para_transportadoras.id", type: "hidden" },
    { label: "Nombre", name: "para_transportadoras.nombre" },

    // Auditoría (hidden)
    { name: "para_transportadoras.created_at", type: "hidden" },
    { name: "para_transportadoras.updated_at", type: "hidden" },
    { name: "para_transportadoras.deleted_at", type: "hidden" }
  ];

  // -------- Columnas --------
  const columns = [
    {
      data: null,
      defaultContent: "",
      className: "select-checkbox",
      orderable: false,
      searchable: false,
      title: "",
      width: "20px"
    },

    { data: "para_transportadoras.nombre", title: "Nombre" },

    // Auditoría
    { data: "para_transportadoras.created_at",  title: "Creado",      visible: false },
    { data: "para_transportadoras.updated_at",  title: "Actualizado", visible: false }
  ];

  // --- THEAD dinámico si falta ---
  const $table = $("#" + tableId);
  if ($table.find("thead").length === 0) {
    let thead = "<thead><tr>";
    columns.forEach(col => thead += `<th>${col.title ? col.title : ""}</th>`);
    thead += "</tr></thead>";
    $table.prepend(thead);
  }

  // --- Inicializar DataTable base ---
  const { editor, tableInstance } = initializeBaseDataTable({
    tableId,
    ajaxUrl,
    editorFields,
    columns,
    buttons: ["create", "edit", "remove", "excel", "csv", "pdf"],
    select: { style: "os", selector: "td.select-checkbox" },
    order: [[1, "asc"]]
  });
});
