// Recepción · Productos recibidos por cliente
(function(window, $) {
  'use strict';

  // Base URL
  const baseUrl = document.querySelector('meta[name="base-url"]')?.getAttribute('content') || 
                 (typeof window.BASE_URL !== 'undefined' ? window.BASE_URL : '/');

  function joinUrl(path) {
    return baseUrl.replace(/\/$/, '') + '/' + path.replace(/^\//, '');
  }

  // Cargar opciones en un select desde API
  function loadSelect($select, url) {
    $.getJSON(url, function(response) {
      if (response.ok && response.data) {
        response.data.forEach(function(item) {
          $select.append($('<option>', { value: item.id, text: item.text }));
        });
      }
    }).fail(function() {
      console.warn('Error cargando opciones para', $select.attr('id'));
    });
  }

  $(function () {
    const $form = $("#frmRecProv");
    const n0 = (v) => new Intl.NumberFormat('es-PY').format(Number(v || 0));
    const n2 = (v) => new Intl.NumberFormat('es-PY', { maximumFractionDigits: 2 }).format(Number(v || 0));

  const dt = $("#recProvTable").DataTable({
    ajax: {
      url: joinUrl("api/recepcion/por_proveedor.php"),
      data: d => Object.assign(d, Object.fromEntries(new FormData($form[0]).entries())),
      dataSrc: "data",
    },
    order: [[6, "desc"]],  // Ordenar por última recepción DESC (más recientes primero)
    columns: [
      { data: "cliente",     title: "Cliente" },
      { data: "sku",         title: "SKU" },
      { data: "denominacion",title: "Producto" },
      { data: "ing_uc",      title: "Unidades recibidas", className: "text-end", render: n0 },
      { data: "ing_cajas",   title: "Cajas recibidas",    className: "text-end", render: n0 },
      { data: "docs",        title: "Docs",               className: "text-end", render: n0 },
      { data: "ultimo_in",   title: "Última recepción",   render: d => d || "—" },
    ],
    footerCallback: function (row, data) {
      const sum = (k) => data.reduce((a, r) => a + (Number(r[k]) || 0), 0);
      const api = this.api();
      $(api.column(0).footer()).html("Totales");
      $(api.column(3).footer()).html(n0(sum("ing_uc")));
      $(api.column(4).footer()).html(n0(sum("ing_cajas")));
      $(api.column(5).footer()).html(n0(sum("docs")));
    },
    language: { url: "https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json" },
  });

    $form.on("submit", function (e) { e.preventDefault(); dt.ajax.reload(); });

    // Botón limpiar filtros
    $("#btnLimpiarFiltros").on("click", function() {
      $form[0].reset();
      dt.ajax.reload();
    });

    // Cargar combos
    loadSelect($("#fCliente"),   joinUrl("api/parametros/clientes_combo.php"));
    loadSelect($("#fOperativa"), joinUrl("api/parametros/operativas_combo.php"));
  });

})(window, jQuery);
