$(function () {
  const $form = $("#frmVencer");

  const colorClass = (c) => {
    switch ((c || '').toUpperCase()) {
      case 'NEGRO':    return 'bg-dark text-white';
      case 'ROJO':     return 'bg-danger text-white';
      case 'AMARILLO': return 'bg-warning text-dark';
      case 'VERDE':    return 'bg-success text-white';
      default:         return 'bg-secondary-subtle text-body';
    }
  };

  const rowStripeClass = (c) => {
    switch ((c || '').toUpperCase()) {
      case 'NEGRO':    return 'row-flag-dark';
      case 'ROJO':     return 'row-flag-danger';
      case 'AMARILLO': return 'row-flag-warning';
      case 'VERDE':    return 'row-flag-success';
      default:         return '';
    }
  };

  const dt = $("#vencerTable").DataTable({
    ajax: {
      url: joinUrl("api/reportes/productos_por_vencer.php"),
      data: d => Object.assign(d, Object.fromEntries(new FormData($form[0]).entries())),
      dataSrc: "data",
    },
    order: [["vence_en_dias","asc"]],
    columns: [
      { data: "cliente",      title: "Cliente" },
      { data: "operativa",    title: "Operativa" },
      { data: "sku",          title: "SKU" },
      { data: "denominacion", title: "Producto" },
      { data: "lote",         title: "Lote" },
      { data: "fecha_venc",   title: "Vence", render: d => d || "-" },
      {
        data: null, title: "Días", className: "text-end",
        render: (row) => {
          const n = row.vence_en_dias;
          const cc = colorClass(row.color);
          const txt = (n === null || n === undefined) ? '-' : new Intl.NumberFormat('es-PY').format(n);
          return `<span class="badge ${cc} fw-semibold">${txt}</span>`;
        }
      },
      { data: "uc_total",     title: "Unidades", className: "text-end",
        render: d => new Intl.NumberFormat('es-PY').format(d || 0) },
      { data: "bucket",       title: "Bucket" },
    ],
    createdRow: function (row, data) {
      const cls = rowStripeClass(data.color);
      if (cls) $(row).addClass(cls);
    },
    footerCallback: function (row, data) {
      const api = this.api();
      const sum = data.reduce((acc, r) => acc + (r.uc_total || 0), 0);
      $(api.column(0).footer()).html("Totales");
      $(api.column(7).footer()).html(new Intl.NumberFormat('es-PY').format(sum));
    },
    language: { url: "https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json" },
  });

  $form.on("submit", function (e) { e.preventDefault(); dt.ajax.reload(); });
});
