function renderLayoutParaFecha(fecha) {
  const depositoLayout = window.depositoLayout || {};
  const depositoSeleccionado = $("#deposito").val();
  const posicionesContadas = window.posicionesPorFecha[fecha] || [];
  const colores = window.coloresPorFecha[fecha] || {};
  const contenedor = document.getElementById("contenedor-layout");

  if (!depositoSeleccionado || !depositoLayout[depositoSeleccionado]) {
    contenedor.innerHTML = `<div class="text-center text-muted py-5">Seleccioná un depósito para ver el layout</div>`;
    return;
  }

  let html = `<div class="text-center mb-3"><strong>Fecha de conteo: ${fecha}</strong></div>`;
  for (const nombreRack in depositoLayout[depositoSeleccionado]) {
    html += `<div class="mb-2"><div class="row-24">`;
    const columnas = depositoLayout[depositoSeleccionado][nombreRack];
    for (const nombreColumna in columnas) {
      html += `<div class="col-24 columna text-center">`;
      const niveles = columnas[nombreColumna];
      for (const nombreNivel in niveles) {
        html += `<div class="nivel"><div class="titulo-seccion mb-2">${nombreRack} <br> ${nombreColumna} - ${nombreNivel}</div>`;
        const fondos = niveles[nombreNivel];
        for (let idx = 0; idx < fondos.length; idx++) {
          // Si guardaste solo el número de fondo, cámbialo a .id si lo necesitas
          // Si guardaste objetos, ajusta esto
          const posicionId = fondos[idx]; 
          const esContado = posicionesContadas.includes(posicionId);
          const color = esContado ? (colores[posicionId] ? "#" + colores[posicionId] : "#7ccf97") : "#f9f9f9";
          const clase = "cuadro-posicion" + (esContado ? " contado" : "");
          html += `<div class="${clase}" 
                    style="background-color: ${color}" 
                    data-posicion-id="${posicionId}"
                    >${idx + 1}</div>`;
        }
        html += `</div>`; // nivel
      }
      html += `</div>`; // columna
    }
    html += `</div></div>`; // row-24 + mb-2
  }
  contenedor.innerHTML = html;

  // Vuelve a asignar el click a los cubos
  $(".cuadro-posicion").on("click", function () {
    cuboSeleccionado = $(this);
    // Aquí deberías poner el código para abrir el modal y cargar los datos como antes...
    // ...
  });
}
