let fechas = window.fechasDisponibles || [];

// Al cargar la página: lee el modo de localStorage (o usa "producto" por defecto)
window.modoColoreo = localStorage.getItem("modoColoreo") || "producto";

// Función para activar el botón correcto
function actualizarBotonColoreoActivo() {
  $(
    "#btnColorearProducto, #btnColorearGrupo, #btnColorearVencimiento"
  ).removeClass("active");
  if (window.modoColoreo === "producto") {
    $("#btnColorearProducto").addClass("active");
  } else if (window.modoColoreo === "grupo") {
    $("#btnColorearGrupo").addClass("active");
  } else if (window.modoColoreo === "vencimiento") {
    $("#btnColorearVencimiento").addClass("active");
  }
}

// Evento de botones
$("#btnColorearProducto").on("click", function () {
  window.modoColoreo = "producto";
  localStorage.setItem("modoColoreo", "producto");
  renderLayoutParaFecha($("#fechaConteo1").val());
  actualizarBotonColoreoActivo();
});
$("#btnColorearGrupo").on("click", function () {
  window.modoColoreo = "grupo";
  localStorage.setItem("modoColoreo", "grupo");
  renderLayoutParaFecha($("#fechaConteo1").val());
  actualizarBotonColoreoActivo();
});
$("#btnColorearVencimiento").on("click", function () {
  window.modoColoreo = "vencimiento";
  localStorage.setItem("modoColoreo", "vencimiento");
  renderLayoutParaFecha($("#fechaConteo1").val());
  actualizarBotonColoreoActivo();
});

// Al cargar la página, activa el botón correcto
actualizarBotonColoreoActivo();

if (!Array.isArray(fechas) || fechas.length === 0) {
  // No hay fechas, no inicies carrusel
  document.getElementById("contenedor-layout").innerHTML =
    "<div class='text-center text-muted'>No hay fechas disponibles para mostrar.</div>";
} else {
  let idx = 0;
  renderLayoutParaFecha(fechas[idx]);
  // function siguienteFechaCarrusel() {
  //   renderLayoutParaFecha(fechas[idx]);
  //   idx = (idx + 1) % fechas.length;
  // }
  // siguienteFechaCarrusel();
  // setInterval(siguienteFechaCarrusel, 3000);
}

let cuboSeleccionado = null;

$(document).ready(function () {
  $("#deposito").on("change", function () {
    $("#formVerLayout").submit();
  });
  $("#fechaConteo1").on("change", function () {
    $("#formVerLayout").submit();
  });
  $("#fechaConteo2").on("change", function () {
    $("#formVerLayout").submit();
  });
});

function renderLayoutParaFecha(fecha) {
  const depositoLayout = window.depositoLayout || {};
  const depositoSeleccionado = $("#deposito").val();
  const posicionesContadas = window.posicionesPorFecha[fecha] || [];
  const colores = window.coloresPorFecha[fecha] || {};
  const contenedor = document.getElementById("contenedor-layout");

  if (!depositoSeleccionado || !depositoLayout[depositoSeleccionado]) {
    contenedor.innerHTML = `<div class="text-center text-muted py-5">Seleccioná un depósito para ver el layout</div>`;
    return;
  }

  let html = "";

  // RECORRER LADOS
  for (const lado in depositoLayout[depositoSeleccionado]) {
    html += `<div class="mb-4"><div class="fs-4 mb-2" style="color:teal;">LADO: ${lado}</div>`;

    // RECORRER NIVELES (en cada lado)
    for (const nivel in depositoLayout[depositoSeleccionado][lado]) {
      const racksObj = depositoLayout[depositoSeleccionado][lado][nivel];
      // Todas las columnas de todos los racks para saber cuántas hay máximo por rack
      let maxFondos = 0;
      let racks = Object.keys(racksObj).sort();

      // Consigue la lista completa de columnas por rack
      let rackCols = {}; // rack => [col1, col2, ...]
      racks.forEach((rack) => {
        rackCols[rack] = Object.keys(racksObj[rack]).sort();
        rackCols[rack].forEach((col) => {
          if (racksObj[rack][col].length > maxFondos) {
            maxFondos = racksObj[rack][col].length;
          }
        });
      });

      // --- Cabecera: Primera fila (nombre rack) ---
      html += `<table class="mb-3" style="border-collapse:separate; border-spacing: 6px 2px"><thead><tr>`;
      html += `<td class="nivel-label text-end align-middle" style="min-width: 50px; font-weight: bold; color: #287573;">Nivel</td>`;
      racks.forEach((rack) => {
        let colSpan = rackCols[rack].length;
        html += `<th class="text-center" colspan="${colSpan}" style="border:none; font-size:18px;">${rack}</th>`;
      });
      html += `</tr>`;

      // --- Cabecera: Segunda fila (nombre columna, ej: *A, *B...) ---
      html += `<tr>`;
      html += `<td class="nivel-label text-ce align-middle" style="min-width: 50px; font-weight: bold; color: #287573;">${nivel}</td>`;
      racks.forEach((rack) => {
        rackCols[rack].forEach((col) => {
          html += `<th class="text-center small" style="border:none; color:#b36c2d;">${col}</th>`;
        });
      });
      html += `</tr>`;
      html += `</thead><tbody>`;

      // --- Cuerpo: por cada fila de fondo ---
      for (let idx = 0; idx < maxFondos; idx++) {
        html += `<tr>`;
        // Columna a la izquierda: el número/nombre de nivel
        html += `<td class="nivel-label text-end align-middle" style="min-width: 50px; font-weight: bold; color: #287573;"></td>`;
        racks.forEach((rack, rackIdx) => {
          rackCols[rack].forEach((col, colIdx) => {
            let fondosArr = racksObj[rack][col] || [];
            let fondoObj = fondosArr[idx];

            // Detectar las esquinas
            let isFirstRow = idx === 0;
            let isLastRow = idx === maxFondos - 1;
            let isFirstCol = colIdx === 0;
            let isLastCol = colIdx === rackCols[rack].length - 1;

            let celdaClass = [];
            if (isFirstRow && isFirstCol)
              celdaClass.push("celda-esquina-superior-izq");
            if (isFirstRow && isLastCol)
              celdaClass.push("celda-esquina-superior-der");
            if (isLastRow && isFirstCol)
              celdaClass.push("celda-esquina-inferior-izq");
            if (isLastRow && isLastCol)
              celdaClass.push("celda-esquina-inferior-der");

            // Línea vertical antes del primer col de cada rack (excepto primer rack)
            if (colIdx === 0 && rackIdx > 0)
              celdaClass.push("celda-primera-col-rack");

            // Línea vertical después del último col de cada rack (opcional, si quieres ver doble separación entre racks)
            if (colIdx === rackCols[rack].length - 1)
              celdaClass.push("celda-ultima-col-rack");

            if (fondoObj) {
              const posicionId = fondoObj.id;
              const esContado = posicionesContadas.includes(posicionId);
              let color = "#fff";
              if (esContado) {
                if (window.modoColoreo === "grupo" && fondoObj.grupo) {
                  const colorGrupo = window.coloresPorGrupo?.[fondoObj.grupo];
                  color = colorGrupo ? colorGrupo : "#7ccf97";
                } else if (
                  window.modoColoreo === "producto" &&
                  fondoObj.color_web
                ) {
                  color = fondoObj.color_web.startsWith("#")
                    ? fondoObj.color_web
                    : "#" + fondoObj.color_web;
                } else if (
                  window.modoColoreo === "vencimiento" &&
                  fondoObj.estado_vencimiento
                ) {
                  color =
                    window.coloresVencimiento?.[fondoObj.estado_vencimiento] ||
                    "#7ccf97";
                } else {
                  color = "#7ccf97";
                }
              }
              const clase = "cuadro-posicion" + (esContado ? " contado" : "");
              html += `<td>
        <div 
          class="${clase} d-inline-block text-center ${celdaClass.join(" ")}"
          style="width:44px;min-width:44px; margin:2px; border:1px solid #bbb; background:${color}; cursor:pointer;"
          data-posicion-id="${fondoObj.id}"
          data-rack="${rack}"
          data-columna="${col}"
          data-nivel="${nivel}"
          data-fondo="${fondoObj.fondo}">
          ${fondoObj.fondo}
        </div>
      </td>`;
            } else {
              html += `<td></td>`;
            }
          });
        });
        html += `</tr>`;
      }

      html += `</tbody></table>`;
    }
    html += `</div>`; // cierre de lado
  }

  contenedor.innerHTML = html;

  // Clicks
  $(".cuadro-posicion").on("click", function () {
    cuboSeleccionado = $(this);
    // ... tu código de modal aquí
  });
}

$(document).on("click", ".cuadro-posicion", function () {
  const posicionId = $(this).data("posicion-id");
  if (!posicionId) return; // Protege por si no hay data

  // Mostrar modal y spinner
  $("#cuadroData").html("");
  $("#cuadroLoading").show();
  const modalEl = document.getElementById("modalCuadroInfo");
  let modal;
  if (bootstrap.Modal.getInstance(modalEl)) {
    modal = bootstrap.Modal.getInstance(modalEl);
  } else {
    modal = new bootstrap.Modal(modalEl);
  }
  modal.show();

  let fecha = document.getElementById("fechaConteo1").value;

  // Pedir datos por AJAX
  $.ajax({
    url: "../../backend/reportes/obtener_pallet.php",
    method: "POST",
    dataType: "json",
    data: { posicion_id: posicionId, fecha: fecha },
    success: function (response) {
      $("#cuadroLoading").hide();
      if (response.existe && response.datos) {
        console.log("Datos del pallet:", response.datos);
        let html = `
                    <ul class="list-group text-start">
                      <li class="list-group-item py-2">
                        <div class="row align-items-center">
                          <div class="col-12 col-sm-5 fw-bold">Nº Pallet:</div>
                          <div class="col-12 col-sm-7">${
                            response.datos.id || "-"
                          }</div>
                        </div>
                      </li>
                      <li class="list-group-item py-2">
                        <div class="row align-items-center">
                          <div class="col-12 col-sm-5 fw-bold">Código:</div>
                          <div class="col-12 col-sm-7">${
                            response.datos.cod || "-"
                          }</div>
                        </div>
                      </li>
                      <li class="list-group-item py-2">
                        <div class="row align-items-center">
                          <div class="col-12 col-sm-5 fw-bold">Denominación:</div>
                          <div class="col-12 col-sm-7">${
                            response.datos.denominacion || ""
                          }</div>
                        </div>
                      </li>
                      <li class="list-group-item py-2">
                        <div class="row align-items-center">
                          <div class="col-12 col-sm-5 fw-bold">Lote:</div>
                          <div class="col-12 col-sm-7">${
                            response.datos.lote || "-"
                          }</div>
                        </div>
                      </li>
                      <li class="list-group-item py-2">
                        <div class="row align-items-center">
                          <div class="col-12 col-sm-5 fw-bold">Vencimiento:</div>
                          <div class="col-12 col-sm-7">${
                            response.datos.vencimiento || "-"
                          }</div>
                        </div>
                      </li>
                      <li class="list-group-item py-2">
                        <div class="row align-items-center">
                          <div class="col-12 col-sm-5 fw-bold">Cantidad:</div>
                          <div class="col-12 col-sm-7">${
                            response.datos.cantidad || "-"
                          }</div>
                        </div>
                      </li>
                      <li class="list-group-item py-2">
                        <div class="row align-items-center">
                          <div class="col-12 col-sm-5 fw-bold">Observaciones:</div>
                          <div class="col-12 col-sm-7">${
                            response.datos.observacion || ""
                          }</div>
                        </div>
                      </li>
                    </ul>
                  `;

        $("#cuadroData").html(html);
      } else {
        $("#cuadroData").html(
          `<div class="alert alert-secondary">No hay datos para esta posición.</div>`
        );
      }
    },
    error: function () {
      $("#cuadroLoading").hide();
      $("#cuadroData").html(
        `<div class="alert alert-danger">Error al consultar datos.</div>`
      );
    },
  });
});
