$(document).on('click', '#imprimirBtn', function(e) {
  e.preventDefault();
  let deposito = $("#deposito").val();
  let fecha = $("#fechaConteo").val();

  let url = `../Impresiones/capacidad_olp_caphsa.php?deposito=${encodeURIComponent(deposito)}&fecha=${encodeURIComponent(fecha)}`;

  window.open(url, '_blank');
});
function cargarReporte() {
  let deposito = $("#deposito").val();
  let fecha = $("#fechaConteo").val();
  console.log("Cargando reporte para depósito:", deposito, "y fecha:", fecha);
  if (!deposito || !fecha) {
    $("#contenedor").html(
      "<div class='alert alert-info'>Seleccione depósito y fecha.</div>"
    );
    return;
  }
  $.post(
    "../../backend/reportes/backendReporteResumenDpto.php",
    {
      deposito: deposito,
      fecha: fecha,
    },
    function (data) {
      let r = {};
      try {
        r = JSON.parse(data);
      } catch (e) {
        $("#contenedor").html(
          "<div class='alert alert-danger'>Error en respuesta.</div>"
        );
        return;
      }
      let html = `
                <div class="card shadow-lg rounded-4 border-0 bg-white mb-4">
                    <div class="card-header border-0 bg-primary text-white rounded-top-4 text-center py-4">
                        <h2 class="mb-0 fw-bold fs-3">Resumen de Ocupación: Depósito ${deposito}</h2>
                        <div class="fs-6 mt-2"><b>Fecha:</b> ${fecha}</div>
                    </div>
                    <div class="card-body py-4">
                        <div class="row mb-4">
                            <div class="col-md-4">
                                <h4 class="mt-2 mb-3">Detalle por Código de Producto</h4>
                                <table class="table table-bordered table-sm mt-2">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Código</th>
                                            <th class="text-end">Cantidad</th>
                                        </tr>
                                    </thead>
                                    <tbody>`;
      if (r.detalle && r.detalle.length) {
        r.detalle.forEach(function (row) {
          html += `<tr><td>${row.cod}</td><td class="text-end">${row.cantidad}</td></tr>`;
        });
      } else {
        html += `<tr><td colspan="2" class="text-center text-muted">No hay datos</td></tr>`;
      }
      html += `
                                    </tbody>
                                </table>
                                <div class="d-flex gap-2 mt-3">
                                    <button class="btn btn-outline-success btn-sm" onclick="exportarExcel()"><i class="bi bi-file-earmark-excel"></i> Excel</button>
                                    <button class="btn btn-outline-danger btn-sm" onclick="exportarPDF()"><i class="bi bi-file-earmark-pdf"></i> PDF</button>
                                    <button class="btn btn-outline-primary btn-sm" id="imprimirBtn">
                                      <i class="bi bi-printer"></i> Imprimir
                                    </button>
                                </div>
                            </div>
                            <div class="col-md-8 d-flex flex-column align-items-center justify-content-center">
                                <div class="row w-100">
                                    <div class="col-md-6 mb-4">
                                        <canvas id="graficoOcupacion"></canvas>
                                    </div>
                                    <div class="col-md-6 mb-4">
                                        <canvas id="graficoDetalle"></canvas>
                                    </div>
                                </div>
                                <div class="row w-100 mt-2">
                                    <div class="col-4 text-center">
                                        <div class="fs-4 fw-bold">${
                                          r.total ?? 0
                                        }</div>
                                        <div class="text-muted">Total de posiciones</div>
                                    </div>
                                    <div class="col-4 text-center">
                                        <div class="fs-4 fw-bold text-success">${
                                          r.ocupadas ?? 0
                                        }</div>
                                        <div class="text-muted">Ocupadas</div>
                                        <div class="small text-success">${
                                          r.porcentaje_ocupadas ?? 0
                                        }%</div>
                                    </div>
                                    <div class="col-4 text-center">
                                        <div class="fs-4 fw-bold text-danger">${
                                          r.vacias ?? 0
                                        }</div>
                                        <div class="text-muted">Vacías</div>
                                        <div class="small text-danger">${
                                          r.porcentaje_vacias ?? 0
                                        }%</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>`;

      $("#contenedor").html(html);
      renderGraficosReporte(r);
    }
  );
}

// Auto-carga al cambiar select o fecha
$("#deposito, #fechaConteo").on("change", cargarReporte);

// Cargar al iniciar si ambos están seteados
$(document).ready(cargarReporte);

function renderGraficosReporte(r) {
  // -------- Gráfico de Ocupación --------
  const ctxOcupacion = document
    .getElementById("graficoOcupacion")
    .getContext("2d");
  new Chart(ctxOcupacion, {
    type: "doughnut",
    data: {
      labels: ["Ocupadas", "Vacías"],
      datasets: [
        {
          data: [r.ocupadas ?? 0, r.vacias ?? 0],
          backgroundColor: ["#198754", "#dc3545"],
        },
      ],
    },
    options: {
      plugins: {
        title: {
          display: true,
          text: "Ocupación de Posiciones",
          font: {
            size: 16,
          },
        },
        legend: {
          display: true,
        },
      },
    },
  });

  // -------- Gráfico Detalle por Código --------
  const topCodigos = (r.detalle || [])
    .sort((a, b) => b.cantidad - a.cantidad)
    .slice(0, 5);

  const ctxDetalle = document.getElementById("graficoDetalle").getContext("2d");
  new Chart(ctxDetalle, {
    type: "doughnut",
    data: {
      labels: topCodigos.map((row) => row.cod),
      datasets: [
        {
          data: topCodigos.map((row) => row.cantidad),
          backgroundColor: [
            "#0d6efd",
            "#6610f2",
            "#20c997",
            "#ffc107",
            "#fd7e14",
          ],
        },
      ],
    },
    options: {
      plugins: {
        title: {
          display: true,
          text: "Top 5 Códigos de Producto",
          font: {
            size: 16,
          },
        },
        legend: {
          display: true,
        },
      },
    },
  });
}
