$(document).ready(function () {
  // Configuración específica para la tabla "clientes"
  const tableId = "resumenOFTable";
  // const ajaxUrl = "../../backend/reportes/resumenOF/editor.php";

  const ajaxUrl = {
    url: "../../backend/reportes/resumenOF/editor.php",
    type: "POST",
    data: function (d) {
      d.desde = $("#fechaDesde").val();
      d.hasta = $("#fechaHasta").val();
    },
  };

  // Programador del futuro...
  // Si quieres pasar variables extras dinámicamente:
  // Simplemente pásalas así:
  // const ajaxUrl = {
  //    url: "...php",
  //    type: "POST",
  //    data: function(d) { d.desde = desde; d.hasta = hasta; d.otro = ... }
  // }
  // O incluso como objeto plano: data: { desde: "...", hasta: "..." }

  const columns = [
    {
      data: "oflete.id",
      title: "N° de Orden BMSA",
      render: function (data, type, row) {
        return String(data).padStart(6, "0");
      },
    },
    { data: "oflete.ofletecl", title: "N° de Oflete Cliente" },
    { data: "clientes.nombre_cliente", title: "Cliente" },
    { data: "nombreTarifas.nombre", title: "Tipo de tarifa" },
    { data: "oflete.fechacarga", title: "Fecha de Carga" },
    { data: "oflete.inicial", title: "Inicio de Carga" },
    { data: "oflete.final", title: "Término de Carga" },
    {
      data: "oflete.final",
      title: "Demora en el tiempo de carga",
      render: function (data, type, row) {
        let hIni = row.oflete.inicial || "00:00:00";
        let hFin = row.oflete.final || "00:00:00";

        // Si es vacío o null, muestra vacío
        if (!hIni || !hFin) return "";

        // Parsear "HH:mm:ss" a minutos totales
        function timeToMinutes(str) {
          let [h, m, s] = str.split(":").map(Number);
          return h * 60 + m + (s >= 30 ? 1 : 0); // Redondea si hay más de 30 segundos
        }

        let min1 = timeToMinutes(hIni);
        let min2 = timeToMinutes(hFin);

        let diferencia = min2 - min1;
        if (diferencia < 0) diferencia += 24 * 60; // Si pasó la medianoche

        let horas = Math.floor(diferencia / 60);
        let minutos = diferencia % 60;

        // Si ambos son igual, o negativo raro, pone 0
        if (isNaN(horas) || isNaN(minutos) || diferencia < 0) return "";

        return `${horas}h ${minutos}m`;
      },
      className: "text-center bg-warning text-dark",
    },

    { data: "oflete.salida", title: "Fecha de Salida reparto" },
    { data: "oflete.ayudantes", title: "Ayudantes" },
    { data: "destinos.nombre_destino", title: "Destino" },
    {
      data: "oflete.estado",
      title: "Estado",
      render: function (data, type, row) {
        // Mapea el valor a su nombre
        const estados = {
          0: "Inicio",
          1: "Completado",
          2: "Facturado",
          3: "Cerrado",
        };
        return estados[data] !== undefined ? estados[data] : data;
      },
      className: "text-center",
    },
    { data: "oflete.obs", title: "Observación" },
    { data: "moviles.chapa", title: "Chapa" },
    { data: "tipomovil.tipomovil", title: "Tipo de móvil" },
    { data: "tipomovil.tara", title: "Capacidad del móvil peso" },
    { data: "tipomovil.m3", title: "Capacidad del móvil volumen" },
    { data: "offacturas.cpallets", title: "Pallets transportados" },
    {
      data: "transportistas.nombretrans",
      title: "Transportista",
      render: function (data, type, row) {
        return typeof data === "string" ? data.toUpperCase() : data;
      },
    },
    {
      data: "conductores.conductorNombre",
      title: "Conductor",
      render: function (data, type, row) {
        return typeof data === "string" ? data.toUpperCase() : data;
      },
    },
    { data: "offacturas.items", title: "Items" },
    {
      data: null,
      title: "Suma Venta",
      render: function (data, type, row) {
        // Usá la notación de objetos para acceder a los datos anidados
        let suma =
          (parseFloat(row.offacturas?.vbruta) || 0) +
          (parseFloat(row.offacturas?.vbruta5) || 0) +
          (parseFloat(row.offacturas?.vbruta10) || 0);
        return suma.toLocaleString("es-PY", { minimumFractionDigits: 0 });
      },
    },
    { data: "offacturas.kneto", title: "Kg Neto" },
    { data: "offacturas.volneto", title: "Volumen Neto" },
    { data: "oflete.montotarifa", title: "Costo Flete" },
    { data: "offacturas.nfacturacl", title: "Factura" },
  ];

  const rowGroup = {
    dataSrc: "oflete.id",
    startRender: function (rows, group) {
      // Ajusta los nombres de campo según tu dataset real:
      let ordenBmsa = String(group).padStart(10, "0");
      let sumaItems = rows
        .data()
        .pluck("offacturas.items")
        .reduce((a, b) => Number(a) + Number(b), 0);

      let facturas = rows
        .data()
        .pluck("offacturas.nfacturacl")
        .toArray()
        .filter((v, i, a) => a.indexOf(v) === i);
      let cantFacturas = facturas.length;

      let sumaKneto = rows
        .data()
        .pluck("offacturas.kneto")
        .reduce((a, b) => Number(a) + Number(b), 0);

      // Ajusta el colspan al número real de columnas de tu tabla
      const colspan = rows.columns().count(); // o pon un número fijo: 25, etc.

      return $("<tr/>")
        .addClass("group-row")
        .append(
          $("<td/>")
            .attr("colspan", 8)
            .html(
              `<span style="font-weight:bold">
          Orden BMSA: ${ordenBmsa}
        </span>`
            ),
          $("<td/>")
            .attr("colspan", colspan - 8)
            .html(
              `<span style="font-weight:bold">
          Total Items: ${sumaItems} | Facturas: ${cantFacturas} | Kg Neto: ${sumaKneto.toLocaleString(
                "es-PY",
                { minimumFractionDigits: 0 }
              )}
        </span>`
            )
        );
    },
  };

  const { editor, table } = initializeBaseDataTable({
    tableId,
    ajaxUrl,
    columns,
    rowGroup, // solo si quieres agrupación
  });

  // Recargar DataTable al enviar el filtro
  $("#formFiltroFechas").on("submit", function (e) {
    e.preventDefault();
    table.ajax.reload();
  });
});
