// Rotación · Productos con mayor y menor movimiento
$(function () {
  const $form = $("#frmRotacion");
  const $top  = $("#fTop");
  const $sent = $("#fSentido");

  // Paleta semáforo para NETO: negativo rojo, positivo verde, cero gris
  const netBadge = (n) => {
    const val = Number(n || 0);
    const cls = val < 0 ? "bg-danger text-white"
             : val > 0 ? "bg-success text-white"
             : "bg-secondary-subtle text-body";
    const txt = new Intl.NumberFormat('es-PY').format(val);
    return `<span class="badge ${cls} fw-semibold">${txt}</span>`;
  };

  const nfmt = (v) => new Intl.NumberFormat('es-PY').format(v || 0);

  const dt = $("#rotacionMinMaxTable").DataTable({
    ajax: {
      url: joinUrl("api/rotacion/minmax.php"),
      data: function (d) {
        const p = Object.fromEntries(new FormData($form[0]).entries());
        return Object.assign(d, p);
      },
      dataSrc: "data",
    },
    order: [["mov_net", "desc"]],
    columns: [
      { data: "cliente",      title: "Cliente" },
      { data: "operativa",    title: "Operativa" },
      { data: "sku",          title: "SKU" },
      { data: "denominacion", title: "Producto" },
      { data: "mov_in",       title: "IN (uc)", className: "text-end", render: nfmt },
      { data: "mov_out",      title: "OUT (uc)", className: "text-end", render: nfmt },
      { data: "mov_net",      title: "NETO (uc)", className: "text-end",
        render: (_, __, row) => netBadge(row.mov_net) },
      { data: "mov_ops",      title: "Operaciones", className: "text-end", render: nfmt },
      { data: "ultimo_mov",   title: "Último mov.", render: d => d || "-" },
    ],
    footerCallback: function (row, data) {
      const sum = (key) => data.reduce((a, r) => a + (Number(r[key]) || 0), 0);
      const api = this.api();
      $(api.column(0).footer()).html("Totales");
      $(api.column(4).footer()).html(nfmt(sum("mov_in")));
      $(api.column(5).footer()).html(nfmt(sum("mov_out")));
      $(api.column(6).footer()).html(netBadge(sum("mov_net")));
      $(api.column(7).footer()).html(nfmt(sum("mov_ops")));
    },
    language: { url: "https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json" },
  });

  $form.on("submit", function (e) { e.preventDefault(); dt.ajax.reload(); });

  // Botones rápidos
  $("#btnTopPos").on("click", function () {
    $sent.val("mayor"); $top.val(20); dt.ajax.reload();
  });
  $("#btnTopNeg").on("click", function () {
    $sent.val("menor"); $top.val(20); dt.ajax.reload();
  });
  $("#btnTodos").on("click", function () {
    $sent.val("todos"); $top.val(""); dt.ajax.reload();
  });
});
