// Rotación · Permanencia promedio en almacén
$(function () {
  const $form = $("#frmPermanencia");
  const nfmt = (v) => new Intl.NumberFormat('es-PY', { maximumFractionDigits: 2 }).format(v ?? 0);

  const dt = $("#permanenciaTable").DataTable({
    ajax: {
      url: joinUrl("api/rotacion/permanencia.php"),
      data: d => Object.assign(d, Object.fromEntries(new FormData($form[0]).entries())),
      dataSrc: "data",
    },
    order: [["prom_dias", "desc"]],
    columns: [
      { data: "cliente",      title: "Cliente" },
      { data: "operativa",    title: "Operativa" },
      { data: "sku",          title: "SKU" },
      { data: "denominacion", title: "Producto" },
      { data: "items",        title: "Items cerrados", className: "text-end", render: v => nfmt(v) },
      { data: "prom_dias",    title: "Prom. días", className: "text-end", render: v => nfmt(v) },
      { data: "min_dias",     title: "Mín. días", className: "text-end", render: v => nfmt(v) },
      { data: "max_dias",     title: "Máx. días", className: "text-end", render: v => nfmt(v) },
      { data: "ultimo_out",   title: "Último OUT", render: d => d || "-" },
    ],
    footerCallback: function (row, data) {
      const api = this.api();
      const sum = (k) => data.reduce((a, r) => a + (Number(r[k]) || 0), 0);
      const avg = (k) => data.length ? sum(k) / data.length : 0;

      $(api.column(0).footer()).html("Totales / Promedios");
      $(api.column(4).footer()).html(nfmt(sum("items")));
      $(api.column(5).footer()).html(nfmt(avg("prom_dias")));
      $(api.column(6).footer()).html(nfmt(Math.min(...data.map(r => Number(r.min_dias ?? Infinity))))); // aprox
      $(api.column(7).footer()).html(nfmt(Math.max(...data.map(r => Number(r.max_dias ?? 0)))));
    },
    language: { url: "https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json" },
  });

  $form.on("submit", function (e) { e.preventDefault(); dt.ajax.reload(); });
});
