$(function(){
  const BASE = typeof window !== 'undefined' && window.BASE_URL ? window.BASE_URL : '/';
  const joinUrl = (p) => (BASE.endsWith('/') ? BASE : BASE + '/') + p.replace(/^\/+/,'');
  const $root = $('#embRoot');
  if (!$root.length) return;
  const embId = parseInt($root.attr('data-emb-id'), 10) || 0;

  // UI refs
  const $estado = $('#embEstado');
  const $codigo = $('#embCodigo');
  const $depo = $('#embDeposito');
  const $movil = $('#embMovil');
  const $chofer = $('#embChofer');
  const $btnRetroEstado = $('#btnRetroEstado');
  const $btnFinalize = $('#btnMarcarFinalizado');
  const $movilRO = $('#embMovilRO');
  const $choferRO = $('#embChoferRO');
  const $llegada = $('#embLlegada');
  const $cargaIni = $('#embCargaInicio');
  const $cargaFin = $('#embCargaFin');
  const $salida = $('#embSalida');
  const $tickPort = $('#embTicketPorteria');
  const $tickBas = $('#embTicketBascula');
  const $temp = $('#embTempSalida');
  const $ayud = $('#embAyudantes');
  const $km = $('#embKmInicial');
  const $obs = $('#embObs');
  const $tbl = $('#tblEmbPres tbody');
  const $segTbl = $('#tblSeguimientoDest');
  const $segTBody = $('#tblSeguimientoDest tbody');
  const $cardSeguimiento = $('#cardSeguimientoDestWrap');
  let segDT = null;
  let seguimientoCardVisible = false;
  const DEV_MOTIVOS = [
    { value: '', label: '-- Seleccione motivo --' },
    { value: 'Motivo 1', label: 'Motivo 1' },
    { value: 'Motivo 2', label: 'Motivo 2' },
    { value: 'Motivo 3', label: 'Motivo 3' }
  ];
  const $devTable = $('#tblDevoluciones tbody');
  const $devEmpty = $('#devEmpty');
  const $btnDevAdd = $('#btnDevAddRow');
  const $devCard = $('#cardDevoluciones');
  const $devFacturasWrap = $('#devFacturasWrap');
  const $devFacturasList = $('#devFacturasList');
  const $devTotalCell = $('#devTotalUnidades');
  const $devTotalPickingCell = $('#devTotalPicking');
  const $rendTable = $('#tblRendiciones tbody');
  const $rendEmpty = $('#rendEmpty');
  const $btnRendAdd = $('#btnRendAddRow');
  const $rendCard = $('#cardRendiciones');
  const $rendFacturasWrap = $('#rendFacturasWrap');
  const $rendFacturasList = $('#rendFacturasList');
  const $facturasDatalist = $('#embarqueFacturasDatalist');
  // PRE asociado vs lista
  const $cardPreAsoc = $('#cardPreAsociado');
  const $cardPreLista = $('#cardPreLista');
  const $preCode = $('#preCode');
  const $prePedido = $('#prePedido');
  const $preEstado = $('#preEstado');
  const $preDocLink = $('#preDocLink');
  let currentPreId = null;
  let ancillaryLocked = false;
  let ancillaryFullyFinalized = false;
  let embEstadoCode = '';
  let embPrevEstadoCode = '';
  let ancillaryAllowWhileLocked = false;
  let invoiceCatalog = [];
  let invoiceMap = new Map();
  let devConversionMap = new Map();
  const devConversionPending = new Map();
  const DEV_NUMBER_LOCALE = 'es-AR';

  function optFmtHHMM(val){
    const raw = String(val == null ? '' : val).trim();
    if (!raw) return '';
    if (/^\d{1,2}:\d{2}$/.test(raw)) return raw;
    if (/^\d{1,2}:\d{2}:\d{2}$/.test(raw)) return raw.substring(0,5);
    return raw;
  }

  function buildMovilLabel(item){
    if (!item || typeof item !== 'object') return '';
    const base = String(item.chapa).trim();
    if (base) return base;
    if (item.id) return '#' + item.id;
    return '';
  }

  function notify(icon, title, text){
    if (window.Swal && Swal.fire) return Swal.fire({icon,title,text,confirmButtonText:'OK'});
    alert((title?title+': ':'')+(text||''));
  }

  function confirmSwal(options){
    const cfg = Object.assign({
      title: 'Confirmar',
      text: '¿Continuar?',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: 'Sí',
      cancelButtonText: 'Cancelar',
      reverseButtons: true
    }, options || {});
    if (window.Swal && Swal.fire) {
      return Swal.fire(cfg).then(function(result){ return !!result.isConfirmed; });
    }
    const fallbackMsg = cfg.text || cfg.title || '¿Continuar?';
    return Promise.resolve(window.confirm(fallbackMsg));
  }

  function normInvoiceKey(val){
    return String(val == null ? '' : val).trim().toUpperCase();
  }

  function computeInvoiceMap(list){
    invoiceMap = new Map();
    (Array.isArray(list) ? list : []).forEach(function(item){
      const candidate = (item && typeof item === 'object')
        ? (item.value ?? item.factura ?? item.doc_numero ?? item.label ?? '')
        : item;
      const value = String(candidate ?? '').trim();
      if (!value) return;
      const key = normInvoiceKey(value);
      if (!invoiceMap.has(key)) {
        const meta = Object.assign({}, (item && typeof item === 'object') ? item : {}, { key, value });
        if (!meta.label || !meta.label.trim()) meta.label = value;
        if (!meta.factura) meta.factura = value;
        invoiceMap.set(key, meta);
      }
    });
  }

  function normalizeInvoiceItems(meta){
    const rawItems = (meta && typeof meta === 'object' && Array.isArray(meta.items)) ? meta.items : [];
    const seen = new Set();
    const output = [];
    rawItems.forEach(function(item){
      if (!item || typeof item !== 'object') return;
      const sku = item.sku != null ? String(item.sku).trim() : '';
      if (!sku) return;
      const skuKey = normSkuKey(sku);
      const itemId = item.item_id != null ? (parseInt(item.item_id, 10) || 0) : 0;
      const uniqueKey = itemId > 0 ? ('id:' + itemId) : (skuKey ? ('sku:' + skuKey) : null);
      if (!uniqueKey || seen.has(uniqueKey)) return;
      seen.add(uniqueKey);
      const descripcion = item.descripcion != null ? String(item.descripcion).trim() : '';
      let label = item.label != null ? String(item.label).trim() : '';
      if (!label) {
        if (sku) label = sku;
        else if (descripcion) label = descripcion;
        else if (itemId > 0) label = 'Item #' + itemId;
      }
      output.push({
        itemId: itemId > 0 ? itemId : null,
        pedidoDestId: item.pedido_dest_id != null ? (parseInt(item.pedido_dest_id, 10) || null) : null,
        productoId: item.producto_id != null ? (parseInt(item.producto_id, 10) || null) : null,
        sku: sku,
        label: label,
        descripcion: descripcion || null
      });
    });
    return output;
  }

  function setDevRowInvoiceItems($tr, items){
    if (!$tr || !$tr.length) return;
    $tr.data('invoiceItems', Array.isArray(items) ? items : []);
  }

  function applySkuToRow($tr, sku){
    if (!$tr || !$tr.length) return;
    const value = String(sku == null ? '' : sku).trim();
    const key = normSkuKey(value);
    if (!key) {
      setRowConversion($tr, null);
      updateDevRowTotalsFromInputs($tr);
      recalcDevTotals();
      return;
    }
    ensureConversionForSku(value).always(function(){
      const conv = devConversionMap.get(key) || null;
      setRowConversion($tr, conv);
      updateDevRowTotalsFromInputs($tr);
      recalcDevTotals();
    });
  }

  function updateDevRowSkuControl($tr, items, preferredSku){
    if (!$tr || !$tr.length) return;
    const $cell = $tr.find('td[data-role="sku-cell"]');
    if (!$cell.length) return;
    const normalizedItems = Array.isArray(items) ? items : [];
    const preferred = preferredSku != null ? String(preferredSku).trim() : '';
    let selectedSku = preferred;
    if (normalizedItems.length > 0) {
      const found = normalizedItems.find(function(item){
        return item && normSkuKey(item.sku) === normSkuKey(preferred);
      });
      if (!found) {
        const first = normalizedItems.find(function(item){ return item && item.sku; });
        selectedSku = first && first.sku ? String(first.sku).trim() : '';
      }
    }
    let $control;
    if (normalizedItems.length > 0) {
      $control = $('<select class="form-select form-select-sm" data-field="sku"></select>');
      normalizedItems.forEach(function(item){
        if (!item) return;
        const skuVal = item.sku != null ? String(item.sku).trim() : '';
        if (!skuVal) return;
        const labelText = item.label != null && String(item.label).trim() !== '' ? String(item.label).trim() : skuVal;
        const $opt = $('<option>').val(skuVal).text(labelText);
        if (normSkuKey(skuVal) === normSkuKey(selectedSku)) {
          $opt.prop('selected', true);
        }
        $control.append($opt);
      });
      if (!$control.children().length) {
        $control = $('<input type="text" class="form-control form-control-sm" data-field="sku" placeholder="SKU">');
        if (selectedSku) $control.val(selectedSku);
      } else if (!$control.val()) {
        const firstItem = normalizedItems.find(function(item){ return item && item.sku; });
        if (firstItem && firstItem.sku) {
          $control.val(firstItem.sku);
        }
      }
      if ($control.is('select') && $control.children().length <= 1) {
        $control.prop('disabled', true);
      }
    } else {
      $control = $('<input type="text" class="form-control form-control-sm" data-field="sku" placeholder="SKU">');
      if (selectedSku) $control.val(selectedSku);
    }
    $cell.empty().append($control);
    applySkuToRow($tr, $control.val());
  }

  function applyDevInvoiceMetaToRow($tr, meta, preferredSku){
    if (!$tr || !$tr.length) return;
    const items = normalizeInvoiceItems(meta);
    setDevRowInvoiceItems($tr, items);
    let targetSku = preferredSku != null ? String(preferredSku).trim() : '';
    if (!targetSku) {
      const $current = $tr.find('[data-field="sku"]');
      if ($current.length) {
        targetSku = String($current.val() || '').trim();
      }
    }
    updateDevRowSkuControl($tr, items, targetSku);
  }

  function normSkuKey(val){
    return String(val == null ? '' : val).trim().toUpperCase();
  }

  function normalizeConversionEntry(entry){
    const base = (entry && typeof entry === 'object') ? entry : {};
    const unitsPerCase = base.unidades_por_caja != null && !Number.isNaN(Number(base.unidades_por_caja)) ? Number(base.unidades_por_caja) : null;
    const casesPerPallet = base.cajas_por_pallet != null && !Number.isNaN(Number(base.cajas_por_pallet)) ? Number(base.cajas_por_pallet) : null;
    let unitsPerPallet = base.unidades_por_pallet != null && !Number.isNaN(Number(base.unidades_por_pallet)) ? Number(base.unidades_por_pallet) : null;
    if (unitsPerPallet === null && unitsPerCase !== null && casesPerPallet !== null) {
      unitsPerPallet = unitsPerCase * casesPerPallet;
    }
    return {
      sku: base.sku ? String(base.sku).trim() : null,
      unidades_por_caja: unitsPerCase,
      cajas_por_pallet: casesPerPallet,
      unidades_por_pallet: unitsPerPallet,
      producto_id: base.producto_id != null ? Number(base.producto_id) : null
    };
  }

  function registerDevConversions(mapObj){
    devConversionMap = new Map();
    devConversionPending.clear();
    if (!mapObj || typeof mapObj !== 'object') return;
    Object.keys(mapObj).forEach(function(key){
      const conv = normalizeConversionEntry(mapObj[key]);
      const skuKey = normSkuKey(conv.sku || key);
      if (skuKey) {
        devConversionMap.set(skuKey, conv);
      }
    });
  }

  function upsertDevConversion(entry){
    const conv = normalizeConversionEntry(entry);
    const skuKey = normSkuKey(conv.sku);
    if (!skuKey) return conv;
    devConversionMap.set(skuKey, conv);
    devConversionPending.delete(skuKey);
    return conv;
  }

  function setRowConversion($tr, conv){
    const normalized = conv ? normalizeConversionEntry(conv) : normalizeConversionEntry(null);
    $tr.data('unitsPerCase', normalized.unidades_por_caja);
    $tr.data('casesPerPallet', normalized.cajas_por_pallet);
    $tr.data('unitsPerPallet', normalized.unidades_por_pallet);
  }

  function getRowConversion($tr){
    return {
      unidades_por_caja: $tr.data('unitsPerCase') != null ? Number($tr.data('unitsPerCase')) : null,
      cajas_por_pallet: $tr.data('casesPerPallet') != null ? Number($tr.data('casesPerPallet')) : null,
      unidades_por_pallet: $tr.data('unitsPerPallet') != null ? Number($tr.data('unitsPerPallet')) : null
    };
  }

  function parseRowInt($tr, field){
    const raw = $tr.find('input[data-field="'+field+'"]').val();
    const num = parseInt(String(raw || '').replace(/[^0-9-]/g, ''), 10);
    return Number.isNaN(num) ? 0 : num;
  }

  function computeDevRowTotals($tr){
    const conv = getRowConversion($tr);
    const unitsPerCase = Number.isFinite(conv.unidades_por_caja) ? conv.unidades_por_caja : null;
    const casesPerPallet = Number.isFinite(conv.cajas_por_pallet) ? conv.cajas_por_pallet : null;

    const pallets = parseRowInt($tr, 'pallets');
    const cajas = parseRowInt($tr, 'cajas_sueltas');
    const unidades = parseRowInt($tr, 'unidades_sueltas');
    const danadas = parseRowInt($tr, 'unidades_danadas');
    const effectiveUnitsPerCase = (unitsPerCase !== null && unitsPerCase > 0) ? unitsPerCase : 1;
    const effectiveCasesPerPallet = (casesPerPallet !== null && casesPerPallet > 0) ? casesPerPallet : 1;

    const totalCajas = (pallets * effectiveCasesPerPallet) + cajas;
    const unitsFromCajas = totalCajas * effectiveUnitsPerCase;
    const total = unitsFromCajas + unidades + danadas;
    const picking = Math.max(0, total - danadas);

    return {
      total,
      unidadesPicking: picking
    };
  }

  function updateDevRowTotalCell($tr, total){
    const $cell = $tr.find('[data-field="total_unidades"]');
    if (!$cell.length) return;
    if (total == null || !Number.isFinite(total)) {
      $cell.text('—');
      $cell.removeAttr('data-total-raw');
      return;
    }
    const rounded = Math.round(total);
    $cell.text(rounded.toLocaleString(DEV_NUMBER_LOCALE));
    $cell.attr('data-total-raw', String(rounded));
  }

  function updateDevRowPickingCell($tr, total){
    const $cell = $tr.find('[data-field="unidades_a_picking"]');
    if (!$cell.length) return;
    if (total == null || !Number.isFinite(total)) {
      $cell.text('—');
      $cell.removeAttr('data-picking-raw');
      return;
    }
    const rounded = Math.max(0, Math.round(total));
    $cell.text(rounded.toLocaleString(DEV_NUMBER_LOCALE));
    $cell.attr('data-picking-raw', String(rounded));
  }

  function updateDevRowTotalsFromInputs($tr){
    const totals = computeDevRowTotals($tr);
    updateDevRowTotalCell($tr, totals.total);
    updateDevRowPickingCell($tr, totals.unidadesPicking);
    return totals;
  }

  function resetDevTotalsFooter(){
    if ($devTotalCell.length) {
      $devTotalCell.text('0');
      $devTotalCell.removeAttr('data-total-raw');
    }
    if ($devTotalPickingCell.length) {
      $devTotalPickingCell.text('0');
      $devTotalPickingCell.removeAttr('data-picking-raw');
    }
  }

  function setFooterValue($cell, attr, value){
    if (!$cell.length) return;
    if (!Number.isFinite(value)) return;
    const rounded = Math.round(value);
    $cell.text(rounded.toLocaleString(DEV_NUMBER_LOCALE));
    $cell.attr(attr, String(rounded));
  }

  function updateDevTotalsFooter(total, picking){
    setFooterValue($devTotalCell, 'data-total-raw', total);
    setFooterValue($devTotalPickingCell, 'data-picking-raw', picking);
  }

  function recalcDevTotals(){
    let total = 0;
    let picking = 0;
    $devTable.find('tr').each(function(){
      const rawAttr = $(this).find('[data-field="total_unidades"]').attr('data-total-raw');
      const raw = rawAttr != null ? Number(rawAttr) : NaN;
      if (!Number.isNaN(raw)) {
        total += raw;
      }
      const pickAttr = $(this).find('[data-field="unidades_a_picking"]').attr('data-picking-raw');
      const pick = pickAttr != null ? Number(pickAttr) : NaN;
      if (!Number.isNaN(pick)) {
        picking += pick;
      }
    });
    updateDevTotalsFooter(total, picking);
  }

  function ensureConversionForSku(sku){
    const key = normSkuKey(sku);
    if (!key) return $.Deferred().resolve().promise();
    if (devConversionMap.has(key)) {
      return $.Deferred().resolve(devConversionMap.get(key)).promise();
    }
    if (devConversionPending.has(key)) {
      return devConversionPending.get(key);
    }
    const request = $.getJSON(joinUrl('api/operaciones/so_embarque_devoluciones.php'), { lookup_sku: sku })
      .done(function(resp){
        if (resp && resp.ok && resp.conversion) {
          upsertDevConversion(resp.conversion);
        }
      })
      .always(function(){
        devConversionPending.delete(key);
      });
    devConversionPending.set(key, request);
    return request;
  }

  function humanizeEstado(code){
    const raw = String(code || '').trim();
    if (!raw) return '';
    return raw.replace(/_/g, ' ').toUpperCase();
  }

  function updateRetroEstadoButton(){
    if (!$btnRetroEstado.length) return;
    const prevCode = (embPrevEstadoCode || '').trim();
    if (!prevCode) {
      $btnRetroEstado.hide().prop('disabled', false).removeAttr('data-target-state');
      return;
    }
    $btnRetroEstado.text('Volver a ' + humanizeEstado(prevCode));
    $btnRetroEstado.attr('data-target-state', prevCode);
    $btnRetroEstado.show().prop('disabled', false);
  }

  function renderInvoiceBadges(){
    const entries = Array.from(invoiceMap.values());
    const hasInvoices = entries.length > 0;
    if ($facturasDatalist.length) {
      $facturasDatalist.empty();
      entries.forEach(function(item){
        const $opt = $('<option>')
          .attr('value', item.value)
          .text(item.value);
        if (item.destinatario) {
          $opt.attr('label', item.destinatario);
        }
        $facturasDatalist.append($opt);
      });
    }
    const renderList = function($wrap, $list){
      if (!$wrap.length || !$list.length) return;
      $wrap.toggle(hasInvoices);
      $list.empty();
      if (!hasInvoices) return;
      entries.forEach(function(item){
        const $badge = $('<span class="badge bg-dark bg-opacity-75"></span>').text(item.value);
        if (item.destinatario) {
          $badge.attr('title', item.destinatario);
        }
        $list.append($badge);
      });
    };
    renderList($devFacturasWrap, $devFacturasList);
    renderList($rendFacturasWrap, $rendFacturasList);
  }

  function updateInvoiceDisplayMeta($target){
    if (!$target || !$target.length) return;
    const rawValue = getFieldValueFromNode($target);
    const meta = invoiceMap.get(normInvoiceKey(rawValue));
    if (meta && meta.destinatario) {
      $target.attr('title', meta.destinatario);
    } else {
      $target.removeAttr('title');
    }
    if (!$target.is('input, select')) {
      const display = rawValue ? rawValue : '—';
      const $text = $target.find('.dev-factura-text');
      if ($text.length) {
        $text.text(display);
      }
    }
    const $row = $target.closest('tr');
    if ($row.length && $row.closest('tbody').is($devTable)) {
      applyInvoiceMetaToRow($row);
    }
  }

  function loadInvoiceCatalog(){
    if (!embId) {
      invoiceCatalog = [];
      computeInvoiceMap(invoiceCatalog);
      renderInvoiceBadges();
      return $.Deferred().resolve().promise();
    }
    return $.getJSON(joinUrl('api/operaciones/so_embarque_facturas.php'), { embarque_id: embId })
      .done(function(r){
        invoiceCatalog = Array.isArray(r?.facturas) ? r.facturas : [];
        computeInvoiceMap(invoiceCatalog);
  renderInvoiceBadges();
  $devTable.find('[data-field="factura"]').each(function(){ updateInvoiceDisplayMeta($(this)); });
  $rendTable.find('input[data-field="factura"]').each(function(){ updateInvoiceDisplayMeta($(this)); });
      })
      .fail(function(){
        invoiceCatalog = [];
        computeInvoiceMap(invoiceCatalog);
  renderInvoiceBadges();
  $devTable.find('[data-field="factura"]').each(function(){ updateInvoiceDisplayMeta($(this)); });
  $rendTable.find('input[data-field="factura"]').each(function(){ updateInvoiceDisplayMeta($(this)); });
      });
  }

  function loadCatalogs(options){
    const opts = options || {};
    const todayIso = (function(){
      const d = new Date();
      const pad = (n)=> String(n).padStart(2,'0');
      return `${d.getFullYear()}-${pad(d.getMonth()+1)}-${pad(d.getDate())}`;
    })();

    function renderMoviles(rawList){
      const normalized = [];
      const seen = new Set();
      (Array.isArray(rawList) ? rawList : []).forEach(function(item){
        const id = parseInt(item && item.id != null ? item.id : 0, 10) || 0;
        if (!id || seen.has(id)) return;
        seen.add(id);
        const norm = Object.assign({}, item, {
          id,
          chapa: item && item.chapa ? String(item.chapa) : (item && item.nombre ? String(item.nombre) : (item && item.label ? String(item.label) : ('#'+id))),
          label: buildMovilLabel(item)
        });
        normalized.push(norm);
      });

      if (opts.movilId) {
        const includeId = parseInt(opts.movilId, 10) || 0;
        if (includeId && !seen.has(includeId)) {
          const fallbackLabel = buildMovilLabel({ id: includeId, chapa: opts.movilLabel || ('#'+includeId) });
          normalized.push({
            id: includeId,
            chapa: opts.movilLabel || fallbackLabel,
            label: fallbackLabel,
            fuera_catalogo: true
          });
        }
      }

      normalized.sort(function(a, b){
        const la = String(a.label || a.chapa || '').toUpperCase();
        const lb = String(b.label || b.chapa || '').toUpperCase();
        if (la < lb) return -1;
        if (la > lb) return 1;
        return 0;
      });

      $movil.empty().append('<option value="">Seleccione móvil…</option>');
      normalized.forEach(function(m){
        const optionLabel = (m.label || m.chapa || ('#'+m.id));
        $movil.append(`<option value="${m.id}">${optionLabel}</option>`);
      });
      $movil.data('options', normalized);
    }

    function loadMoviles(){
      const params = { fecha: opts.fecha || todayIso };
      if (opts.movilId) params.include_id = opts.movilId;
      const deferred = $.Deferred();
      $.getJSON(joinUrl('api/operaciones/moviles_disponibles_select.php'), params)
        .done(function(resp){
          renderMoviles(resp && Array.isArray(resp.data) ? resp.data : []);
          deferred.resolve(resp);
        })
        .fail(function(){
          const fallbackParams = { limit: 500 };
          if (opts.movilId) fallbackParams.id = opts.movilId;
          $.getJSON(joinUrl('api/parametros/moviles_select.php'), fallbackParams)
            .done(function(resp){
              renderMoviles(resp && Array.isArray(resp.data) ? resp.data : []);
              deferred.resolve(resp);
            })
            .fail(function(err){ deferred.reject(err); });
        });
      return deferred.promise();
    }

    function loadChoferes(){
      return $.getJSON(joinUrl('api/parametros/choferes.php'), { limit: 500 }).then(function(r){
        const arr = (r && Array.isArray(r.data)) ? r.data : [];
        const seen = new Set();
        $chofer.empty().append('<option value="">Seleccione chofer…</option>');
        arr.forEach(function(c){
          const id = parseInt(c && c.id != null ? c.id : 0, 10) || 0;
          if (!id) return;
          seen.add(id);
          const label = c.nombre || c.label || ('#'+id);
          $chofer.append(`<option value="${id}">${label}</option>`);
        });
        if (opts.choferId) {
          const includeId = parseInt(opts.choferId, 10) || 0;
          if (includeId && !seen.has(includeId)) {
            const fallbackLabel = opts.choferLabel || ('#'+includeId);
            $chofer.append(`<option value="${includeId}">${fallbackLabel}</option>`);
            arr.push({ id: includeId, nombre: fallbackLabel, fuera_catalogo: true });
          }
        }
        $chofer.data('options', arr);
      });
    }

    return $.when(loadMoviles(), loadChoferes());
  }

  function loadEmb(){
    $.getJSON(joinUrl('api/operaciones/so_embarque_get.php'), { embarque_id: embId }, function(r){
      if (!r || !r.ok) { notify('error','Error','No se pudo cargar el embarque'); return; }
    const e = r.embarque || {};
    const pres = r.preembarques || [];
    const ret = r.retorno || null;
      $estado.text(e.estado||'-');
      const estadoCode = String(e.estado||'').trim().toUpperCase();
    embEstadoCode = estadoCode;
    embPrevEstadoCode = String(e.prev_estado_code || '').trim().toUpperCase();
      $codigo.val(e.codigo||'');
      $depo.val(e.deposito||'');
      // Pre-selección: esperar catálogos cargados
      const currentMovilLabel = e.movil_label || '';
      const currentChoferLabel = e.chofer_label || '';
      const setSelectors = () => {
        const mid = e.movil_id||'';
        const cid = e.chofer_id||'';
        if (mid) {
          if ($movil.find('option[value="'+mid+'"]').length === 0) {
            const opts = $movil.data('options') || [];
            const label = findLabel(opts, mid, 'label', currentMovilLabel);
            $movil.append(`<option value="${mid}">${label}</option>`);
            if (Array.isArray(opts)) {
              opts.push({ id: mid, label, chapa: label });
              $movil.data('options', opts);
            }
          }
          $movil.val(String(mid));
        } else {
          $movil.val('');
        }
        if (cid) {
          $chofer.val(String(cid));
        } else {
          $chofer.val('');
        }
        // Toggle RO if already set
        toggleMovChoferReadOnly(mid, cid, currentMovilLabel, currentChoferLabel);
      };
      loadCatalogs({
        movilId: e.movil_id || null,
        movilLabel: currentMovilLabel,
        choferId: e.chofer_id || null,
        choferLabel: currentChoferLabel
      }).always(setSelectors);
      $llegada.val(e.llegada_at||'');
      $cargaIni.val(e.carga_inicio_at||'');
      $cargaFin.val(e.carga_fin_at||'');
      $salida.val(e.salida_at||'');
      $tickPort.val(e.ticket_porteria||'');
      $tickBas.val(e.ticket_bascula||'');
      $temp.val(e.temp_salida_c||'');
      $ayud.val(e.ayudantes_cant||'');
      $km.val(e.km_inicial||'');
      $obs.val(e.observacion||'');
      // Render PRE asociado (mostrar solo el primero) y alternar cards
      $tbl.empty();
      if (pres.length > 0) {
        const p = pres[0];
        currentPreId = p.id;
        $preCode.text(p.codigo || ('PRE-' + p.id));
        $prePedido.text(p.pedido || (p.so_codigo || '-'));
        $preEstado.text(p.estado || '-');
        // Link directo al PDF de la Planilla de Salida (API mPDF)
        $preDocLink.attr('href', joinUrl('api/operaciones/so_embarque_planilla_pdf.php') + '?embarque_id=' + embId);
        $cardPreAsoc.show();
        $cardPreLista.hide();
      } else {
        currentPreId = null;
        $cardPreAsoc.hide();
        $cardPreLista.show();
      }

    // Si el estado es CARGADO o posterior (EN_RUTA, ENTREGADO, VUELTA, FINALIZADO) entonces bloquear todo excepto horarios
  const lockAll = ['CARGADO','EN_RUTA','ENTREGADO','VUELTA','FINALIZADO'].includes(estadoCode);
    setLockedMode(lockAll, estadoCode === 'FINALIZADO', estadoCode);
    updateRetroEstadoButton();
      // Mostrar botón EN RUTA solo cuando esté CARGADO
      if (estadoCode === 'CARGADO') { $('#btnMarcarEnRuta').show(); } else { $('#btnMarcarEnRuta').hide(); }
      if ($btnFinalize.length) {
        if (estadoCode === 'VUELTA') {
          $btnFinalize.show().prop('disabled', false);
        } else {
          $btnFinalize.hide().prop('disabled', false);
        }
      }
      // Mostrar card Vuelta desde CARGADO en adelante
      if (['CARGADO','EN_RUTA','ENTREGADO','VUELTA','FINALIZADO'].includes(estadoCode)) {
        $('#cardVuelta').show();
      } else {
        $('#cardVuelta').hide();
      }

  if (estadoCode === 'FINALIZADO' || estadoCode === 'VUELTA') {
        $devCard.show();
        $rendCard.show();
      } else {
        $devCard.hide();
        $rendCard.hide();
        invoiceCatalog = [];
        computeInvoiceMap(invoiceCatalog);
        renderInvoiceBadges();
        resetDevoluciones();
        resetRendiciones();
      }
      // Mostrar info de retorno si existe
      if (ret) {
        $('#vueltaInfoHora').text(ret.llegada_at || '-');
        $('#vueltaInfoObs').text(ret.observacion || '-');
        $('#vueltaInfo').show();
      } else {
        $('#vueltaInfo').hide();
      }

      // Mostrar u ocultar Seguimiento según estado
      handleSeguimientoVisibility(estadoCode);
      if (estadoCode === 'FINALIZADO' || estadoCode === 'VUELTA') {
        loadInvoiceCatalog().always(function(){
          loadDevoluciones();
          loadRendiciones();
        });
      }
    });
  }

  function findLabel(arr, id, keyLabel, fallback){
    const it = (arr||[]).find(x=> String(x.id)===String(id));
    if (!it) return fallback || ('#'+id);
    if (keyLabel && it[keyLabel]) return it[keyLabel];
    if (it.label) return it.label;
    if (it.nombre) return it.nombre;
    if (it.chapa) return it.chapa;
    if (it.placa) return it.placa;
    return fallback || ('#'+id);
  }

  function toggleMovChoferReadOnly(movilId, choferId, movilLabelFallback, choferLabelFallback){
    const movSet = !!movilId; const choSet = !!choferId;
    if (movSet) {
      const opts = $movil.data('options') || [];
      const label = findLabel(opts, movilId, 'label', movilLabelFallback);
      $movil.hide();
      $movilRO.val(label).show();
    } else {
      $movilRO.hide();
      $movil.show();
    }
    if (choSet) {
      const opts = $chofer.data('options') || [];
      const label = findLabel(opts, choferId, 'nombre', choferLabelFallback);
      $chofer.hide();
      $choferRO.val(label).show();
    } else {
      $choferRO.hide();
      $chofer.show();
    }
  }

  function setLockedMode(locked, fullyFinalized, estadoCode){
    const normalizedEstado = String(estadoCode || '').trim().toUpperCase();
    const editable = fullyFinalized ? [] : [$llegada, $cargaIni, $cargaFin, $salida];
    const baseControls = [
      $movil, $movilRO, $chofer, $choferRO, $tickPort, $tickBas, $temp, $ayud, $km, $obs,
  $('#btnAdjuntarPre'), $('#btnQuitarPre'), $('#btnQuitarPreSingle'), $('#btnMarcarCargado'),
  $('#btnLlegadaAhora'), $('#btnCargaInicioAhora'), $('#btnCargaFinAhora'), $('#btnSalidaAhora')
    ];
    baseControls.forEach($el=>{ if (!$el || !$el.length) return; if (!fullyFinalized && editable.some(e=>$el.is(e))) return; $el.prop('disabled', locked); });

    const $btnEnRuta = $('#btnMarcarEnRuta');
    const $btnRegistrarVuelta = $('#btnRegistrarVuelta');
    const $vueltaControls = $('#btnVueltaAhora, #vueltaHora, #vueltaDocTipo, #vueltaDocNro, #vueltaRendicion');

    if (fullyFinalized) {
      $btnEnRuta.prop('disabled', true);
      $btnRegistrarVuelta.prop('disabled', true);
      $vueltaControls.prop('disabled', true);
    } else {
  if (normalizedEstado === 'CARGADO') {
        $btnEnRuta.prop('disabled', false).show();
      } else {
        $btnEnRuta.prop('disabled', true);
      }
  if (normalizedEstado === 'VUELTA') {
        $btnRegistrarVuelta.prop('disabled', true).hide();
        $vueltaControls.prop('disabled', true);
        $('#btnVueltaAhora').hide();
      } else {
        $btnRegistrarVuelta.prop('disabled', false).show();
        $vueltaControls.prop('disabled', false);
        $('#btnVueltaAhora').show();
      }
    }
    // Adicional: si locked, ocultar botones de adjuntar/quitar PRE y los de estado
    if (locked) {
      $('#btnAdjuntarPre').hide();
      $('#btnQuitarPre').hide();
      $('#btnQuitarPreSingle').hide();
      $('#btnMarcarCargado').hide();
      if (normalizedEstado === 'CARGADO' && !fullyFinalized) {
        $btnEnRuta.show();
      } else {
        $btnEnRuta.hide();
      }
      // Asegurar RO para móvil/chofer
      $movil.hide(); $movilRO.show();
      $chofer.hide(); $choferRO.show();
      if (normalizedEstado === 'VUELTA' && !fullyFinalized) {
        $btnRegistrarVuelta.hide();
        $('#btnVueltaAhora').hide();
      } else if (fullyFinalized) {
        // Ocultar también acciones de vuelta
        $btnRegistrarVuelta.hide();
        $('#btnVueltaAhora').hide();
      }
    } else {
      $('#btnAdjuntarPre').show();
      $('#btnQuitarPre').show();
      if (currentPreId) $('#btnQuitarPreSingle').show(); else $('#btnQuitarPreSingle').hide();
      $('#btnMarcarCargado').show();
      $('#btnMarcarEnRuta').show();
      if (normalizedEstado === 'VUELTA') {
        $btnRegistrarVuelta.hide();
        $('#btnVueltaAhora').hide();
      } else {
        $btnRegistrarVuelta.show();
        $('#btnVueltaAhora').show();
      }
    }
    ancillaryLocked = locked;
    ancillaryFullyFinalized = fullyFinalized;
    ancillaryAllowWhileLocked = !fullyFinalized && ['EN_RUTA','ENTREGADO','VUELTA'].includes(normalizedEstado);
    applyAncillaryLockState();
  }

  function canShowSeguimiento(estadoCode){
    const normalized = (estadoCode || '').toUpperCase();
    return ['CARGADO','EN_RUTA','ENTREGADO','VUELTA','FINALIZADO'].includes(normalized);
  }

  function resetSeguimiento(){
    if (segDT && $.fn.DataTable) {
      segDT.clear();
      segDT.destroy();
      segDT = null;
    }
    if ($segTBody.length) {
      $segTBody.empty();
    }
    calcAndRenderSegTotals();
    seguimientoCardVisible = false;
  }

  function handleSeguimientoVisibility(estadoCode){
    if (!$cardSeguimiento.length) return;
    const allow = canShowSeguimiento(estadoCode);
    if (allow) {
      $cardSeguimiento.show();
      loadSeguimiento();
      seguimientoCardVisible = true;
    } else {
      $cardSeguimiento.hide();
      resetSeguimiento();
    }
  }

  function saveEmb(){
    const body = {
      embarque_id: embId,
      movil_id: parseInt($movil.val(),10)||null,
      chofer_id: parseInt($chofer.val(),10)||null,
      llegada_at: $llegada.val()||null,
      carga_inicio_at: $cargaIni.val()||null,
      carga_fin_at: $cargaFin.val()||null,
      salida_at: $salida.val()||null,
      ticket_porteria: $tickPort.val()||null,
      ticket_bascula: $tickBas.val()||null,
      temp_salida_c: $temp.val()||null,
      ayudantes_cant: $ayud.val()||null,
      km_inicial: $km.val()||null,
      observacion: $obs.val()||null,
    };
    $.ajax({ url: joinUrl('api/operaciones/so_embarque_update.php'), method:'POST', contentType:'application/json; charset=utf-8', dataType:'json', data: JSON.stringify(body) })
      .done(function(r){ if (r && r.ok) { notify('success','Guardado','Embarque actualizado'); loadEmb(); } else { notify('error','Error', r?.error||'No se pudo guardar'); } })
      .fail(function(x){ notify('error','Error', x.responseText||x.statusText); });
  }

  function adjuntarPre(){
    const preId = prompt('Ingrese el ID del PRE a adjuntar:');
    const id = parseInt(preId,10); if (!id) return;
    $.ajax({ url: joinUrl('api/operaciones/so_embarque_attach_pre.php'), method:'POST', contentType:'application/json; charset=utf-8', dataType:'json', data: JSON.stringify({ embarque_id: embId, pre_id: id }) })
      .done(function(r){ if (r && r.ok) { notify('success','OK','PRE adjuntado'); loadEmb(); } else { notify('error','Error', r?.error||'No se pudo adjuntar'); } })
      .fail(function(x){ notify('error','Error', x.responseText||x.statusText); });
  }

  function quitarPreById(preId){
    if (!preId) { notify('warning','Seleccione','No se encontró PRE asociado'); return; }
    confirmSwal({
      text: '¿Quitar PRE del embarque?',
      icon: 'question',
      confirmButtonText: 'Sí, quitar'
    }).then(function(ok){
      if (!ok) return;
      $.ajax({ url: joinUrl('api/operaciones/so_embarque_detach_pre.php'), method:'POST', contentType:'application/json; charset=utf-8', dataType:'json', data: JSON.stringify({ embarque_id: embId, pre_id: preId }) })
        .done(function(r){ if (r && r.ok) { notify('success','OK','PRE desvinculado'); loadEmb(); } else { notify('error','Error', r?.error||'No se pudo quitar'); } })
        .fail(function(x){ notify('error','Error', x.responseText||x.statusText); });
    });
  }

  function quitarPre(){
    // Compat: desde la tabla (cuando no hay PRE asociado aún)
    const $tr = $('#tblEmbPres tr.selected');
    const preId = parseInt($tr.attr('data-pre-id'),10)||0;
    if (!preId) { notify('warning','Seleccione','Seleccione un PRE de la tabla'); return; }
    quitarPreById(preId);
  }

  // Row selection simple
  $('#tblEmbPres').on('click','tr', function(){ $(this).toggleClass('selected').siblings().removeClass('selected'); });

  $('#btnGuardarEmb').on('click', saveEmb);
  $('#btnAdjuntarPre').on('click', adjuntarPre);
  $('#btnQuitarPre').on('click', quitarPre);
  $('#btnQuitarPreSingle').on('click', function(){ quitarPreById(currentPreId); });
  $('#btnVolverEmb').on('click', function(){ window.history.back(); });
  $btnRetroEstado.on('click', function(){
    if (!$btnRetroEstado.length) return;
    if (!embId) { notify('error','Error','Embarque inválido'); return; }
    const prevCode = (embPrevEstadoCode || '').trim();
    if (!prevCode) { notify('warning','Sin estado','No hay estado anterior disponible'); return; }
    const prevLabel = humanizeEstado(prevCode);
    confirmSwal({
      text: '¿Volver el embarque al estado ' + prevLabel + '?',
      icon: 'warning',
      confirmButtonText: 'Sí, volver'
    }).then(function(ok){
      if (!ok) return;
      $btnRetroEstado.prop('disabled', true);
      const shouldRemoveRet = ['VUELTA','FINALIZADO'].includes((embEstadoCode || '').toUpperCase());
      $.ajax({
        url: joinUrl('api/operaciones/so_embarque_estado_prev.php'),
        method: 'POST',
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        data: JSON.stringify({ embarque_id: embId, remove_retorno: shouldRemoveRet })
      })
        .done(function(r){
          if (r && r.ok) {
            const newCode = String(r.estado_code || prevCode || '').trim();
            notify('success','Estado actualizado','El embarque volvió a ' + humanizeEstado(newCode));
            loadEmb();
          } else {
            notify('error','Error', r && r.error ? r.error : 'No se pudo retroceder el estado');
          }
        })
        .fail(function(x){
          notify('error','Error', x.responseText || x.statusText || 'No se pudo retroceder el estado');
        })
        .always(function(){
          $btnRetroEstado.prop('disabled', false);
        });
    });
  });
  $btnFinalize.on('click', function(){
    if (!$btnFinalize.length) return;
    if (!embId) { notify('error','Error','Embarque inválido'); return; }
    if ((embEstadoCode || '').toUpperCase() !== 'VUELTA') {
      notify('warning','Estado incompatible','Solo se puede finalizar desde estado VUELTA');
      return;
    }
    confirmSwal({
      text: '¿Confirmar que el embarque fue finalizado definitivamente?',
      icon: 'warning',
      confirmButtonText: 'Sí, finalizar'
    }).then(function(ok){
      if (!ok) return;
      $btnFinalize.prop('disabled', true);
      $.ajax({
        url: joinUrl('api/operaciones/so_embarque_set_estado.php'),
        method: 'POST',
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        data: JSON.stringify({ embarque_id: embId, estado_code: 'FINALIZADO' })
      })
        .done(function(r){
          if (r && r.ok) {
            notify('success','Estado actualizado','El embarque fue finalizado');
            loadEmb();
          } else {
            notify('error','Error', r && r.error ? r.error : 'No se pudo finalizar el embarque');
          }
        })
        .fail(function(x){
          notify('error','Error', x.responseText || x.statusText || 'No se pudo finalizar el embarque');
        })
        .always(function(){
          $btnFinalize.prop('disabled', false);
        });
    });
  });

  $('#btnMarcarCargado').on('click', function(){
    confirmSwal({
      text: '¿Confirmar que el embarque está CARGADO (embarcado)?',
      icon: 'warning',
      confirmButtonText: 'Sí, marcar'
    }).then(function(ok){
      if (!ok) return;
      $.ajax({ url: joinUrl('api/operaciones/so_embarque_set_estado.php'), method:'POST', contentType:'application/json; charset=utf-8', dataType:'json', data: JSON.stringify({ embarque_id: embId, estado_code: 'CARGADO' }) })
        .done(function(r){ if (r && r.ok) { notify('success','Estado actualizado','El embarque fue marcado como CARGADO'); loadEmb(); } else { notify('error','Error', r?.error||'No se pudo cambiar estado'); } })
        .fail(function(x){ notify('error','Error', x.responseText||x.statusText); });
    });
  });

  // EN RUTA
  // Helpers para setear hora actual en inputs datetime-local
  function nowLocal(){
    const d = new Date();
    const pad = (n)=> String(n).padStart(2,'0');
    const yyyy = d.getFullYear();
    const mm = pad(d.getMonth()+1);
    const dd = pad(d.getDate());
    const hh = pad(d.getHours());
    const mi = pad(d.getMinutes());
    return `${yyyy}-${mm}-${dd}T${hh}:${mi}`;
  }
  $('#btnLlegadaAhora').on('click', function(){ $llegada.val(nowLocal()); });
  $('#btnCargaInicioAhora').on('click', function(){ $cargaIni.val(nowLocal()); });
  $('#btnCargaFinAhora').on('click', function(){ $cargaFin.val(nowLocal()); });
  $('#btnSalidaAhora').on('click', function(){ $salida.val(nowLocal()); });
  $('#btnVueltaAhora').on('click', function(){ $('#vueltaHora').val(nowLocal()); });

  // VUELTA
  $('#btnRegistrarVuelta').on('click', function(){
    const payload = {
      embarque_id: embId,
      llegada_vuelta_at: $('#vueltaHora').val() || null,
      doc_tipo: $('#vueltaDocTipo').val() || null,
      doc_numero: $('#vueltaDocNro').val() || null,
      rendicion: $('#vueltaRendicion').val() || null,
    };
    confirmSwal({
      text: '¿Confirmar VUELTA y cerrar el embarque?',
      icon: 'warning',
      confirmButtonText: 'Sí, registrar'
    }).then(function(ok){
      if (!ok) return;
      $.ajax({ url: joinUrl('api/operaciones/so_embarque_vuelta.php'), method:'POST', contentType:'application/json; charset=utf-8', dataType:'json', data: JSON.stringify(payload) })
        .done(function(r){
          if (r && r.ok) {
            const nextLabel = humanizeEstado(r.estado_code || 'VUELTA');
            notify('success','Vuelta registrada','Embarque en estado ' + nextLabel);
            loadEmb();
          } else {
            notify('error','Error', r?.error||'No se pudo registrar la vuelta');
          }
        })
        .fail(function(x){ notify('error','Error', x.responseText||x.statusText); });
    });
  });

  $('#btnMarcarEnRuta').on('click', function(){
    confirmSwal({
      text: '¿Confirmar que el embarque está EN RUTA?',
      icon: 'warning',
      confirmButtonText: 'Sí, marcar'
    }).then(function(ok){
      if (!ok) return;
      $.ajax({ url: joinUrl('api/operaciones/so_embarque_set_estado.php'), method:'POST', contentType:'application/json; charset=utf-8', dataType:'json', data: JSON.stringify({ embarque_id: embId, estado_code: 'EN_RUTA' }) })
        .done(function(r){ if (r && r.ok) { notify('success','Estado actualizado','El embarque fue marcado como EN RUTA'); loadEmb(); } else { notify('error','Error', r?.error||'No se pudo cambiar estado'); } })
        .fail(function(x){ notify('error','Error', x.responseText||x.statusText); });
    });
  });

  // Devoluciones helpers
  function updateDevEmptyState(){
    if (!$devEmpty.length) return;
    const hasRows = $devTable && $devTable.length ? $devTable.find('tr').length > 0 : false;
    $devEmpty.toggle(!hasRows);
  }

  function resetDevoluciones(){
    if ($devTable.length) {
      $devTable.empty();
      updateDevEmptyState();
    }
    if ($devFacturasWrap.length) {
      $devFacturasWrap.hide();
    }
    if ($devFacturasList.length) {
      $devFacturasList.empty();
    }
  }

  function updateRendEmptyState(){
    if (!$rendEmpty.length) return;
    const hasRows = $rendTable && $rendTable.length ? $rendTable.find('tr').length > 0 : false;
    $rendEmpty.toggle(!hasRows);
  }

  function resetRendiciones(){
    if ($rendTable.length) {
      $rendTable.empty();
      updateRendEmptyState();
    }
    if ($rendFacturasWrap.length) {
      $rendFacturasWrap.hide();
    }
    if ($rendFacturasList.length) {
      $rendFacturasList.empty();
    }
  }

  function applyAncillaryLockState(){
    applyDevolucionesLockState();
    applyRendicionesLockState();
  }

  function applyDevolucionesLockState(){
    if (!$devCard.length) return;
    let shouldLock = isAncillaryInteractionLocked();
    if ((embEstadoCode || '').trim().toUpperCase() === 'VUELTA') {
      shouldLock = false;
    }
    const $inputs = $devCard.find('input, select');
    const $actionBtns = $devCard.find('.btn-dev-save, .btn-dev-delete, .btn-dev-zero');
    $inputs.prop('disabled', shouldLock);
    $actionBtns.prop('disabled', shouldLock);
    if ($btnDevAdd.length) {
      if (shouldLock) {
        $btnDevAdd.hide();
      } else {
        $btnDevAdd.show().prop('disabled', false);
      }
    }
  }

  function applyRendicionesLockState(){
    if (!$rendCard.length) return;
    let shouldLock = isAncillaryInteractionLocked();
    if ((embEstadoCode || '').trim().toUpperCase() === 'VUELTA') {
      shouldLock = false;
    }
    const $inputs = $rendCard.find('input, select');
    const $actionBtns = $rendCard.find('.btn-rend-save, .btn-rend-delete');
    $inputs.prop('disabled', shouldLock);
    $actionBtns.prop('disabled', shouldLock);
    if ($btnRendAdd.length) {
      if (shouldLock) {
        $btnRendAdd.hide();
      } else {
        $btnRendAdd.show().prop('disabled', false);
      }
    }
  }

  function isAncillaryInteractionLocked(){
    return ancillaryLocked && !ancillaryAllowWhileLocked;
  }

  function formatDateForInput(val){
    if (!val) return '';
    const str = String(val).trim();
    if (!str) return '';
    if (str.includes('T')) return str.split('T')[0];
    return str.substring(0,10);
  }

  function formatDateTimeForInput(val){
    if (!val) return '';
    const str = String(val).trim();
    if (!str) return '';
    if (str.includes('T')) return str.substring(0,16);
    return str.replace(' ', 'T').substring(0,16);
  }

  function normalizeDateTimeForApi(val){
    if (!val) return null;
    const str = String(val).trim();
    if (!str) return null;
    if (str.includes('T')) {
      const [datePart, timePart] = str.split('T');
      if (datePart && timePart) {
        const normalizedTime = timePart.length === 5 ? `${timePart}:00` : timePart;
        return `${datePart} ${normalizedTime}`;
      }
    }
    return str;
  }

  function getRowProp(row, key){
    if (!row || typeof row !== 'object') return '';
    const val = row[key];
    return val == null ? '' : val;
  }

  function buildInvoiceSkuIndex(){
    const index = new Map();
    invoiceMap.forEach(function(meta, key){
      const items = (meta && Array.isArray(meta.items)) ? meta.items : [];
      items.forEach(function(item){
        if (!item) return;
        const skuKey = normSkuKey(item.sku);
        if (!skuKey) return;
        if (!index.has(skuKey)) {
          index.set(skuKey, []);
        }
        const bucket = index.get(skuKey);
        if (!bucket.includes(key)) {
          bucket.push(key);
        }
      });
    });
    return index;
  }

  function assignMissingFacturas(rows){
    if (!Array.isArray(rows) || !rows.length || invoiceMap.size === 0) {
      return rows;
    }
    const skuIndex = buildInvoiceSkuIndex();
    const fallbackKeys = Array.from(invoiceMap.keys());
    const assignmentCount = new Map();
    let fallbackCursor = 0;

    rows.forEach(function(row){
      if (!row || typeof row !== 'object') return;
      const current = getRowProp(row, 'factura');
      if (current) return;
      const skuKey = normSkuKey(getRowProp(row, 'sku'));
      let candidateKeys = [];
      if (skuKey && skuIndex.has(skuKey)) {
        candidateKeys = skuIndex.get(skuKey);
      }
      let chosenKey = null;
      if (candidateKeys.length === 1) {
        chosenKey = candidateKeys[0];
      } else if (candidateKeys.length > 1) {
        candidateKeys.sort(function(a, b){
          const countA = assignmentCount.get(a) || 0;
          const countB = assignmentCount.get(b) || 0;
          if (countA !== countB) return countA - countB;
          return fallbackKeys.indexOf(a) - fallbackKeys.indexOf(b);
        });
        chosenKey = candidateKeys[0];
      } else if (fallbackKeys.length > 0) {
        chosenKey = fallbackKeys[fallbackCursor % fallbackKeys.length];
        fallbackCursor++;
      }
      if (!chosenKey) return;
      const meta = invoiceMap.get(chosenKey);
      if (!meta) return;
      const value = meta.value || meta.factura || '';
      if (!value) return;
      row.factura = value;
      assignmentCount.set(chosenKey, (assignmentCount.get(chosenKey) || 0) + 1);
    });
    return rows;
  }

  function syncDevolRowsWithInvoices(rows){
    const source = Array.isArray(rows) ? rows : [];
    const unique = new Map();
    source.forEach(function(row){
      if (!row || typeof row !== 'object') return;
      const rowId = parseInt(getRowProp(row, 'id'), 10) || 0;
      let key;
      if (rowId > 0) {
        key = 'id:' + rowId;
      } else {
        const facturaKey = normInvoiceKey(getRowProp(row, 'factura'));
        const skuKey = normSkuKey(getRowProp(row, 'sku'));
        key = 'fact:' + facturaKey + '|sku:' + skuKey;
      }
      if (!unique.has(key)) {
        unique.set(key, Object.assign({}, row));
      }
    });

    const result = assignMissingFacturas(Array.from(unique.values()));
    const order = Array.from(invoiceMap.keys());
    const compareFallback = function(a, b){
      const fa = String(getRowProp(a, 'factura') || '').toUpperCase();
      const fb = String(getRowProp(b, 'factura') || '').toUpperCase();
      if (fa < fb) return -1;
      if (fa > fb) return 1;
      const ia = parseInt(getRowProp(a, 'id'), 10) || 0;
      const ib = parseInt(getRowProp(b, 'id'), 10) || 0;
      return ia - ib;
    };

    if (order.length === 0) {
      result.sort(compareFallback);
      return result;
    }

    result.sort(function(a, b){
      const fa = normInvoiceKey(getRowProp(a, 'factura'));
      const fb = normInvoiceKey(getRowProp(b, 'factura'));
      const ia = order.indexOf(fa);
      const ib = order.indexOf(fb);
      if (ia === -1 && ib === -1) {
        return compareFallback(a, b);
      }
      if (ia === -1) return 1;
      if (ib === -1) return -1;
      if (ia !== ib) return ia - ib;
      return compareFallback(a, b);
    });

    return result;
  }

  function syncRendRowsWithInvoices(rows){
    const output = Array.isArray(rows) ? rows.slice() : [];
    const existing = new Map();
    output.forEach(function(row){
      const key = normInvoiceKey(getRowProp(row, 'factura'));
      if (key && !existing.has(key)) {
        existing.set(key, row);
      }
    });
    invoiceMap.forEach(function(meta, key){
      if (!existing.has(key)) {
        output.push({
          id: 0,
          factura: meta.value,
          condicion: '',
          fecha_factura: '',
          monto: 0,
          fecha_rendicion: nowLocal()
        });
      }
    });
    const order = Array.from(invoiceMap.keys());
    output.sort(function(a, b){
      const ka = normInvoiceKey(getRowProp(a, 'factura'));
      const kb = normInvoiceKey(getRowProp(b, 'factura'));
      const ia = order.indexOf(ka);
      const ib = order.indexOf(kb);
      if (ia === -1 && ib === -1) {
        const aId = parseInt(getRowProp(a, 'id'), 10) || 0;
        const bId = parseInt(getRowProp(b, 'id'), 10) || 0;
        return aId - bId;
      }
      if (ia === -1) return 1;
      if (ib === -1) return -1;
      return ia - ib;
    });
    return output;
  }

  function getFieldValueFromNode($node){
    if (!$node || !$node.length) return '';
    if ($node.is('input, select')) {
      return String($node.val() || '').trim();
    }
    const dataVal = $node.attr('data-value');
    if (dataVal !== undefined) {
      return String(dataVal).trim();
    }
    return String($node.text() || '').trim();
  }

  function getRowFacturaValue($tr){
    if (!$tr || !$tr.length) return '';
    return getFieldValueFromNode($tr.find('[data-field="factura"]').first());
  }

  function setRowFacturaValue($tr, value){
    if (!$tr || !$tr.length) return;
    const $field = $tr.find('[data-field="factura"]').first();
    if (!$field.length) return;
    const display = value ? String(value) : '—';
    if ($field.is('input, select')) {
      $field.val(value || '');
    } else {
      $field.attr('data-value', value || '');
      const $text = $field.find('.dev-factura-text');
      if ($text.length) {
        $text.text(display);
      } else {
        $field.text(display);
      }
    }
    updateInvoiceDisplayMeta($field);
  }

  function applyInvoiceMetaToRow($tr){
    if (!$tr || !$tr.length) return;
    const facturaValue = getRowFacturaValue($tr);
    const meta = invoiceMap.get(normInvoiceKey(facturaValue));
    const $facturaField = $tr.find('[data-field="factura"]').first();
    if ($facturaField.length) {
      if (meta && meta.destinatario) {
        $facturaField.attr('title', meta.destinatario);
      } else {
        $facturaField.removeAttr('title');
      }
    }
    const $skuField = $tr.find('[data-field="sku"]');
    const currentSku = $skuField.length ? String($skuField.val() || '').trim() : '';
    applyDevInvoiceMetaToRow($tr, meta, currentSku);
  }

  function buildDevRow(row){
    const data = {
      id: row && row.id ? parseInt(row.id, 10) || 0 : 0,
      factura: row && row.factura ? String(row.factura) : '',
      sku: row && row.sku ? String(row.sku) : '',
      pallets: row && row.pallets != null ? parseInt(row.pallets, 10) || 0 : 0,
      cajas_sueltas: row && row.cajas_sueltas != null ? parseInt(row.cajas_sueltas, 10) || 0 : 0,
      unidades_sueltas: row && row.unidades_sueltas != null ? parseInt(row.unidades_sueltas, 10) || 0 : 0,
      unidades_danadas: row && row.unidades_danadas != null ? parseInt(row.unidades_danadas, 10) || 0 : 0,
      motivo: row && row.motivo ? String(row.motivo) : '',
      lote: row && row.lote ? String(row.lote) : '',
      total_unidades: row && row.total_unidades != null ? parseInt(row.total_unidades, 10) || 0 : null,
      unidades_a_picking: row && row.unidades_a_picking != null ? parseInt(row.unidades_a_picking, 10) || 0 : null,
      unidades_por_caja: row && row.unidades_por_caja != null && !Number.isNaN(Number(row.unidades_por_caja)) ? Number(row.unidades_por_caja) : null,
      cajas_por_pallet: row && row.cajas_por_pallet != null && !Number.isNaN(Number(row.cajas_por_pallet)) ? Number(row.cajas_por_pallet) : null,
      unidades_por_pallet: row && row.unidades_por_pallet != null && !Number.isNaN(Number(row.unidades_por_pallet)) ? Number(row.unidades_por_pallet) : null
    };

    const $tr = $('<tr>').attr('data-id', data.id);
    const mkInput = (field, value, opts={}) => {
      const $inp = $('<input>')
        .addClass('form-control form-control-sm')
        .attr('data-field', field)
        .val(value != null ? value : '');
      $inp.attr('type', opts.type || 'text');
      if (opts.placeholder) $inp.attr('placeholder', opts.placeholder);
      if (opts.min !== undefined) $inp.attr('min', opts.min);
      if (opts.step !== undefined) $inp.attr('step', opts.step);
      if (opts.maxlength) $inp.attr('maxlength', opts.maxlength);
      if (opts.className) $inp.addClass(opts.className);
      if (opts.listId) $inp.attr('list', opts.listId);
      if (opts.title) $inp.attr('title', opts.title);
      return $('<td>').append($inp);
    };

    const mkNumber = (field, value) => mkInput(field, value, { type: 'number', min: 0, step: 1, className: 'text-end' });

    const $facturaCell = $('<td class="dev-factura-cell text-nowrap" data-field="factura"><span class="dev-factura-text">—</span></td>');
    $tr.append($facturaCell);
    setRowFacturaValue($tr, data.factura);
    $tr.append($('<td data-role="sku-cell"></td>'));
    $tr.append(mkNumber('pallets', data.pallets));
    $tr.append(mkNumber('cajas_sueltas', data.cajas_sueltas));
    $tr.append(mkNumber('unidades_sueltas', data.unidades_sueltas));
    $tr.append(mkNumber('unidades_danadas', data.unidades_danadas));

    const $totalCell = $('<td class="text-end" data-field="total_unidades">0</td>');
    $tr.append($totalCell);

    const $pickingCell = $('<td class="text-end" data-field="unidades_a_picking">0</td>');
    $tr.append($pickingCell);

    const $motivo = $('<select class="form-select form-select-sm" data-field="motivo"></select>');
    DEV_MOTIVOS.forEach(function(opt){
      const $opt = $('<option>').val(opt.value).text(opt.label);
      if (opt.value === data.motivo) $opt.prop('selected', true);
      $motivo.append($opt);
    });
    $tr.append($('<td>').append($motivo));

    $tr.append(mkInput('lote', data.lote, { placeholder: 'Lote', maxlength: 100 }));

    const setZerosAndSave = function(){
      ['pallets','cajas_sueltas','unidades_sueltas','unidades_danadas'].forEach(function(field){
        const $input = $tr.find('input[data-field="'+field+'"]');
        if ($input.length) $input.val(0);
      });
      const $fields = $tr.find('input[data-field], select[data-field]');
      const $zeroBtn = $tr.find('.btn-dev-zero');
      const applyDisabledState = function(disabled){
        $fields.prop('disabled', disabled);
        $zeroBtn.prop('disabled', disabled);
      };
      applyDisabledState(true);
      updateDevRowTotalsFromInputs($tr);
      recalcDevTotals();
      const restore = function(){
        const shouldDisable = isAncillaryInteractionLocked();
        applyDisabledState(shouldDisable);
      };
      const req = saveDevRow($tr, {
        onAbort: restore,
        onRequestFail: restore
      });
      if (!req) {
        restore();
      }
    };

    const $btnZero = $('<button type="button" class="btn btn-sm btn-outline-secondary btn-dev-zero me-1">Sin devolución</button>').on('click', setZerosAndSave);
    const $btnSave = $('<button type="button" class="btn btn-sm btn-primary btn-dev-save me-1">Guardar</button>').on('click', function(){ saveDevRow($tr); });
    const $btnDel = $('<button type="button" class="btn btn-sm btn-outline-danger btn-dev-delete">Eliminar</button>').on('click', function(){ deleteDevRow($tr); });
    const $actions = $('<td class="text-center">').append($btnZero, $btnSave, $btnDel);
    $tr.append($actions);

    const baseConversion = (data.sku && (data.unidades_por_caja !== null || data.cajas_por_pallet !== null || data.unidades_por_pallet !== null))
      ? {
          sku: data.sku,
          unidades_por_caja: data.unidades_por_caja,
          cajas_por_pallet: data.cajas_por_pallet,
          unidades_por_pallet: data.unidades_por_pallet
        }
      : null;
    if (baseConversion) {
      upsertDevConversion(baseConversion);
      setRowConversion($tr, baseConversion);
    } else {
      const existingConv = devConversionMap.get(normSkuKey(data.sku));
      setRowConversion($tr, existingConv || null);
    }

    applyInvoiceMetaToRow($tr);

    updateDevRowTotalsFromInputs($tr);
    if (data.total_unidades !== null) {
      updateDevRowTotalCell($tr, data.total_unidades);
    }
    if (data.unidades_a_picking !== null) {
      updateDevRowPickingCell($tr, data.unidades_a_picking);
    }

    return $tr;
  }

  function readDevRow($tr){
    const getVal = (field)=>{
      const $el = $tr.find('[data-field="'+field+'"]').first();
      return getFieldValueFromNode($el);
    };
    const toInt = (field)=>{
      const raw = String(getVal(field) || '').trim();
      if (raw === '') return 0;
      const parsed = parseInt(raw, 10);
      return Number.isNaN(parsed) ? 0 : Math.max(0, parsed);
    };
    return {
      rowId: parseInt($tr.attr('data-id'), 10) || 0,
      factura: String(getVal('factura') || '').trim(),
      sku: String(getVal('sku') || '').trim(),
      pallets: toInt('pallets'),
      cajas_sueltas: toInt('cajas_sueltas'),
      unidades_sueltas: toInt('unidades_sueltas'),
      unidades_danadas: toInt('unidades_danadas'),
      motivo: String(getVal('motivo') || ''),
      lote: String(getVal('lote') || '').trim()
    };
  }

  function saveDevRow($tr, options){
    if (!$tr || !$tr.length) return null;
    const opts = Object.assign({
      keepButtonsDisabled: false,
      onAbort: null,
      onRequestFail: null,
      onRequestSuccess: null,
      onAlways: null
    }, options || {});
    const payload = readDevRow($tr);
    if (!embId) {
      notify('error','Error','Embarque inválido');
      if (typeof opts.onAbort === 'function') opts.onAbort();
      return null;
    }
    if (invoiceMap.size > 0 && !payload.factura) {
      notify('warning','Validación','Debe seleccionar la factura');
      if (typeof opts.onAbort === 'function') opts.onAbort();
      return null;
    }
    const body = {
      embarque_id: embId,
      row_id: payload.rowId || null,
      data: {
        factura: payload.factura || null,
        sku: payload.sku || null,
        pallets: payload.pallets,
        cajas_sueltas: payload.cajas_sueltas,
        unidades_sueltas: payload.unidades_sueltas,
        unidades_danadas: payload.unidades_danadas,
        motivo: payload.motivo,
        lote: payload.lote
      }
    };
    const $btns = $tr.find('.btn-dev-save, .btn-dev-delete');
    $btns.prop('disabled', true);
    const request = $.ajax({ url: joinUrl('api/operaciones/so_embarque_devoluciones.php'), method:'POST', contentType:'application/json; charset=utf-8', dataType:'json', data: JSON.stringify(body) })
      .done(function(r){
        if (r && r.ok) {
          if (r.id) $tr.attr('data-id', parseInt(r.id, 10) || 0);
          notify('success','Guardado','Devolución guardada');
          if (typeof opts.onRequestSuccess === 'function') opts.onRequestSuccess(r);
          loadInvoiceCatalog().always(function(){
            loadDevoluciones();
            loadRendiciones();
          });
        } else {
          notify('error','Error', r && r.error ? r.error : 'No se pudo guardar la devolución');
          if (typeof opts.onRequestFail === 'function') opts.onRequestFail(r);
        }
      })
      .fail(function(x){
        notify('error','Error', x.responseText || x.statusText || 'Error al guardar');
        if (typeof opts.onRequestFail === 'function') opts.onRequestFail(x);
      })
      .always(function(){
        if (!opts.keepButtonsDisabled) {
          $btns.prop('disabled', isAncillaryInteractionLocked());
        }
        if (typeof opts.onAlways === 'function') opts.onAlways();
      });
    return request;
  }

  function deleteDevRow($tr){
    if (!$tr || !$tr.length) return;
    const rowId = parseInt($tr.attr('data-id'), 10) || 0;
    if (!embId) { notify('error','Error','Embarque inválido'); return; }
    if (!rowId) {
      $tr.remove();
      updateDevEmptyState();
      recalcDevTotals();
      return;
    }
    confirmSwal({
      text: '¿Eliminar la devolución seleccionada?',
      icon: 'warning',
      confirmButtonText: 'Sí, eliminar'
    }).then(function(ok){
      if (!ok) return;
      $.ajax({ url: joinUrl('api/operaciones/so_embarque_devoluciones.php'), method:'DELETE', contentType:'application/json; charset=utf-8', dataType:'json', data: JSON.stringify({ embarque_id: embId, row_id: rowId }) })
        .done(function(r){
          if (r && r.ok) {
            $tr.remove();
            updateDevEmptyState();
            recalcDevTotals();
            notify('success','Eliminado','La devolución fue eliminada');
            loadInvoiceCatalog().always(function(){
              loadDevoluciones();
              loadRendiciones();
            });
          } else {
            notify('error','Error', r && r.error ? r.error : 'No se pudo eliminar la devolución');
          }
        })
        .fail(function(x){
          notify('error','Error', x.responseText || x.statusText || 'Error al eliminar');
        })
        .always(function(){ applyAncillaryLockState(); });
    });
  }

  function loadDevoluciones(){
    if (!embId || !$devTable.length) return;
    $.getJSON(joinUrl('api/operaciones/so_embarque_devoluciones.php'), { embarque_id: embId })
      .done(function(r){
        $devTable.empty();
        resetDevTotalsFooter();
        if (!r || !r.ok) {
          notify('error','Error', r && r.error ? r.error : 'No se pudo cargar las devoluciones');
          updateDevEmptyState();
          applyAncillaryLockState();
          return;
        }
        registerDevConversions(r.conversions || {});
        const rows = syncDevolRowsWithInvoices(Array.isArray(r.data) ? r.data : []);
        rows.forEach(function(item){
          const $row = buildDevRow(item);
          $devTable.append($row);
        });
        updateDevEmptyState();
        recalcDevTotals();
        if (r.totals) {
          const totalUnits = Number(r.totals.total_unidades);
          const totalPicking = Number(r.totals.total_unidades_a_picking);
          if (Number.isFinite(totalUnits) || Number.isFinite(totalPicking)) {
            updateDevTotalsFooter(
              Number.isFinite(totalUnits) ? totalUnits : undefined,
              Number.isFinite(totalPicking) ? totalPicking : undefined
            );
          }
        }
        applyAncillaryLockState();
      })
      .fail(function(x){
        notify('error','Error', x.responseText || x.statusText || 'No se pudo cargar devoluciones');
        updateDevEmptyState();
        resetDevTotalsFooter();
        applyAncillaryLockState();
      });
  }

  function buildRendRow(row){
    const data = {
      id: row && row.id ? parseInt(row.id, 10) || 0 : 0,
      factura: row && row.factura ? String(row.factura) : '',
      condicion: row && row.condicion ? String(row.condicion) : '',
      fecha_factura: row && row.fecha_factura ? formatDateForInput(row.fecha_factura) : '',
      monto: row && row.monto != null ? parseFloat(row.monto) || 0 : 0,
      fecha_rendicion: row && row.fecha_rendicion ? formatDateTimeForInput(row.fecha_rendicion) : ''
    };
    if (!data.id && !data.fecha_rendicion) data.fecha_rendicion = nowLocal();

    const $tr = $('<tr>').attr('data-id', data.id);
    const mkInput = (field, value, opts={}) => {
      const $inp = $('<input>')
        .addClass('form-control form-control-sm')
        .attr('data-field', field)
        .val(value != null ? value : '');
      $inp.attr('type', opts.type || 'text');
      if (opts.placeholder) $inp.attr('placeholder', opts.placeholder);
      if (opts.min !== undefined) $inp.attr('min', opts.min);
      if (opts.step !== undefined) $inp.attr('step', opts.step);
      if (opts.maxlength) $inp.attr('maxlength', opts.maxlength);
      if (opts.className) $inp.addClass(opts.className);
      if (opts.listId) $inp.attr('list', opts.listId);
      if (opts.title) $inp.attr('title', opts.title);
      return $('<td>').append($inp);
    };

    const montoVal = Number.isFinite(data.monto) ? data.monto.toFixed(2) : '';
    const rendInvoiceMeta = invoiceMap.get(normInvoiceKey(data.factura));
    $tr.append(mkInput('factura', data.factura, {
      placeholder: 'Factura',
      maxlength: 100,
      listId: 'embarqueFacturasDatalist',
      title: rendInvoiceMeta && rendInvoiceMeta.destinatario ? rendInvoiceMeta.destinatario : ''
    }));
    $tr.append(mkInput('condicion', data.condicion, { placeholder: 'Condición', maxlength: 100 }));
    $tr.append(mkInput('fecha_factura', data.fecha_factura, { type: 'date' }));
    $tr.append(mkInput('monto', montoVal, { type: 'number', min: '0', step: '0.01', className: 'text-end' }));
    $tr.append(mkInput('fecha_rendicion', data.fecha_rendicion, { type: 'datetime-local' }));

    const $btnSave = $('<button type="button" class="btn btn-sm btn-primary btn-rend-save me-1">Guardar</button>').on('click', function(){ saveRendRow($tr); });
    const $btnDel = $('<button type="button" class="btn btn-sm btn-outline-danger btn-rend-delete">Eliminar</button>').on('click', function(){ deleteRendRow($tr); });
    const $actions = $('<td class="text-center">').append($btnSave, $btnDel);
    $tr.append($actions);

    return $tr;
  }

  function readRendRow($tr){
    const getVal = (field)=>{
      const $el = $tr.find('[data-field="'+field+'"]');
      return $el.length ? $el.val() : '';
    };
    const toFloat = (field)=>{
      const raw = String(getVal(field) || '').trim();
      if (raw === '') return null;
      const parsed = parseFloat(raw);
      return Number.isNaN(parsed) ? null : parsed;
    };
    return {
      rowId: parseInt($tr.attr('data-id'), 10) || 0,
      factura: String(getVal('factura') || '').trim(),
      condicion: String(getVal('condicion') || '').trim(),
      fecha_factura: String(getVal('fecha_factura') || '').trim() || null,
      monto: toFloat('monto'),
      fecha_rendicion: normalizeDateTimeForApi(getVal('fecha_rendicion'))
    };
  }

  function saveRendRow($tr){
    if (!$tr || !$tr.length) return;
    const payload = readRendRow($tr);
    if (!embId) { notify('error','Error','Embarque inválido'); return; }
    if (!payload.factura) { notify('warning','Validación','Debe ingresar la factura'); return; }
    const body = {
      embarque_id: embId,
      row_id: payload.rowId || null,
      data: {
        factura: payload.factura,
        condicion: payload.condicion || null,
        fecha_factura: payload.fecha_factura || null,
        monto: payload.monto != null ? payload.monto : 0,
        fecha_rendicion: payload.fecha_rendicion || normalizeDateTimeForApi(nowLocal())
      }
    };
    const $btns = $tr.find('.btn-rend-save, .btn-rend-delete');
    $btns.prop('disabled', true);
    $.ajax({ url: joinUrl('api/operaciones/so_embarque_rendiciones.php'), method:'POST', contentType:'application/json; charset=utf-8', dataType:'json', data: JSON.stringify(body) })
      .done(function(r){
        if (r && r.ok) {
          if (r.id) $tr.attr('data-id', parseInt(r.id, 10) || 0);
          $tr.find('input, select').addClass('is-valid');
          setTimeout(function(){ $tr.find('input, select').removeClass('is-valid'); }, 800);
          notify('success','Guardado','Rendición guardada');
          loadInvoiceCatalog().always(function(){
            loadRendiciones();
            loadDevoluciones();
          });
        } else {
          notify('error','Error', r && r.error ? r.error : 'No se pudo guardar la rendición');
        }
      })
      .fail(function(x){
        notify('error','Error', x.responseText || x.statusText || 'Error al guardar rendición');
      })
      .always(function(){
        $btns.prop('disabled', isAncillaryInteractionLocked());
      });
  }

  function deleteRendRow($tr){
    if (!$tr || !$tr.length) return;
    const rowId = parseInt($tr.attr('data-id'), 10) || 0;
    if (!embId) { notify('error','Error','Embarque inválido'); return; }
    if (!rowId) {
      $tr.remove();
      updateRendEmptyState();
      return;
    }
    confirmSwal({
      text: '¿Eliminar la rendición seleccionada?',
      icon: 'warning',
      confirmButtonText: 'Sí, eliminar'
    }).then(function(ok){
      if (!ok) return;
      $.ajax({ url: joinUrl('api/operaciones/so_embarque_rendiciones.php'), method:'DELETE', contentType:'application/json; charset=utf-8', dataType:'json', data: JSON.stringify({ embarque_id: embId, row_id: rowId }) })
        .done(function(r){
          if (r && r.ok) {
            $tr.remove();
            updateRendEmptyState();
            notify('success','Eliminado','La rendición fue eliminada');
            loadInvoiceCatalog().always(function(){
              loadRendiciones();
              loadDevoluciones();
            });
          } else {
            notify('error','Error', r && r.error ? r.error : 'No se pudo eliminar la rendición');
          }
        })
        .fail(function(x){
          notify('error','Error', x.responseText || x.statusText || 'Error al eliminar rendición');
        })
        .always(function(){ applyAncillaryLockState(); });
    });
  }

  function loadRendiciones(){
    if (!embId || !$rendTable.length) return;
    $.getJSON(joinUrl('api/operaciones/so_embarque_rendiciones.php'), { embarque_id: embId })
      .done(function(r){
        $rendTable.empty();
        if (!r || !r.ok) {
          notify('error','Error', r && r.error ? r.error : 'No se pudo cargar las rendiciones');
          updateRendEmptyState();
          applyAncillaryLockState();
          return;
        }
        const rows = syncRendRowsWithInvoices(Array.isArray(r.data) ? r.data : []);
        rows.forEach(function(item){
          const $row = buildRendRow(item);
          $rendTable.append($row);
        });
        updateRendEmptyState();
        applyAncillaryLockState();
      })
      .fail(function(x){
        notify('error','Error', x.responseText || x.statusText || 'No se pudo cargar rendiciones');
        updateRendEmptyState();
        applyAncillaryLockState();
      });
  }

  if ($btnDevAdd.length) {
    $btnDevAdd.on('click', function(){
      if (isAncillaryInteractionLocked()) return;
      const $row = buildDevRow({ id: 0, factura: '', sku: '', pallets: 0, cajas_sueltas: 0, unidades_sueltas: 0, unidades_danadas: 0, motivo: '', lote: '' });
      $devTable.append($row);
      updateDevEmptyState();
      applyAncillaryLockState();
      recalcDevTotals();
      const $firstEditable = $row.find('[data-field="sku"], input[data-field]').filter(':enabled').first();
      if ($firstEditable.length) $firstEditable.focus();
    });
  }

  const DEV_QTY_FIELDS = ['pallets','cajas_sueltas','unidades_sueltas','unidades_danadas'];

  $devTable.on('input change', 'input[data-field]', function(){
    const field = $(this).attr('data-field');
    if (!field) return;
    if (!DEV_QTY_FIELDS.includes(field)) return;
    const $row = $(this).closest('tr');
    updateDevRowTotalsFromInputs($row);
    recalcDevTotals();
  });

  $devTable.on('change', '[data-field="sku"]', function(){
    const $field = $(this);
    const sku = String($field.val() || '').trim();
    applySkuToRow($field.closest('tr'), sku);
  });

  if ($btnRendAdd.length) {
    $btnRendAdd.on('click', function(){
      if (isAncillaryInteractionLocked()) return;
      const $row = buildRendRow({ id: 0, factura: '', condicion: '', fecha_factura: '', monto: 0, fecha_rendicion: nowLocal() });
      $rendTable.append($row);
      updateRendEmptyState();
      applyAncillaryLockState();
      const $factura = $row.find('input[data-field="factura"]');
      if ($factura.length) $factura.focus();
    });
  }

  $rendTable.on('change', 'input[data-field="factura"]', function(){ updateInvoiceDisplayMeta($(this)); });

  updateDevEmptyState();
  updateRendEmptyState();
  applyAncillaryLockState();

  // Cargar embarque; los catálogos se poblarán según necesidad
  loadEmb();

  // ======================================================
  // Seguimiento por Destinatario (tabla tipo DataTable)
  // ======================================================
  function initSegDataTable(){
    if (!$segTbl.length) return;
    if ($.fn.DataTable) {
      // Destruir si existe
      if (segDT) { segDT.destroy(); segDT = null; }
      segDT = $segTbl.DataTable({
        paging: false,
        searching: true,
        info: false,
        order: [],
        language: { url: window.DT_LANG_ES_URL || undefined },
        dom: 'Bfrtip',
        buttons: (window.DataTable && window.DataTable.Buttons) ? ['copy', 'excel', 'csv', 'print'] : []
      });
    }
  }

  function hhmmNow(){
    const d = new Date();
    const p = (n)=> String(n).padStart(2,'0');
    return p(d.getHours())+':'+p(d.getMinutes());
  }
  function isValidHHMM(s){ return /^(\d{1,2}):(\d{2})$/.test(String(s||'').trim()); }
  function parseHHMM(s){
    if (!isValidHHMM(s)) return 0;
    const m = String(s).trim().match(/^(\d{1,2}):(\d{2})$/);
    const h = parseInt(m[1],10)||0; const mi = parseInt(m[2],10)||0; return h*60 + mi;
  }
  function fmtHHMM(mins){
    const m = Math.max(0, parseInt(mins,10)||0);
    const h = Math.floor(m/60); const mi = m%60;
    return String(h).padStart(2,'0')+':'+String(mi).padStart(2,'0');
  }
  function diffToHHMM(later, earlier){
    if (!isValidHHMM(later) || !isValidHHMM(earlier)) return '';
    const d = Math.max(0, parseHHMM(later) - parseHHMM(earlier));
    return fmtHHMM(d);
  }
  function calcAndRenderSegTotals(){
    let filas=0, tEspera=0, tDesc=0, tCtrl=0, tTot=0;
    $segTBody.find('tr').each(function(){
      filas++;
      const g = (name)=> $(this).find('input[data-field="'+name+'"]').val();
      // Preferir cálculo on-the-fly desde horas base; si no son válidas, caer al valor del campo derivado
      const esperaCalc = diffToHHMM(g('hr_inicio'), g('hr_llegada'));
      const descCalc   = diffToHHMM(g('hr_termino'), g('hr_inicio'));
      const ctrlCalc   = diffToHHMM(g('hr_salida'), g('hr_termino'));
      const totCalc    = diffToHHMM(g('hr_salida'), g('hr_llegada'));
      const espera = isValidHHMM(esperaCalc) ? esperaCalc : g('espera_desc');
      const desc   = isValidHHMM(descCalc)   ? descCalc   : g('tiempo_desc');
      const ctrl   = isValidHHMM(ctrlCalc)   ? ctrlCalc   : g('tiempo_ctrl');
      const total  = isValidHHMM(totCalc)    ? totCalc    : g('tiempo_total');
      tEspera += parseHHMM(espera);
      tDesc   += parseHHMM(desc);
      tCtrl   += parseHHMM(ctrl);
      tTot    += parseHHMM(total);
    });
    $('#segTotGeneral').text(filas);
    $('#segTotEspera').text(fmtHHMM(tEspera));
    $('#segTotDesc').text(fmtHHMM(tDesc));
    $('#segTotCtrl').text(fmtHHMM(tCtrl));
    $('#segTotTiempo').text(fmtHHMM(tTot));
  }
  function recalcRowDerived($tr){
    const g = (name)=> $tr.find('input[data-field="'+name+'"]').val();
    const set = (name,val)=> $tr.find('input[data-field="'+name+'"]').val(val).trigger('input');
    // espera = hr_inicio - hr_llegada
    const espera = diffToHHMM(g('hr_inicio'), g('hr_llegada'));
    if (espera !== '') set('espera_desc', espera);
  // descarga = hr_termino - hr_inicio
  const desc = diffToHHMM(g('hr_termino'), g('hr_inicio'));
  if (desc !== '') set('tiempo_desc', desc);
  // control = hr_salida - hr_termino
    const ctrl = diffToHHMM(g('hr_salida'), g('hr_termino'));
    if (ctrl !== '') set('tiempo_ctrl', ctrl);
    // total = hr_salida - hr_llegada
    const total = diffToHHMM(g('hr_salida'), g('hr_llegada'));
    if (total !== '') set('tiempo_total', total);
  }

  function loadSeguimiento(){
    if (!embId) return;
    $.getJSON(joinUrl('api/operaciones/so_embarque_tracking_destinos.php'), { embarque_id: embId })
      .done(function(r){
        $segTBody.empty();
        if (!r || !r.ok) return;
        const rows = Array.isArray(r.data) ? r.data : [];
        rows.forEach(function(x){
          const tr = $('<tr>');
          // helpers de inputs
          const mk = (field, val, opts={})=>{
            const $inp = $('<input type="text" class="form-control form-control-sm seg-input" />')
              .attr('data-dest-id', x.destinatario_id)
              .attr('data-field', field)
              .val(val==null?'':val);
            if (opts.placeholder) $inp.attr('placeholder', opts.placeholder);
            if (opts.className) $inp.addClass(opts.className);
            if (opts.readonly) $inp.prop('readonly', true).addClass('bg-light');
            let $td = $('<td>').append($inp);
            if (opts.nowBtn) {
              const $btn = $('<button type="button" class="btn btn-sm btn-outline-secondary seg-now">Ahora</button>')
                .on('click', function(){ $inp.val(hhmmNow()).trigger('input').trigger('blur'); });
              $td.append($btn);
            }
            return $td;
          };

          tr.append($('<td>').text(x.facturas || ''));
          tr.append($('<td>').text(x.cliente_final || ''));
          tr.append(mk('inicio_carga', x.inicio_carga, {placeholder:'hh:mm', className:'w-time', nowBtn:true}));
          tr.append(mk('fin_carga', x.fin_carga, {placeholder:'hh:mm', className:'w-time', nowBtn:true}));
          tr.append(mk('km_inicial', x.km_inicial, {className:'w-km'}));
          tr.append(mk('km_llegada', x.km_llegada, {className:'w-km'}));
          tr.append(mk('hr_llegada', x.hr_llegada, {placeholder:'hh:mm', className:'w-time', nowBtn:true}));
          tr.append(mk('hr_inicio', x.hr_inicio, {placeholder:'hh:mm', className:'w-time', nowBtn:true}));
          tr.append(mk('espera_desc', x.espera_desc, {className:'w-time', readonly:true}));
          tr.append(mk('hr_termino', x.hr_termino, {placeholder:'hh:mm', className:'w-time', nowBtn:true}));
          tr.append(mk('tiempo_desc', x.tiempo_desc, {className:'w-time', readonly:true}));
          tr.append(mk('hr_salida', x.hr_salida, {placeholder:'hh:mm', className:'w-time', nowBtn:true}));
          tr.append(mk('tiempo_ctrl', x.tiempo_ctrl, {className:'w-time', readonly:true}));
          tr.append(mk('tiempo_total', x.tiempo_total, {className:'w-time', readonly:true}));
          tr.append(mk('tipo_carga', x.tipo_carga));
          tr.append(mk('salida_camara', x.salida_camara));
          tr.append(mk('temp_carga_c', x.temp_carga_c, {className:'w-temp'}));
          tr.append(mk('temp_desc_c', x.temp_desc_c, {className:'w-temp'}));
          tr.append(mk('aviso_quien', x.aviso_quien));
          tr.append(mk('aviso_hora', x.aviso_hora, {placeholder:'hh:mm', className:'w-time', nowBtn:true}));
          tr.append(mk('problema', x.problema));
          
          $segTBody.append(tr);
        });
        // calcular campos derivados por fila y totales globales antes de inicializar DataTables
        $segTBody.find('tr').each(function(){ recalcRowDerived($(this)); });
        calcAndRenderSegTotals();
        initSegDataTable();
      });
  }

  // Guardado automático al salir del input con debounce
  const debouncers = {};
  function debounceSave(key, fn){
    if (debouncers[key]) clearTimeout(debouncers[key]);
    debouncers[key] = setTimeout(fn, 350);
  }
  $segTBody.on('input blur', '.seg-input', function(){
    const $inp = $(this);
    const field = $inp.attr('data-field');
    const destId = parseInt($inp.attr('data-dest-id'),10)||0;
    const value = $inp.val();
    if (!destId || !field) return;
    const key = destId+'_'+field;
    debounceSave(key, function(){
      $.ajax({ url: joinUrl('api/operaciones/so_embarque_tracking_save.php'), method:'POST', contentType:'application/json; charset=utf-8', dataType:'json', data: JSON.stringify({ embarque_id: embId, destinatario_id: destId, field, value }) })
        .done(function(r){ if (r && r.ok) { $inp.addClass('is-valid'); setTimeout(()=> $inp.removeClass('is-valid'), 800); } else { $inp.addClass('is-invalid'); } })
        .fail(function(){ $inp.addClass('is-invalid'); });
    });
    // Si cambian horas base, recalcular derivados en la fila
    if (['hr_llegada','hr_inicio','hr_termino','hr_salida'].includes(field)) {
      recalcRowDerived($inp.closest('tr'));
    }
    // Recalcular totales globales en cada edición
    calcAndRenderSegTotals();
  });

  // Botones de exportar/imprimir (fallback si no hay DataTables Buttons)
  $('#btnSegExport').on('click', function(){
    if (segDT && segDT.button) {
      try { segDT.button('.buttons-excel').trigger(); return; } catch(e) {}
      try { segDT.button('.buttons-csv').trigger(); return; } catch(e) {}
    }
    // Fallback CSV simple
    const rows = [];
    $segTbl.find('thead tr th').each(function(){ rows.push('"'+($(this).text().trim().replace(/"/g,'""'))+'"'); });
    let csv = rows.join(',') + '\n';
    $segTbl.find('tbody tr').each(function(){
      const r = [];
      $(this).find('td').each(function(){
        const t = $(this).find('input').length ? $(this).find('input').val() : $(this).text();
        r.push('"'+(String(t).trim().replace(/"/g,'""'))+'"');
      });
      csv += r.join(',') + '\n';
    });
    const blob = new Blob([csv], { type: 'text/csv;charset=utf-8;' });
    const url = URL.createObjectURL(blob);
    const a = document.createElement('a');
    a.href = url; a.download = 'seguimiento_destinatarios.csv'; a.click();
    URL.revokeObjectURL(url);
  });
  $('#btnSegPrint').on('click', function(){
    if (segDT && segDT.button) {
      try { segDT.button('.buttons-print').trigger(); return; } catch(e) {}
    }
    window.print();
  });
});
