$(function(){
  const BASE = typeof window !== 'undefined' && window.BASE_URL ? window.BASE_URL : '/';
  const joinUrl = (p) => (BASE.endsWith('/') ? BASE : BASE + '/') + p.replace(/^\/+/,'');

  const tableId = 'embarquesTable';
  const ajaxUrl = joinUrl('api/operaciones/so_embarque_list.php');

  const columns = [
    { data: null, defaultContent:'', className:'select-checkbox', orderable:false, searchable:false, title:'', width:'20px' },
    { data: 'accion', title:'Acción', orderable:false, render: (_v,_t,row)=>{
        const id = row?.embarque?.id; if(!id) return '';
        return `<a class="btn btn-sm btn-primary" href="${joinUrl('salidas/embarque/detalle')}?embarque_id=${id}">Abrir</a>`;
      }
    },
    { data: 'embarque.codigo', title:'Código' },
    { data: 'embarque.estado', title:'Estado' },
    { data: 'embarque.creado_at', title:'Creado' },
    { data: 'kpi.pre_count', title:'PREs', className:'text-end' },
    { data: 'kpi.paradas', title:'Paradas', className:'text-end' },
  ];

  const $table = $('#'+tableId);
  if ($table.find('thead').length === 0) {
    let thead = '<thead><tr>';
    columns.forEach(c=> thead += `<th>${c.title||''}</th>`);
    thead += '</tr></thead>';
    $table.prepend(thead);
  }

  initializeBaseDataTable({ tableId, ajaxUrl, columns, buttons:['excel','csv','pdf'], select:{style:'os', selector:'td.select-checkbox'}, order:[[4,'desc']] });
});
