// public/page-scripts/pages/salidas/packing_scripts.js
// Clone of ingresos/packing_scripts.js switching endpoints from pl_* to so_*
(function (window, $) {
  "use strict";

  const baseUrl =
    document.querySelector('meta[name="base-url"]')?.getAttribute("content") ||
    (typeof window.BASE_URL !== "undefined" ? window.BASE_URL : "/");

  function joinUrl(p) {
    const b = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
    return b + String(p || "").replace(/^\/+/, "");
  }

  function notify(type, title, text) {
    if (window.Swal) {
      const icon = type === "error" ? "error" : type === "success" ? "success" : "info";
      window.Swal.fire({ icon, title, text, timer: 2600, showConfirmButton: false });
    } else {
      const prefix = type === "error" ? "ERROR: " : type === "success" ? "OK: " : "";
      alert(prefix + (title ? title + " - " : "") + (text || ""));
    }
  }

  function isNumeric(val) {
    return typeof val === "number" || (!!val && !isNaN(val));
  }

  function formatNumber(n) {
    if (!isNumeric(n)) return n;
    const parts = String(Math.trunc(Number(n))).split("");
    let out = "", cnt = 0;
    while (parts.length) {
      out = parts.pop() + out;
      cnt++;
      if (parts.length && cnt % 3 === 0) out = "." + out;
    }
    return out;
  }

  function sumColumn(api, colIdx) {
    let total = 0;
    api
      .column(colIdx, { page: "current" })
      .data()
      .each(function (v) {
        const num = typeof v === "string" ? Number(v.replace(/\./g, "").replace(",", ".")) : Number(v);
        if (!isNaN(num)) total += num;
      });
    return total;
  }

  let currentBatch = null;
  let dtPreview = null;
  let dtItems = null;
  let lastSOId = null; // SO confirmado para 'Ver detalle'

  const $form = $("#frmUploadPL");
  const $btnConfirm = $("#btnConfirmPL");
  const $tblPreview = $("#tblPL");
  const $cardsHost = $("#plSummaryCardsHost");

  function getPreviewCard() {
    return $tblPreview.length ? $tblPreview.closest(".card") : $();
  }

  function buildPreviewTable(columns, data) {
    if (!$tblPreview.length) return;
    const $card = getPreviewCard();
    if ($card.length) $card.show();

    if (dtPreview) { dtPreview.clear(); dtPreview.destroy(true); dtPreview = null; }

    const cols = Array.isArray(columns) ? columns : [];
    const theadHtml =
      "<tr>" + cols.map(c => `<th>${(c.title || c.data || "").toString()}</th>`).join("") + "</tr>";

    if ($tblPreview.find("thead").length === 0) $tblPreview.prepend("<thead></thead>");
    $tblPreview.find("thead").html(theadHtml);

    if ($tblPreview.find("tbody").length === 0) $tblPreview.append("<tbody></tbody>");
    else $tblPreview.find("tbody").empty();

    const dtCols = cols.map((c) => ({
      data: c.data,
      title: c.title || c.data,
      render: function (val, type) {
        if (c.type === "number") {
          if (type === "display" || type === "filter") return formatNumber(val);
        }
        return val;
      },
    }));

    dtPreview = $tblPreview.DataTable({
      data: Array.isArray(data) ? data : [],
      columns: dtCols,
      deferRender: true,
      paging: true,
      pageLength: 25,
      order: [],
      language: { url: "https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json" },
      footerCallback: function () {
        if ($tblPreview.find("tfoot").length === 0) {
          const tfoot = document.createElement("tfoot");
          const tr = document.createElement("tr");
          for (let i = 0; i < dtCols.length; i++) tr.appendChild(document.createElement("th"));
          tfoot.appendChild(tr);
          $tblPreview.append(tfoot);
        }
        const api = this.api();
        dtCols.forEach((c, idx) => {
          let text = "";
          if (c.type === "number") {
            const total = sumColumn(api, idx);
            text = formatNumber(total);
          }
          $(api.column(idx).footer()).html(text);
        });
      },
    });
  }

  // (sin tabla de "Movimientos" en Salidas)

  // -------------------------
  // Modal de detalle (SO) - creación perezosa
  // -------------------------
  function ensureItemsModal() {
    if (document.getElementById("soItemsModal")) return;

    const html = `
<div class="modal fade" id="soItemsModal" tabindex="-1" aria-labelledby="soItemsModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="soItemsModalLabel"><i class="fa-solid fa-list me-2"></i>Detalle de la orden de salida</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <div class="table-responsive">
          <table id="tblSOItems" class="table table-striped w-100">
            <thead><tr></tr></thead>
            <tbody></tbody>
            <tfoot></tfoot>
          </table>
        </div>
      </div>
      <div class="modal-footer">
        <small class="text-muted me-auto" id="soItemsCaption"></small>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>`;
    document.body.insertAdjacentHTML("beforeend", html);

    // tema oscuro
    const applyModalTheme = () => {
      const modalEl = document.getElementById("soItemsModal");
      if (!modalEl) return;
      const table = modalEl.querySelector('#tblSOItems');
      const modalContent = modalEl.querySelector('.modal-content');
      const btnClose = modalEl.querySelector('.btn-close');
      const caption = modalEl.querySelector('#soItemsCaption');

      if (typeof isDarkMode === 'function' && isDarkMode()) {
        if (table && !table.classList.contains('table-dark')) table.classList.add('table-dark');
        if (modalContent) modalContent.classList.add('bg-dark', 'text-white');
        if (btnClose) btnClose.classList.add('btn-close-white');
        if (caption) { caption.classList.remove('text-muted'); caption.classList.add('text-light'); }
      } else {
        if (table) table.classList.remove('table-dark');
        if (modalContent) modalContent.classList.remove('bg-dark', 'text-white');
        if (btnClose) btnClose.classList.remove('btn-close-white');
        if (caption) { caption.classList.remove('text-light'); caption.classList.add('text-muted'); }
      }
    };

    applyModalTheme();
    const modalEl = document.getElementById("soItemsModal");
    if (modalEl) modalEl.addEventListener('show.bs.modal', applyModalTheme);
  }

  function openItemsModal(soId) {
    if (!soId) return notify("error", "Detalle", "No hay una salida consolidada para ver.");
    ensureItemsModal();

    const $modal = $("#soItemsModal");
    const $tbl = $("#tblSOItems");
    const $caption = $("#soItemsCaption");

    if (dtItems) { dtItems.clear(); dtItems.destroy(true); dtItems = null; }
    $tbl.find("thead tr").empty();
    $tbl.find("tbody").empty();
    $tbl.find("tfoot").empty();

    $.ajax({
      url: joinUrl(`api/operaciones/so_items.php`),
      method: "GET",
      dataType: "json",
      data: { so_id: soId },
    })
      .done(function (res) {
        if (!res || res.ok !== true) {
          const msg = (res && (res.message || res.error)) || "No se pudo cargar el detalle";
          return notify("error", "Detalle", msg);
        }

        $("#soItemsModalLabel").text(`Detalle de la salida ${res.so?.codigo || `#${soId}`}`);
        $caption.text(`${res.so?.cliente_ref || ""} · Fecha: ${res.so?.fecha || ""}`);

        const cols = Array.isArray(res.columns) ? res.columns : [];
        const theadHtml = "<tr>" + cols.map(c => `<th>${(c.title || c.data || "").toString()}</th>`).join("") + "</tr>";
        $tbl.find("thead").html(theadHtml);
        if ($tbl.find("tbody").length === 0) $tbl.append("<tbody></tbody>");
        if ($tbl.find("tfoot").length === 0) {
          const tf = document.createElement("tfoot");
          const tr = document.createElement("tr");
          for (let i = 0; i < cols.length; i++) tr.appendChild(document.createElement("th"));
          tf.appendChild(tr);
          $tbl.append(tf);
        }

        const dtCols = cols.map((c) => ({
          data: c.data,
          title: c.title || c.data,
          render: function (val, type) {
            if (c.type === "number") {
              if (type === "display" || type === "filter") return formatNumber(val);
            }
            return val;
          },
        }));

        dtItems = $tbl.DataTable({
          data: Array.isArray(res.data) ? res.data : [],
          columns: dtCols,
          deferRender: true,
          paging: true,
          pageLength: 25,
          order: [],
          language: { url: "https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json" },
          footerCallback: function () {
            const api = this.api();
            dtCols.forEach((c, idx) => {
              let text = "";
              if (c.type === "number") {
                const total = sumColumn(api, idx);
                text = formatNumber(total);
              }
              $(api.column(idx).footer()).html(text);
            });
          },
        });

        // ajustes de tema tras render DT
        (function enforceModalThemeAfterDT() {
          const modalEl2 = document.getElementById('soItemsModal');
          if (!modalEl2) return;
          const table2 = modalEl2.querySelector('#tblSOItems');
          const modalContent2 = modalEl2.querySelector('.modal-content');
          const btnClose2 = modalEl2.querySelector('.btn-close');
          const caption2 = modalEl2.querySelector('#soItemsCaption');

          if (typeof isDarkMode === 'function' && isDarkMode()) {
            if (table2 && !table2.classList.contains('table-dark')) table2.classList.add('table-dark');
            if (modalContent2) modalContent2.classList.add('bg-dark', 'text-white');
            if (btnClose2) btnClose2.classList.add('btn-close-white');
            if (caption2) { caption2.classList.remove('text-muted'); caption2.classList.add('text-light'); }
            const wrapper = table2 ? table2.closest('.dataTables_wrapper') : null;
            if (wrapper) wrapper.classList.add('bg-dark', 'text-white');
          } else {
            if (table2) table2.classList.remove('table-dark');
            if (modalContent2) modalContent2.classList.remove('bg-dark', 'text-white');
            if (btnClose2) btnClose2.classList.remove('btn-close-white');
            if (caption2) { caption2.classList.remove('text-light'); caption2.classList.add('text-muted'); }
            const wrapper = table2 ? table2.closest('.dataTables_wrapper') : null;
            if (wrapper) wrapper.classList.remove('bg-dark', 'text-white');
          }
        })();

        const modal = new window.bootstrap.Modal(document.getElementById("soItemsModal"));
        modal.show();
      })
      .fail(function (jqXHR) {
        const j = jqXHR.responseJSON || {};
        const msg = j.message || j.error || "Error de comunicación";
        notify("error", "Detalle", msg);
      });
  }

  function insertGoToPreparacionButton() {
    const $container = $btnConfirm.parent();
    if (!$container.length) return;
    if ($container.find("#btnGoToPreparacion").length) return;

    const $btn = $(`
      <button type="button" id="btnGoToPreparacion" class="btn btn-primary ms-2">
        <i class="bi bi-arrow-right-circle me-1"></i> Ir a Preparación
      </button>
    `);
    $btn.on("click", function () {
      if (!lastSOId) {
        return notify("error", "Preparación", "Aún no hay una salida consolidada para preparar.");
      }
      // Redirigir a la página de preparación con el ID del pedido
      const preparacionUrl = joinUrl(`salidas/preparacion?so_id=${lastSOId}`);
      window.location.href = preparacionUrl;
    });

    $container.append($btn);
  }

  function loadPreview(batchId) {
    $.ajax({
      url: joinUrl("api/operaciones/so_preview.php"),
      method: "GET",
      dataType: "json",
      data: { batch_id: batchId },
    })
      .done(function (res) {
        if (!res || res.ok !== true) {
          const msg = (res && (res.message || res.error)) || "No se pudo cargar la previsualización";
          $btnConfirm.prop("disabled", true);
          return notify("error", "Previsualización", msg);
        }
        const columns = Array.isArray(res.columns) ? res.columns : [];
        const data = Array.isArray(res.data) ? res.data : [];
        buildPreviewTable(columns, data);
        // Info de batch
        const infoText = res.filename
          ? `${res.filename} · Total: ${res.rows_total||0} · OK: ${res.rows_ok||0} · Error: ${res.rows_error||0}`
          : `Total: ${res.rows_total||0} · OK: ${res.rows_ok||0} · Error: ${res.rows_error||0}`;
        $("#pl-batch-info").text(infoText);
        const hasErrors = Number(res.rows_error || 0) > 0 || data.some(r => String(r.error||"").trim() !== "");
        $btnConfirm.prop("disabled", hasErrors);
        const $host = getPreviewCard().find('.card-body .d-flex.justify-content-between').length
          ? getPreviewCard().find('.card-body .d-flex.justify-content-between')
          : getPreviewCard().find('.card-body');
        // CSV de errores
        const $csvBtn = $("#pl-errors-csv");
        if (hasErrors) {
          if (!$host.find('#pl-error-badge').length) {
            $host.append('<span id="pl-error-badge" class="badge bg-danger ms-2">Hay filas con error</span>');
          }
          // Construir CSV on-the-fly
          const headers = columns.map(c=>c.title);
          const rows = data.filter(r => String(r.error||"").trim() !== "").map(r => headers.map(h => {
            const key = (columns.find(c=>c.title===h)||{}).data;
            return String(r[key] ?? '').replaceAll('"','""');
          }));
          const csv = [headers.join(','), ...rows.map(r => '"' + r.join('","') + '"')].join('\n');
          const blob = new Blob([csv], { type: 'text/csv;charset=utf-8;' });
          const url = URL.createObjectURL(blob);
          $csvBtn.attr('href', url).removeClass('d-none');
        } else {
          $host.find('#pl-error-badge').remove();
          $("#pl-errors-csv").addClass('d-none').removeAttr('href');
        }
      })
      .fail(function (jqXHR) {
        const j = jqXHR.responseJSON || {};
        const msg = j.message || j.error || "Error de comunicación";
        $btnConfirm.prop("disabled", true);
        notify("error", "Previsualización", msg);
      });
  }

  $form.on("submit", function (e) {
    e.preventDefault();

    const fd = new FormData(this);
    const clienteId = String($("#cliente_id").val() || "").trim();
    if (!clienteId) {
      return notify("error", "Validación", "Debe seleccionar un cliente.");
    }

    $.ajax({
      url: joinUrl("api/operaciones/so_upload.php"),
      method: "POST",
      data: fd,
      processData: false,
      contentType: false,
      dataType: "json",
    })
      .done(function (res) {
        if (!res || res.ok !== true) {
          const msg = (res && (res.message || res.error)) || "No se pudo importar el archivo";
          $btnConfirm.prop("disabled", true);
          return notify("error", "Importación", msg);
        }
        currentBatch = res.batch_id || res.batch || null;
        if (!currentBatch) {
          $btnConfirm.prop("disabled", true);
          return notify("error", "Batch inválido", "El servidor no devolvió un batch_id válido.");
        }
        loadPreview(currentBatch);
      })
      .fail(function (jqXHR) {
        const j = jqXHR.responseJSON || {};
        const msg = j.message || j.error || "Error de comunicación";
        $btnConfirm.prop("disabled", true);
        notify("error", "Importación", msg);
      });
  });

  $btnConfirm.on("click", function () {
    const clienteId = String($("#cliente_id").val() || "").trim();
    if (!clienteId) {
      return notify("error", "Validación", "Debe seleccionar un cliente.");
    }

    const payload = {
      batch_id: currentBatch,
      cliente_id: clienteId,
    };

    $.ajax({
      url: joinUrl("api/operaciones/so_confirm_commit.php"),
      method: "POST",
      dataType: "json",
      data: payload,
    })
      .done(function (res) {
        if (!res || res.ok !== true) {
          const msg = (res && (res.message || res.error)) || "No se pudo confirmar la salida";
          return notify("error", "Confirmación", msg);
        }
        // Puede devolver múltiples pedidos agrupados por pre_embarque
        const pedidos = Array.isArray(res.pedidos) ? res.pedidos : (res.so_id ? [{ so_id: res.so_id, codigo: res.codigo, fecha: res.fecha }] : []);
        lastSOId = (pedidos[0] && pedidos[0].so_id) ? pedidos[0].so_id : (res.so_id || null);

        // Deshabilitar confirmar + badge
        $btnConfirm.prop("disabled", true).addClass("disabled");
        if (!$btnConfirm.next(".badge").length) {
          $btnConfirm.after('<span class="badge bg-success ms-2">Confirmado</span>');
        }

        // Botón "Ir a Preparación"
        insertGoToPreparacionButton();

        if (pedidos.length > 1) {
          const codes = pedidos.map(p => p.codigo || ('#'+p.so_id)).join(', ');
          notify("success", "Pedidos confirmados", `${pedidos.length} pedidos: ${codes}`);
        } else {
          notify("success", "Pedido confirmado", `SO #${lastSOId || "-"} consolidado.`);
        }
      })
      .fail(function (jqXHR) {
        const j = jqXHR.responseJSON || {};
        const msg = j.message || j.error || "Error de comunicación";
        notify("error", "Confirmación", msg);
      });
  });

})(window, jQuery);
