// public/page-scripts/pages/salidas/preparacion_scripts.js
// Stub: muestra los ítems del pedido para comenzar la preparación

$(document).ready(function(){
  const BASE = typeof window !== 'undefined' && window.BASE_URL ? window.BASE_URL : '/';
  const joinUrl = (p) => (BASE.endsWith('/') ? BASE : BASE + '/') + p.replace(/^\/+/, '');

  // SweetAlert2 helpers (fallback to native if unavailable)
  function notify(icon, title, text, opts){
    if (window.Swal && Swal.fire) return Swal.fire(Object.assign({ icon, title, text, confirmButtonText: 'OK' }, opts||{}));
    alert((title?title+': ':'') + (text||''));
  }
  function askConfirm(title, text, icon='question', confirmText='Sí', cancelText='Cancelar'){
    if (window.Swal && Swal.fire) {
      return Swal.fire({ title, text, icon, showCancelButton:true, confirmButtonText:confirmText, cancelButtonText:cancelText });
    }
    const ok = confirm(text||title||'¿Confirmar?');
    return Promise.resolve({ isConfirmed: !!ok });
  }
  function showLoading(title='Procesando...', text='Por favor espere'){
    if (window.Swal && Swal.fire) return Swal.fire({ title, text, allowOutsideClick:false, showConfirmButton:false, didOpen:()=>Swal.showLoading() });
  }
  function closeLoading(){ if (window.Swal && Swal.close) try{ Swal.close(); }catch(e){} }

  const root = document.getElementById('soPrep');
  if (!root) return;
  const soId = parseInt(root.getAttribute('data-so-id'), 10);
  const isAdmin = (root.getAttribute('data-is-admin') === '1');
  const $tbl = $('#tblPrepItems');
  const $btnFefo = $('#btnFefoAuto');
  const $btnDoc = $('#btnDoc');
  const $btnMovsPdf = $('#btnMovsPdf');
  const $btnReposPdf = $('#btnReposPdf');
  const $btnStartRepos = $('#btnStartRepos');
  const $btnConfirmRepos = $('#btnConfirmRepos');
  const $btnConfirm = $('#btnConfirm');
  const $btnMovs = $('#btnMovs');
  const $chkUcToUv = $('#chkUcToUv');
  const $chkUvToUc = $('#chkUvToUc');
  // Paso 5 UI
  const $prepRespId = $('#prepRespId');
  const $prepObs = $('#prepObs');
  const $prepFoto = $('#prepFoto');
  const $btnAsignarPrep = $('#btnAsignarPrep');
  const $btnInicioPrep = $('#btnInicioPrep');
  const $btnFinPrep = $('#btnFinPrep');
  const $prepStatus = $('#prepStatus');
  // Control block
  const $ctrlRespId = $('#ctrlRespId');
  const $ctrlObs = $('#ctrlObs');
  const $ctrlFoto = $('#ctrlFoto');
  const $btnAsignarCtrl = $('#btnAsignarCtrl');
  const $btnInicioCtrl = $('#btnInicioCtrl');
  const $btnFinCtrl = $('#btnFinCtrl');
  const $ctrlStatus = $('#ctrlStatus');
  const $errorMotivoId = $('#errorMotivoId');
  const $errorRespId = $('#errorRespId');
  const $errorRespNombre = $('#errorRespNombre');
  const $errorFecha = $('#errorFecha');
  const $errorObservacion = $('#errorObservacion');
  const $btnGuardarError = $('#btnGuardarError');
  const $btnLimpiarError = $('#btnLimpiarError');
  const $btnRefreshErrores = $('#btnRefreshErrores');
  const $tblErrores = $('#tblErrores');
  let erroresTable = null;
  let movsTable = null;
  let currentPreId = null;
  // Flag para mostrar alerta de faltantes tras ejecutar Plan FEFO
  window.__showShortageAfterFefo = window.__showShortageAfterFefo || false;
  const urlParams = new URLSearchParams(window.location.search);
  const debugFlag = urlParams.get('debug') === '1' || urlParams.get('debug') === 'true';
  const simulateFlag = urlParams.get('simulate') === '1' || urlParams.get('simulate') === 'true';
  const directFlag = urlParams.get('direct') === '1' || urlParams.get('direct') === 'true';
  const candsParam = urlParams.get('cands');
  const itersParam = urlParams.get('iters');

  // Persistencia simple para el check UC→UV
  const UC_KEY = 'so_prep_uc_to_uv_v1';
  try {
    const saved = localStorage.getItem(UC_KEY);
    if (saved === '1') $chkUcToUv.prop('checked', true);
  } catch(e){}
  $chkUcToUv.on('change', function(){
    try { localStorage.setItem(UC_KEY, $(this).is(':checked') ? '1' : '0'); } catch(e){}
  });

  // Persistencia simple para el check UV→UC
  const UV_UC_KEY = 'so_prep_uv_to_uc_v1';
  try {
    const saved = localStorage.getItem(UV_UC_KEY);
    if (saved === '1') $chkUvToUc.prop('checked', true);
  } catch(e){}
  $chkUvToUc.on('change', function(){
    try { localStorage.setItem(UV_UC_KEY, $(this).is(':checked') ? '1' : '0'); } catch(e){}
  });

  // Advanced settings (admin-only) - localStorage persistence
  const ADV_KEY = 'so_prep_adv_settings_v1';
  function loadAdvPrefs(){
    try { const raw = localStorage.getItem(ADV_KEY); return raw ? JSON.parse(raw) : {}; } catch(e){ return {}; }
  }
  function saveAdvPrefs(p){ try { localStorage.setItem(ADV_KEY, JSON.stringify(p||{})); } catch(e){} }
  function resetAdvPrefs(){ try { localStorage.removeItem(ADV_KEY); } catch(e){} }
  const adv = loadAdvPrefs();

  // Initialize UI if admin
  if (isAdmin) {
    const $advEnable = $('#adv_enable');
    const $advSimulate = $('#adv_simulate');
    const $advDirect = $('#adv_direct');
    const $advCands  = $('#adv_cands');
    const $advIters  = $('#adv_iters');
    const $advSave   = $('#adv_save');
    const $advReset  = $('#adv_reset');

  $advEnable.prop('checked', !!adv.enabled);
  $advSimulate.prop('checked', !!adv.simulate);
    $advDirect.prop('checked', !!adv.direct);
    if (typeof adv.cands === 'number') $advCands.val(adv.cands);
    if (typeof adv.iters === 'number') $advIters.val(adv.iters);

    $advSave.on('click', function(){
      const prefs = {
        enabled: $advEnable.is(':checked'),
        simulate: $('#adv_simulate').is(':checked'),
        direct: $advDirect.is(':checked'),
        cands: (function(){ const v = parseInt($advCands.val(),10); return Number.isFinite(v) && v>0 ? v : undefined; })(),
        iters: (function(){ const v = parseInt($advIters.val(),10); return Number.isFinite(v) && v>0 ? v : undefined; })(),
      };
      saveAdvPrefs(prefs);
      notify('success','Ajustes guardados','Tus preferencias avanzadas fueron guardadas.');
    });

    $advReset.on('click', function(){
      resetAdvPrefs();
      $('#adv_enable').prop('checked', false);
      $('#adv_simulate').prop('checked', false);
      $('#adv_direct').prop('checked', false);
      $('#adv_cands').val('');
      $('#adv_iters').val('');
      notify('info','Ajustes restablecidos','Se eliminaron las preferencias guardadas.');
    });
  }

  if ($errorFecha.length && !$errorFecha.val()) {
    $errorFecha.val(errorNowValue());
  }
  if ($errorMotivoId.length) {
    resetErrorForm();
  }
  if ($errorRespId.length) {
    $errorRespId.on('change', function(){
      const val = $(this).val();
      const label = $(this).find('option:selected').text().trim();
      if (val && $errorRespNombre.length && !$errorRespNombre.val()) {
        $errorRespNombre.val(label);
      }
      if (!val && $errorRespNombre.length && $errorRespNombre.val() === label) {
        $errorRespNombre.val('');
      }
    });
  }
  if ($btnLimpiarError.length) {
    $btnLimpiarError.on('click', function(){ resetErrorForm(); });
  }
  if ($btnRefreshErrores.length) {
    $btnRefreshErrores.on('click', function(){ cargarErrores(); });
  }
  if ($btnGuardarError.length) {
    $btnGuardarError.on('click', function(){
      if (!$errorMotivoId.length) return;
      const motivoId = parseInt($errorMotivoId.val(), 10);
      if (!Number.isFinite(motivoId) || motivoId <= 0) {
        notify('warning', 'Validación', 'Seleccione un motivo.');
        return;
      }
      const fechaVal = $errorFecha.length ? String($errorFecha.val() || '') : '';
      if (!fechaVal) {
        notify('warning', 'Validación', 'Ingrese la fecha y hora.');
        return;
      }
      const obsVal = $errorObservacion.length ? String($errorObservacion.val() || '').trim() : '';
      const respIdVal = $errorRespId.length ? parseInt($errorRespId.val(), 10) : NaN;
      let respNombreVal = $errorRespNombre.length ? String($errorRespNombre.val() || '').trim() : '';
      if ((!respNombreVal) && Number.isFinite(respIdVal) && respIdVal > 0) {
        const label = $errorRespId.find('option:selected').text().trim();
        if (label) respNombreVal = label;
      }
      const body = {
        so_id: soId,
        motivo_id: motivoId,
        logged_at: fechaVal,
      };
      if (Number.isFinite(respIdVal) && respIdVal > 0) body.responsable_user_id = respIdVal;
      if (respNombreVal) body.responsable_nombre = respNombreVal;
      if (obsVal) body.observacion = obsVal;
      if (Number.isFinite(currentPreId) && currentPreId > 0) body.pre_id = currentPreId;

      showLoading('Registrando', 'Guardando el error');
      $.ajax({
        url: joinUrl('api/operaciones/so_pre_errores_save.php'),
        method: 'POST',
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        data: JSON.stringify(body)
      }).done(function(res){
        if (res && res.ok) {
          notify('success', 'Error registrado', 'Se registró el error.');
          resetErrorForm();
          cargarErrores();
        } else {
          notify('error', 'Error', res && res.error ? res.error : 'No se pudo registrar el error.');
        }
      }).fail(function(x){
        const msg = x?.responseJSON ? (x.responseJSON.message || x.responseJSON.error) : (x.responseText || x.statusText || 'Error');
        notify('error', 'Error', msg);
      }).always(function(){ closeLoading(); });
    });
  }

  // Inicializar todos los botones como ocultos excepto Plan FEFO
  $btnDoc.hide();
  $btnMovsPdf.hide();
  $btnReposPdf.hide();
  $btnStartRepos.hide();
  $btnConfirmRepos.hide();
  $btnConfirm.hide();
  $btnMovs.hide();

  // Función para controlar visibilidad de botones según estado
  function actualizarBotones(estadoCode) {
    // Ocultar todos primero
    $btnFefo.hide();
    $btnDoc.hide();
    $btnMovsPdf.hide();
    $btnReposPdf.hide();
  $btnStartRepos.hide();
    $btnConfirmRepos.hide();
    $btnConfirm.hide();
    $btnMovs.hide();
    
    switch(estadoCode) {
      case 'EN_PREPARACION':
        // Verificar si ya existe preembarque
        $.ajax({ 
          url: joinUrl('api/operaciones/so_pre_doc.php'), 
          method: 'GET', 
          dataType: 'json', 
          data: { so_id: soId } 
        }).done(function(res){
          if (res && res.ok && res.pre) {
            // Ya hay preembarque - mostrar botones de documentos y confirmación final
            const preId = res.pre.id;
            setCurrentPreId(preId);
            const docUrl = joinUrl('api/operaciones/so_pre_doc_pdf.php') + '?pre_id=' + preId;
            const movsPdfUrl = joinUrl('salidas/preparacion/doc') + '?pre_id=' + preId + '&movimientos=1';
            const reposPdfUrl = joinUrl('salidas/preparacion/doc') + '?pre_id=' + preId + '&reposicion=1';
            
            $btnDoc.attr('href', docUrl).show();
            $btnMovsPdf.attr('href', movsPdfUrl).show();
            // Mostrar reposición solo cuando ya existe PRE (FEFO generado)
            $btnReposPdf.attr('href', reposPdfUrl).show();
            $btnStartRepos.show();
            $btnMovs.show();
            $btnConfirm.show();
          } else if (res && res.ok && res.has_preembarque === false) {
            // No hay preembarque - solo mostrar Plan FEFO (sin botones de reposición)
            $btnFefo.show();
          } else {
            // Respuesta inesperada: al menos deja Plan FEFO
            $btnFefo.show();
          }
        });
        break;
        
      case 'REPOSICION':
        // Estado reposición - mostrar PDF reposición y confirmar reposición
        $.ajax({ 
          url: joinUrl('api/operaciones/so_pre_doc.php'), 
          method: 'GET', 
          dataType: 'json', 
          data: { so_id: soId } 
        }).done(function(res){
          if (res && res.ok && res.pre) {
            const preId = res.pre.id;
            setCurrentPreId(preId);
            const reposPdfUrl = joinUrl('salidas/preparacion/doc') + '?pre_id=' + preId + '&reposicion=1';
            const movsPdfUrl = joinUrl('salidas/preparacion/doc') + '?pre_id=' + preId + '&movimientos=1';
            
            $btnReposPdf.attr('href', reposPdfUrl).show();
            $btnMovsPdf.attr('href', movsPdfUrl).show();
            $btnMovs.show();
            $btnConfirmRepos.show();
          } else if (res && res.ok && res.has_preembarque === false) {
            // Sin preembarque: aún así permitir imprimir Orden de Reposición basada en so_id
            const reposPdfUrl = joinUrl('salidas/preparacion/doc') + '?so_id=' + soId + '&reposicion=1';
            $btnReposPdf.attr('href', reposPdfUrl).show();
            $btnConfirmRepos.show();
          }
        });
        break;
        
      case 'PREPARADO':
        // Ya está preparado - solo mostrar documentos para consulta
        $.ajax({ 
          url: joinUrl('api/operaciones/so_pre_doc.php'), 
          method: 'GET', 
          dataType: 'json', 
          data: { so_id: soId } 
        }).done(function(res){
          if (res && res.ok && res.pre) {
            const preId = res.pre.id;
            setCurrentPreId(preId);
            const docUrl = joinUrl('api/operaciones/so_pre_doc_pdf.php') + '?pre_id=' + preId;
            const movsPdfUrl = joinUrl('salidas/preparacion/doc') + '?pre_id=' + preId + '&movimientos=1';
            
            $btnDoc.attr('href', docUrl).show();
            $btnMovsPdf.attr('href', movsPdfUrl).show();
            $btnMovs.show();
          }
        });
        break;
    }
  }

  function nfmt(v){ if(v==null) return ''; const n=Number(v)||0; return n.toLocaleString('es-AR'); }

  // 🧠 Función para detectar automáticamente qué conversiones activar basado en stock vs necesidades
  function detectSmartConversions(pendUV, pendUC, callback) {
    const diagUrl = joinUrl('api/operaciones/so_diag_stock.php') + `?so_id=${soId}&limit=10`;
    
    $.getJSON(diagUrl)
      .done(function(res) {
        let shouldEnableUvToUc = false;
        let shouldEnableUcToUv = false;
        let stockInfo = { pickUv: 0, pickUc: 0, otherUv: 0, otherUc: 0 };
        
        try {
          const items = (res && res.ok && Array.isArray(res.items)) ? res.items : [];
          if (items.length) {
            for (const it of items) {
              stockInfo.pickUv += Number(it.pick_uv||0);
              stockInfo.pickUc += Number(it.pick_uc||0);
              stockInfo.otherUv += Number(it.other_uv||0);
              stockInfo.otherUc += Number(it.other_uc||0);
            }
            
            const totUv = stockInfo.pickUv + stockInfo.otherUv;
            const totUc = stockInfo.pickUc + stockInfo.otherUc;
            
            console.log('📦 Stock disponible:', {
              'Pick UV': stockInfo.pickUv,
              'Pick UC': stockInfo.pickUc,
              'Other UV': stockInfo.otherUv,
              'Other UC': stockInfo.otherUc,
              'Total UV': totUv,
              'Total UC': totUc,
              'Pending UV': pendUV,
              'Pending UC': pendUC
            });
            
            // Si falta UC pero hay UV disponible → activar UV→UC (abrir cajas)
            if (pendUC > 0 && totUv > 0) {
              shouldEnableUvToUc = true;
              console.log(`🔄 Auto-detectado UV→UC: faltan ${pendUC} UC, disponibles ${totUv} UV`);
            }
            // Si falta UV pero hay UC disponible → activar UC→UV (armar cajas)  
            if (pendUV > 0 && totUc > 0) {
              shouldEnableUcToUv = true;
              console.log(`🔄 Auto-detectado UC→UV: faltan ${pendUV} UV, disponibles ${totUc} UC`);
            }
          }
        } catch(e) {
          console.error('Error analizando stock para auto-conversión:', e);
        }
        
        callback({
          uvToUc: shouldEnableUvToUc,
          ucToUv: shouldEnableUcToUv,
          stockInfo: stockInfo
        });
      })
      .fail(function() {
        console.warn('No se pudo obtener diagnóstico de stock para auto-conversión');
        callback({ uvToUc: false, ucToUv: false, stockInfo: null });
      });
  }

  function errorNowValue() {
    const now = new Date();
    const tzOffset = now.getTimezoneOffset() * 60000;
    return new Date(now.getTime() - tzOffset).toISOString().slice(0, 16);
  }

  function setCurrentPreId(value) {
    const num = Number(value);
    if (Number.isFinite(num) && num > 0) {
      currentPreId = num;
    }
  }

  function populateMotivos(motivos) {
    if (!$errorMotivoId.length) return;
    const current = $errorMotivoId.val();
    $errorMotivoId.empty();
    $errorMotivoId.append('<option value="">Seleccione…</option>');
    if (Array.isArray(motivos)) {
      motivos.forEach(function(item){
        if (!item || !item.id) return;
        const name = item.nombre ? String(item.nombre) : `Motivo #${item.id}`;
        $errorMotivoId.append($('<option>').val(String(item.id)).text(name));
      });
    }
    if (current && $errorMotivoId.find(`option[value="${current}"]`).length) {
      $errorMotivoId.val(current);
    }
  }

  function resetErrorForm() {
    if ($errorMotivoId.length) $errorMotivoId.val('');
    if ($errorRespId.length) $errorRespId.val('');
    if ($errorRespNombre.length) $errorRespNombre.val('');
    if ($errorObservacion.length) $errorObservacion.val('');
    if ($errorFecha.length) $errorFecha.val(errorNowValue());
  }

  function cargarErrores() {
    if (!$tblErrores.length) return;
    const url = joinUrl('api/operaciones/so_pre_errores.php');
    $.getJSON(url, { so_id: soId })
      .done(function(res){
        if (!res || res.ok !== true) {
          if (res && res.error) notify('error', 'Errores', res.error);
          return;
        }
        if (res.pre && res.pre.id) {
          setCurrentPreId(res.pre.id);
        }
        if (Array.isArray(res.motivos)) {
          populateMotivos(res.motivos);
        }
        const data = Array.isArray(res.rows) ? res.rows : [];
        data.forEach(function(row){
          if (!row) return;
          if (!row.responsable_label) {
            row.responsable_label = row.responsable_nombre || '';
          }
        });
        if (!erroresTable) {
          erroresTable = $tblErrores.DataTable({
            data,
            columns: [
              { data: 'logged_at_fmt', title: 'Fecha' },
              { data: 'motivo_nombre', title: 'Motivo' },
              { data: 'responsable_label', title: 'Responsable' },
              { data: 'observacion', title: 'Observación', render: function(val){ return val || ''; } }
            ],
            language: { url: 'https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json' },
            order: [[0, 'desc']]
          });
        } else {
          erroresTable.clear().rows.add(data).draw();
        }
      })
      .fail(function(x){
        const msg = x?.responseJSON ? (x.responseJSON.message || x.responseJSON.error) : (x.responseText || x.statusText || 'Error');
        console.error('Error cargando registro de errores:', msg);
        notify('error', 'Errores', msg);
      });
  }

  // Función para cargar resumen del pedido
  function cargarResumenPedido() {
    $.ajax({
      url: joinUrl('api/operaciones/so_resumen.php'),
      method: 'GET',
      dataType: 'json',
      data: { so_id: soId }
    })
    .done(function(res) {
      if (!res || res.ok !== true) return;
      
      const pedido = res.pedido;
      const stats = res.estadisticas;
      
      // Información básica
      $('#pedidoCodigo').text(pedido.codigo);
      $('#pedidoCliente').text(pedido.cliente_nombre || 'Sin cliente');
      $('#pedidoFecha').text(pedido.fecha_pedido);
      $('#pedidoCreado').text(new Date(pedido.created_at).toLocaleDateString('es-AR'));
      
      // Estado
      let estadoClass = 'bg-secondary';
      if (pedido.estado_code === 'EN_PREPARACION') estadoClass = 'bg-primary';
      else if (pedido.estado_code === 'REPOSICION') estadoClass = 'bg-warning';
      else if (pedido.estado_code === 'PREPARADO') estadoClass = 'bg-success';
      
      $('#estadoBadge').removeClass('bg-secondary bg-primary bg-warning bg-success')
                      .addClass(estadoClass)
                      .text(pedido.estado_nombre);
      
      // Estadísticas
      $('#totalDestinos').text(nfmt(stats.total_destinos));
      $('#totalProductos').text(nfmt(stats.productos_unicos));
      $('#totalItems').text(nfmt(stats.total_items));
      $('#totalCajas').text(`${nfmt(stats.total_prepared_uv)} / ${nfmt(stats.total_expected_uv)}`);
      $('#totalSueltas').text(`${nfmt(stats.total_prepared_uc)} / ${nfmt(stats.total_expected_uc)}`);
      
      // Barras de progreso
      $('#progresoUV').css('width', stats.progreso_uv + '%');
      $('#progresoUC').css('width', stats.progreso_uc + '%');
      
  // Actualizar botones según el estado
  actualizarBotones(pedido.estado_code);

      // Gatear Confirmar preparación hasta que no haya pendientes
      const expUV = Number(stats.total_expected_uv || 0);
      const expUC = Number(stats.total_expected_uc || 0);
      const prepUV = Number(stats.total_prepared_uv || 0);
      const prepUC = Number(stats.total_prepared_uc || 0);
      const pendUV = Math.max(0, expUV - prepUV);
      const pendUC = Math.max(0, expUC - prepUC);
      const sinPendientes = (pendUV === 0 && pendUC === 0);
      $btnConfirm.prop('disabled', !sinPendientes);
      if (!sinPendientes) {
        $btnConfirm.attr('title', `Faltan preparar · UV: ${pendUV} · UC: ${pendUC}`);
      } else {
        $btnConfirm.attr('title', 'Confirmar preparación');
      }

      // Mostrar el botón Plan FEFO siempre que haya pendientes en EN_PREPARACION
      if (pedido.estado_code === 'EN_PREPARACION') {
        if (!sinPendientes) {
          $btnFefo.show();
        } else {
          $btnFefo.hide();
        }
      }

      // Alerta importante de faltantes justo después del Plan FEFO
      if (window.__showShortageAfterFefo && (pendUV > 0 || pendUC > 0)) {
        window.__showShortageAfterFefo = false; // mostrar una sola vez
        const diagUrl = joinUrl('api/operaciones/so_diag_stock.php') + `?so_id=${soId}&limit=5`;
        // Preferir PDF de reposición por pre_id si existe; si no, usar fallback por so_id
        const openRepos = () => {
          $.ajax({ url: joinUrl('api/operaciones/so_pre_doc.php'), method: 'GET', dataType: 'json', data: { so_id: soId } })
            .done(function(r){
              let url = null;
              if (r && r.ok && r.pre && r.pre.id) {
                setCurrentPreId(r.pre.id);
                url = joinUrl('salidas/preparacion/doc') + `?pre_id=${r.pre.id}&reposicion=1`;
              } else {
                url = joinUrl('salidas/preparacion/doc') + `?so_id=${soId}&reposicion=1`;
              }
              window.open(url, '_blank');
            })
            .fail(function(){ window.open(joinUrl('salidas/preparacion/doc') + `?so_id=${soId}&reposicion=1`, '_blank'); });
        };

        // Intentar enriquecer el mensaje con stock disponible consultando el diagnóstico
        $.getJSON(diagUrl)
          .always(function(res){
            let extraLine = '';
            let shouldEnableUvToUc = false;
            let shouldEnableUcToUv = false;
            let smartConvParts = [];
            
            try {
              const items = (res && res.ok && Array.isArray(res.items)) ? res.items : [];
              if (items.length) {
                let pickUv=0, pickUc=0, otherUv=0, otherUc=0;
                for (const it of items) {
                  pickUv += Number(it.pick_uv||0);
                  pickUc += Number(it.pick_uc||0);
                  otherUv += Number(it.other_uv||0);
                  otherUc += Number(it.other_uc||0);
                }
                const totUv = pickUv + otherUv;
                const totUc = pickUc + otherUc;
                extraLine = `

Stock disponible:
• UV total: ${totUv} (PICKING: ${pickUv} / OTROS: ${otherUv})
• UC total: ${totUc} (PICKING: ${pickUc} / OTROS: ${otherUc})`;

                // 🧠 LÓGICA INTELIGENTE: Detectar automáticamente qué conversiones activar
                // Si falta UC pero hay UV disponible → activar UV→UC (abrir cajas)
                if (pendUC > 0 && totUv > 0) {
                  shouldEnableUvToUc = true;
                  console.log(`🔄 Auto-activando UV→UC: faltan ${pendUC} UC, disponibles ${totUv} UV`);
                }
                // Si falta UV pero hay UC disponible → activar UC→UV (armar cajas)  
                if (pendUV > 0 && totUc > 0) {
                  shouldEnableUcToUv = true;
                  console.log(`🔄 Auto-activando UC→UV: faltan ${pendUV} UV, disponibles ${totUc} UC`);
                }
              }
            } catch(e) {
              console.error('Error analizando stock para conversiones:', e);
            }

            // Construir etiqueta de conversión: priorizar detección automática sobre preferencias manuales
            const convParts = [];
            const finalUcToUv = shouldEnableUcToUv || $chkUcToUv.is(':checked');
            const finalUvToUc = shouldEnableUvToUc || $chkUvToUc.is(':checked');
            
            if (finalUcToUv) convParts.push('UC→UV');
            if (finalUvToUc) convParts.push('UV→UC');
            
            // Indicar si se activó automáticamente
            if (shouldEnableUvToUc && !$chkUvToUc.is(':checked')) smartConvParts.push('UV→UC (auto)');
            if (shouldEnableUcToUv && !$chkUcToUv.is(':checked')) smartConvParts.push('UC→UV (auto)');
            
            const convSuffix = convParts.length ? ` + ${convParts.join(' y ')}` : '';
            const convHint = convParts.length ? ` con ${convParts.join(' y ')}` : '';
            const smartHint = smartConvParts.length ? ` (${smartConvParts.join(' y ')} detectado automáticamente)` : '';

            notify('warning', 'Falta stock para preparar',
              `Pendientes detectados luego del Plan FEFO:
• UV pendientes: ${pendUV}
• UC pendientes: ${pendUC}` + extraLine + smartHint,
              {
                showCancelButton: true,
                cancelButtonText: 'Ver Reposición',
                showDenyButton: true,
                confirmButtonText: `Reintentar Directo${convSuffix}`,
                denyButtonText: 'Diagnóstico',
              }
            ).then((resBtn) => {
          if (resBtn.isConfirmed) {
            // Reintentar forzando directo a PREP con conversiones inteligentes
            showLoading('Reintentando', `Forzando Directo a PREP${convHint}${smartHint}`);
            const retryBody = {
              so_id: soId,
              debug: 1, // Activar debug para ver logs
              simulate: 0,
              direct_to_prep: 1,
              uc_to_uv: finalUcToUv ? 1 : 0,
              uv_to_uc: finalUvToUc ? 1 : 0
            };
            
            // 🎯 Log de la decisión inteligente
            console.log('🔧 Configuración de conversiones:', {
              'UC→UV': finalUcToUv ? '✅' : '❌',
              'UV→UC': finalUvToUc ? '✅' : '❌',
              'Auto-detectado': smartConvParts.length ? smartConvParts : 'ninguno',
              'Manual': [
                $chkUcToUv.is(':checked') ? 'UC→UV' : null,
                $chkUvToUc.is(':checked') ? 'UV→UC' : null
              ].filter(Boolean)
            });
            $.ajax({
              url: joinUrl('api/operaciones/so_preparar_simple.php'),
              method: 'POST',
              contentType: 'application/json; charset=utf-8',
              dataType: 'json',
              data: JSON.stringify(retryBody),
              timeout: 300000
            }).done(function(rr){
              console.log('Retry response:', rr); // Debug log
              if (rr && rr.ok) {
                notify('success', 'Reintento ejecutado', rr.doc_url ? 'Se generó/actualizó el PRE.' : 'Se re-evaluó el plan.');
                // Mostrar debug logs si están disponibles
                if (rr.debug && Array.isArray(rr.debug) && rr.debug.length > 0) {
                  console.log('Debug logs from retry:', rr.debug);
                }
                if (rr.pre && rr.pre.id) {
                  const pid = rr.pre.id;
                  $btnDoc.attr('href', joinUrl('salidas/preparacion/doc') + '?pre_id=' + pid).show();
                  $btnMovsPdf.attr('href', joinUrl('salidas/preparacion/doc') + '?pre_id=' + pid + '&movimientos=1').show();
                  $btnReposPdf.attr('href', joinUrl('salidas/preparacion/doc') + '?pre_id=' + pid + '&reposicion=1').show();
                }
                // refrescar tablas/estado y movimientos
                $.ajax({ url: joinUrl('api/operaciones/so_items.php'), method:'GET', dataType:'json', data:{ so_id: soId }}).done(function(res){ if (res && res.ok) { const dt = $tbl.DataTable(); dt.clear().rows.add(res.data||[]).draw(); } });
                loadMovimientos();
                cargarResumenPedido();
              } else {
                console.log('Retry failed or no changes:', rr);
                notify('info','Sin cambios', (rr && rr.error) ? rr.error : 'El reintento no generó PRE.');
              }
            }).fail(function(x){
              console.error('Retry AJAX failed:', x);
              const errorMsg = x.responseJSON ? (x.responseJSON.message || x.responseJSON.error) : x.responseText || x.status;
              notify('error','Error','Fallo el reintento: ' + errorMsg);
            }).always(function(){ closeLoading(); });
          } else if (resBtn.isDenied) {
            window.open(diagUrl, '_blank');
          } else {
            openRepos();
          }
        });
          }); // end always diag
      }
    })
    .fail(function() {
      $('#estadoBadge').removeClass('bg-secondary').addClass('bg-danger').text('Error');
    });
  }

  // Cargar tiempos/responsable del PRE (Paso 5)
  function cargarTiempos() {
    $.getJSON(joinUrl('api/operaciones/so_pre_tiempos.php'), { so_id: soId }, function(res){
      if (!res || !res.ok || !res.has_preembarque) { $prepStatus.text('Sin PRE aún'); return; }
  if (res.pre && res.pre.id) setCurrentPreId(res.pre.id);
      const pre = res.pre || {};
      const tarea = res.tarea_preparacion || {};
      const tareaCtrl = res.tarea_control || {};
      if (tarea.responsable_user_id) $prepRespId.val(String(tarea.responsable_user_id));
      if (pre.observacion) $prepObs.val(pre.observacion);
      const s = [];
      s.push('PRE ' + (pre.codigo||('-')));
      s.push('Asignado: ' + (pre.asignado_at||'-'));
      s.push('Inicio: ' + (pre.inicio_at||'-'));
      s.push('Fin: ' + (pre.fin_at||'-'));
      if (tarea.foto_url) s.push('Foto: ' + tarea.foto_url);
      $prepStatus.text(s.join(' · '));

      // Control task status
      const sc = [];
      sc.push('Asignado: ' + (tareaCtrl.inicio_at ? 'Sí' : (tareaCtrl.responsable_user_id ? 'Sí' : '-')));
      sc.push('Inicio: ' + (tareaCtrl.inicio_at||'-'));
      sc.push('Fin: ' + (tareaCtrl.fin_at||'-'));
      if (tareaCtrl.foto_url) sc.push('Foto: ' + tareaCtrl.foto_url);
      $ctrlStatus.text(sc.join(' · '));
      if (tareaCtrl.responsable_user_id) $ctrlRespId.val(String(tareaCtrl.responsable_user_id));
      if (tareaCtrl.nota) $ctrlObs.val(tareaCtrl.nota);
    });
  }

  // Cargar usuarios en el selector de responsable
  function cargarUsuariosResp(selectedIdPrep, selectedIdCtrl){
    $.getJSON(joinUrl('api/system/sys_users.php'), { limit: 500 }, function(r){
      if (!r || !r.ok) return;
      const data = Array.isArray(r.data) ? r.data : [];
      // limpiar y poblar
      $prepRespId.empty();
      $prepRespId.append('<option value="">Seleccione un usuario…</option>');
      $ctrlRespId.empty();
      $ctrlRespId.append('<option value="">Seleccione un usuario…</option>');
      const prevErrorId = $errorRespId.length ? $errorRespId.val() : '';
      if ($errorRespId.length) {
        $errorRespId.empty();
        $errorRespId.append('<option value="">Seleccione…</option>');
      }
      data.forEach(u => {
        const id = String(u.id);
        const label = (u.full_name || u.username || ('#'+id));
        const opt = $('<option>').val(id).text(label);
        $prepRespId.append(opt);
        $ctrlRespId.append(opt.clone());
        if ($errorRespId.length) $errorRespId.append($('<option>').val(id).text(label));
      });
      if (selectedIdPrep) $prepRespId.val(String(selectedIdPrep));
      if (selectedIdCtrl) $ctrlRespId.val(String(selectedIdCtrl));
      if ($errorRespId.length && prevErrorId) {
        $errorRespId.val(String(prevErrorId));
      }
    });
  }

  // Primero marcar EN_PREPARACION y recién entonces cargar el resumen
  $.ajax({ url: joinUrl('api/operaciones/so_set_estado.php'), method: 'POST', dataType: 'json', data: { so_id: soId, estado: 'EN_PREPARACION' } })
    .always(function(){
      // Cargar resumen después de intentar setear estado
      cargarResumenPedido();
      // Primero cargar tiempos para conocer responsables y luego poblar usuarios
      $.getJSON(joinUrl('api/operaciones/so_pre_tiempos.php'), { so_id: soId }, function(res){
        const selectedPrep = (res && res.ok && res.has_preembarque && res.tarea_preparacion && res.tarea_preparacion.responsable_user_id) ? res.tarea_preparacion.responsable_user_id : '';
        const selectedCtrl = (res && res.ok && res.has_preembarque && res.tarea_control && res.tarea_control.responsable_user_id) ? res.tarea_control.responsable_user_id : '';
  if (res && res.pre && res.pre.id) setCurrentPreId(res.pre.id);
        cargarUsuariosResp(selectedPrep, selectedCtrl);
        // Y actualizar el status
        if (res && res.ok) {
          const pre = res.pre || {};
          const tarea = res.tarea_preparacion || {};
          const tareaCtrl = res.tarea_control || {};
          if (pre.observacion) $prepObs.val(pre.observacion);
          const s = [];
          if (pre.codigo) s.push('PRE ' + pre.codigo);
          s.push('Asignado: ' + (pre.asignado_at||'-'));
          s.push('Inicio: ' + (pre.inicio_at||'-'));
          s.push('Fin: ' + (pre.fin_at||'-'));
          if (tarea.foto_url) s.push('Foto: ' + tarea.foto_url);
          $prepStatus.text(s.join(' · '));
          const sc = [];
          sc.push('Asignado: ' + (tareaCtrl.inicio_at ? 'Sí' : (tareaCtrl.responsable_user_id ? 'Sí' : '-')));
          sc.push('Inicio: ' + (tareaCtrl.inicio_at||'-'));
          sc.push('Fin: ' + (tareaCtrl.fin_at||'-'));
          if (tareaCtrl.foto_url) sc.push('Foto: ' + tareaCtrl.foto_url);
          $ctrlStatus.text(sc.join(' · '));
        } else {
          $prepStatus.text('Sin PRE aún');
          $ctrlStatus.text('Sin PRE aún');
        }
      });
    });

  // Cargar ítems del pedido
  $.ajax({ url: joinUrl('api/operaciones/so_items.php'), method: 'GET', dataType: 'json', data: { so_id: soId } })
    .done(function(res){
      if (!res || res.ok !== true) return;
      const cols = Array.isArray(res.columns) ? res.columns : [];
      const theadHtml = '<tr>' + cols.map(c => `<th>${(c.title || c.data || '').toString()}</th>`).join('') + '</tr>';
      $tbl.find('thead').html(theadHtml);
      if ($tbl.find('tfoot').length === 0) {
        const tf = document.createElement('tfoot');
        const tr = document.createElement('tr');
        for (let i=0;i<cols.length;i++) tr.appendChild(document.createElement('th'));
        tf.appendChild(tr);
        $tbl.append(tf);
      }
      const dtCols = cols.map(c => ({ data: c.data, title: c.title || c.data }));
      const dt = $tbl.DataTable({ data: Array.isArray(res.data)?res.data:[], columns: dtCols, deferRender:true, paging:true, pageLength:25, order: [], language: { url:'https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json' } });
    });

  // Cargar movimientos siempre
  function loadMovimientos() {
    const url = joinUrl('api/operaciones/so_pre_movimientos.php');
    $.getJSON(url, { so_id: soId }, function(r){
      if (!r || !r.ok) return;
      const data = r.data || [];
      const $tbl = $('#tblMovs');
      if (!movsTable) {
        movsTable = $tbl.DataTable({
          data,
            columns:[
              {data:'created_at', title:'Fecha'},
              {data:'tipo', title:'Tipo'},
              {data:'motivo', title:'Motivo'},
              {data:'producto_code', title:'Producto'},
              {data:'lote_codigo', title:'Lote'},
              {data:'fecha_vencimiento', title:'Venc'},
              {data:'pallet_id', title:'Pallet'},
              {data:'from_code', title:'Desde'},
              {data:'to_code', title:'Hasta'},
              {data:'delta_uv', title:'UV'},
              {data:'delta_uc', title:'UC'}
            ],
            language:{ url:'https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json' },
            order:[[0,'desc']]
        });
      } else {
        movsTable.clear().rows.add(data).draw();
      }
      // No ocultar el botón FEFO por la mera existencia de movimientos; 
      // su visibilidad ahora depende de si hay pendientes (ver cargarResumenPedido)
    });
  }
  loadMovimientos();

  if ($tblErrores.length) {
    cargarErrores();
  }

  function postTiempo(action, withFile=false, tipo='PREPARACION'){
    const url = joinUrl('api/operaciones/so_pre_tiempos_update.php');
    if (withFile) {
      const fd = new FormData();
      fd.append('action', action);
      fd.append('tipo', tipo);
      // Resolver pre_id desde so_pre_doc
      $.getJSON(joinUrl('api/operaciones/so_pre_doc.php'), { so_id: soId }, function(r){
        if (!r || !r.ok || !r.pre) { notify('error','Tiempos','No hay PRE aún. Genere el plan FEFO primero.'); return; }
  setCurrentPreId(r.pre.id);
  fd.append('pre_id', r.pre.id);
        if (tipo === 'PREPARACION') {
          const respId = parseInt($prepRespId.val(),10); if (Number.isFinite(respId) && respId>0) fd.append('responsable_user_id', String(respId));
          const obs = String($prepObs.val()||''); if (obs) fd.append('observacion', obs);
          const file = $prepFoto[0]?.files?.[0]; if (file) fd.append('foto', file);
        } else {
          const respId = parseInt($ctrlRespId.val(),10); if (Number.isFinite(respId) && respId>0) fd.append('responsable_user_id', String(respId));
          const obs = String($ctrlObs.val()||''); if (obs) fd.append('observacion', obs);
          const file = $ctrlFoto[0]?.files?.[0]; if (file) fd.append('foto', file);
        }
        $.ajax({ url, method:'POST', data: fd, contentType:false, processData:false, dataType:'json' })
          .done(function(res){ if (res && res.ok) { notify('success','Tiempos','Actualizado'); cargarTiempos(); } else { notify('error','Tiempos', res?.error || 'Error'); } })
          .fail(function(x){ notify('error','Tiempos', x.responseText || x.statusText || 'Error'); });
      });
    } else {
      // JSON simple
      $.getJSON(joinUrl('api/operaciones/so_pre_doc.php'), { so_id: soId }, function(r){
        if (!r || !r.ok || !r.pre) { notify('error','Tiempos','No hay PRE aún. Genere el plan FEFO primero.'); return; }
  const body = { pre_id: r.pre.id, action, tipo };
  setCurrentPreId(r.pre.id);
        if (tipo === 'PREPARACION') {
          const respId = parseInt($prepRespId.val(),10); if (Number.isFinite(respId) && respId>0) body.responsable_user_id = respId;
          const obs = String($prepObs.val()||''); if (obs) body.observacion = obs;
        } else {
          const respId = parseInt($ctrlRespId.val(),10); if (Number.isFinite(respId) && respId>0) body.responsable_user_id = respId;
          const obs = String($ctrlObs.val()||''); if (obs) body.observacion = obs;
        }
        $.ajax({ url, method:'POST', contentType:'application/json; charset=utf-8', dataType:'json', data: JSON.stringify(body) })
          .done(function(res){ if (res && res.ok) { notify('success','Tiempos','Actualizado'); cargarTiempos(); } else { notify('error','Tiempos', res?.error || 'Error'); } })
          .fail(function(x){ notify('error','Tiempos', x.responseText || x.statusText || 'Error'); });
      });
    }
  }

  $btnAsignarPrep.on('click', function(){ postTiempo('asignar', false, 'PREPARACION'); });
  $btnInicioPrep.on('click', function(){ postTiempo('inicio', false, 'PREPARACION'); });
  $btnFinPrep.on('click', function(){ postTiempo('fin', true, 'PREPARACION'); });
  $btnAsignarCtrl.on('click', function(){ postTiempo('asignar', false, 'CONTROL'); });
  $btnInicioCtrl.on('click', function(){ postTiempo('inicio', false, 'CONTROL'); });
  $btnFinCtrl.on('click', function(){ postTiempo('fin', true, 'CONTROL'); });

  // Plan FEFO automático → ejecuta SP y muestra link al documento
  $btnFefo.on('click', function(){
    console.log('Iniciando Plan FEFO para soId:', soId);
    $btnFefo.prop('disabled', true).text('Analizando...');
    showLoading('Analizando...', 'Detectando necesidades de conversión automática');
    
    // 🧠 Primero detectar si necesitamos activar conversiones automáticamente
    $.getJSON(joinUrl('api/operaciones/so_resumen.php'), { so_id: soId }, function(resStats) {
      if (!resStats || !resStats.ok) {
        console.warn('No se pudo obtener estadísticas para auto-conversión');
        executePlanFefo(false, false); // Continuar sin auto-conversión
        return;
      }
      
      const stats = resStats.estadisticas || {};
      const pendUV = Math.max(0, Number(stats.total_expected_uv || 0) - Number(stats.total_prepared_uv || 0));
      const pendUC = Math.max(0, Number(stats.total_expected_uc || 0) - Number(stats.total_prepared_uc || 0));
      
      console.log('📊 Estadísticas actuales:', {
        'Expected UV': stats.total_expected_uv,
        'Prepared UV': stats.total_prepared_uv,
        'Pending UV': pendUV,
        'Expected UC': stats.total_expected_uc,
        'Prepared UC': stats.total_prepared_uc,
        'Pending UC': pendUC
      });
      
      if (pendUV === 0 && pendUC === 0) {
        console.log('✅ No hay pendientes, ejecutando Plan FEFO normal');
        executePlanFefo(false, false);
        return;
      }
      
      // Detectar conversiones inteligentes basado en stock disponible
      detectSmartConversions(pendUV, pendUC, function(smartConv) {
        console.log('🔍 Detección inteligente completa:', smartConv);
        
        // Determinar configuración final: manual + auto-detectado
        const finalUcToUv = smartConv.ucToUv || $chkUcToUv.is(':checked');
        const finalUvToUc = smartConv.uvToUc || $chkUvToUc.is(':checked');
        
        // Mostrar hint si se activó automáticamente
        if (smartConv.uvToUc && !$chkUvToUc.is(':checked')) {
          console.log('🎯 Activando UV→UC automáticamente (se detectó que falta UC pero hay UV)');
        }
        if (smartConv.ucToUv && !$chkUcToUv.is(':checked')) {
          console.log('🎯 Activando UC→UV automáticamente (se detectó que falta UV pero hay UC)');
        }
        
        executePlanFefo(finalUcToUv, finalUvToUc);
      });
    }).fail(function() {
      console.warn('Error obteniendo estadísticas, continuando sin auto-conversión');
      executePlanFefo(false, false);
    });
  });

  // Función auxiliar para ejecutar el Plan FEFO con configuración determinada
  function executePlanFefo(useUcToUv, useUvToUc) {
    $btnFefo.text('Generando...');
    showLoading('Generando...', 'Ejecutando FEFO, esto puede demorar');
    
    // Build request with precedence: smart detection + manual > admin-UI prefs (if enabled) > URL params > defaults handled by API
    let useDirect = directFlag;
    let useCands = candsParam ? parseInt(candsParam, 10) : undefined;
    let useIters = itersParam ? parseInt(itersParam, 10) : undefined;
    let useSimulate = simulateFlag;
    
    if (isAdmin) {
      const adv2 = loadAdvPrefs();
      if (adv2 && adv2.enabled) {
        if (typeof adv2.simulate === 'boolean') useSimulate = !!adv2.simulate;
        if (typeof adv2.direct === 'boolean') useDirect = !!adv2.direct;
        if (typeof adv2.cands === 'number' && adv2.cands>0) useCands = adv2.cands;
        if (typeof adv2.iters === 'number' && adv2.iters>0) useIters = adv2.iters;
      }
    }

    const requestData = { 
      so_id: soId, 
      // Nota: no forzar deposito_code ni prep_posicion; el backend lo deriva del pedido
      debug: debugFlag ? 1 : 0, 
      simulate: useSimulate ? 1 : 0,
      direct_to_prep: useDirect ? 1 : 0,
      uc_to_uv: useUcToUv ? 1 : 0,
      uv_to_uc: useUvToUc ? 1 : 0,
      // límites opcionales desde la URL
      cands: (Number.isFinite(useCands) && useCands>0) ? useCands : undefined,
      iters: (Number.isFinite(useIters) && useIters>0) ? useIters : undefined
    };
    
    console.log('🚀 Ejecutando Plan FEFO con configuración:', {
      'UC→UV': useUcToUv ? '✅' : '❌',
      'UV→UC': useUvToUc ? '✅' : '❌',
      'Directo': useDirect ? '✅' : '❌',
      'Simular': useSimulate ? '✅' : '❌'
    });

    // En modo debug, no disparamos la llamada pesada; solo observamos el SSE ping
    if (debugFlag) {
      setTimeout(() => { $btnFefo.prop('disabled', false).text('Generar el plan de picking (FEFO)'); closeLoading(); }, 2000);
      return;
    }

    // Marcar que, al finalizar, se muestre alerta si quedan pendientes
    window.__showShortageAfterFefo = true;

    $.ajax({
      url: joinUrl('api/operaciones/so_preparar_simple.php'),
      method: 'POST',
      contentType: 'application/json; charset=utf-8',
      dataType: 'json',
      data: JSON.stringify(requestData),
      timeout: 300000 // 300 seconds para depurar locks
    }).done(function(r){
      console.log('Respuesta recibida:', r);
      if (r && r.ok) {
        if (useSimulate) {
          notify('info','Simulación','Simulación ejecutada. No se realizaron movimientos reales.');
          if (debugFlag && r.plan) { try { console.group('PLAN SIMULADO'); console.table(r.plan); console.groupEnd(); } catch(e){} }
        }
        // Show/hide simulation badge
        try { document.getElementById('simulateBadge').style.display = useSimulate ? '' : 'none'; } catch(e){}
        if (debugFlag && r.debug) {
          try { console.group('FEFO Debug Logs'); console.table(r.debug); console.groupEnd(); } catch (e) {}
        }
        if (r.doc_url) {
          $btnDoc.attr('href', r.doc_url).removeClass('disabled');
          
          // Configurar botón PDF Movimientos usando pre_id de la respuesta
          if (r.pre && r.pre.id) {
            const movsPdfUrl = joinUrl('salidas/preparacion/doc') + '?pre_id=' + r.pre.id + '&movimientos=1';
            setCurrentPreId(r.pre.id);
            $btnMovsPdf.attr('href', movsPdfUrl).removeClass('disabled');
            
            // Configurar botón PDF Reposición
            const reposPdfUrl = joinUrl('salidas/preparacion/doc') + '?pre_id=' + r.pre.id + '&reposicion=1';
            $btnReposPdf.attr('href', reposPdfUrl).removeClass('disabled');
          }
          
          // refrescar items para ver prepared_*
          $.ajax({ url: joinUrl('api/operaciones/so_items.php'), method:'GET', dataType:'json', data:{ so_id: soId }}).done(function(res){
            if (res && res.ok) {
              const dt = $tbl.DataTable();
              dt.clear().rows.add(res.data || []).draw();
            }
          });
          // Recargar movimientos
          loadMovimientos();
        }

        // Chequear si se generaron movimientos. Si ninguno, ofrecer reintentar con Directo a PREP.
        $.getJSON(joinUrl('api/operaciones/so_pre_movimientos.php'), { so_id: soId }, function(mv){
          const noMovs = mv && mv.ok && (mv.count === 0 || (Array.isArray(mv.data) && mv.data.length === 0));
          if (noMovs) {
            notify('info','Sin movimientos','No se generaron movimientos (no había pendientes o todo estaba en PICKING).');
            // Si no hubo doc_url en la respuesta actual, ofrecer reintentar con Directo a PREP
            if (!r || !r.doc_url) {
              askConfirm('¿Reintentar con Directo a PREP?','Si hay stock suficiente en PICKING, se armará el PRE y las líneas de pick sin revalidación amplia.','question','Reintentar','Cancelar')
                .then(dec => {
                  if (!dec.isConfirmed) return;
                  showLoading('Reintentando','Forzando Directo a PREP');
                  const retryBody = {
                    so_id: soId,
                    debug: 0,
                    simulate: 0,
                    direct_to_prep: 1,
                    uc_to_uv: useUcToUv ? 1 : 0,
                    uv_to_uc: useUvToUc ? 1 : 0
                  };
                  $.ajax({
                    url: joinUrl('api/operaciones/so_preparar_simple.php'),
                    method: 'POST',
                    contentType: 'application/json; charset=utf-8',
                    dataType: 'json',
                    data: JSON.stringify(retryBody),
                    timeout: 300000
                  }).done(function(rr){
                    if (rr && rr.ok && rr.doc_url) {
                      notify('success','PRE generado','Se creó el documento de preparación.');
                      $btnDoc.attr('href', rr.doc_url).removeClass('disabled').show();
                      if (rr.pre && rr.pre.id) {
                        const pid = rr.pre.id;
                        setCurrentPreId(pid);
                        $btnMovsPdf.attr('href', joinUrl('salidas/preparacion/doc') + '?pre_id=' + pid + '&movimientos=1').removeClass('disabled').show();
                        $btnReposPdf.attr('href', joinUrl('salidas/preparacion/doc') + '?pre_id=' + pid + '&reposicion=1').removeClass('disabled').show();
                      }
                      // refrescar tablas/estado
                      $.ajax({ url: joinUrl('api/operaciones/so_items.php'), method:'GET', dataType:'json', data:{ so_id: soId }}).done(function(res){ if (res && res.ok) { const dt = $tbl.DataTable(); dt.clear().rows.add(res.data||[]).draw(); } });
                      loadMovimientos();
                      cargarResumenPedido();
                    } else {
                      notify('info','Sin cambios','El reintento no generó PRE.');
                    }
                  }).fail(function(x){
                    notify('error','Error','Fallo el reintento: ' + (x.responseText || x.status));
                  }).always(function(){ closeLoading(); });
                });
            }
          }
        });
        
        // Recargar resumen y actualizar botones después del Plan FEFO
        cargarResumenPedido();
      } else {
        notify('error','Error', (r && r.error) ? r.error : 'Error al ejecutar la preparación automática');
      }
    }).fail(function(xhr){
      console.error('Error en Plan FEFO:');
      console.error('Status:', xhr.status);
      console.error('Status Text:', xhr.statusText);
      console.error('Response:', xhr.responseText);
      notify('error','Error','Falló el plan FEFO: ' + (xhr.responseText || xhr.status));

      // Ofrecer fallback de preparación rápida (solo PICKING)
      askConfirm('¿Generar picking rápido?','El plan FEFO falló o demoró demasiado. ¿Desea crear un picking rápido tomando stock de PICKING?','warning','Sí, generar','No')
        .then(dec => {
          if (!dec.isConfirmed) return;
          showLoading('Generando picking rápido','Tomando stock de PICKING para crear el documento');
          const fastBody = { so_id: soId, deposito_code: 'DEP1' };
          $.ajax({
            url: joinUrl('api/operaciones/so_preparar_fast.php'),
            method: 'POST',
            contentType: 'application/json; charset=utf-8',
            dataType: 'json',
            data: JSON.stringify(fastBody),
            timeout: 120000
          }).done(function(fr){
            if (fr && fr.ok) {
              notify('success','Picking generado','Se creó el picking rápido desde PICKING.');
              // Configurar enlaces si están disponibles de inmediato
              if (fr.doc_url) {
                $btnDoc.attr('href', fr.doc_url).show().removeClass('disabled');
                if (fr.pre && fr.pre.id) {
                  const preId = fr.pre.id;
                  setCurrentPreId(preId);
                  const movsPdfUrl = joinUrl('salidas/preparacion/doc') + '?pre_id=' + preId + '&movimientos=1';
                  const reposPdfUrl = joinUrl('salidas/preparacion/doc') + '?pre_id=' + preId + '&reposicion=1';
                  $btnMovsPdf.attr('href', movsPdfUrl).show().removeClass('disabled');
                  $btnReposPdf.attr('href', reposPdfUrl).show().removeClass('disabled');
                }
              }
              // Refrescar data/estado y movimientos
              cargarResumenPedido();
              loadMovimientos();
            } else {
              notify('error','Error', (fr && fr.error) ? fr.error : 'No se pudo generar picking rápido');
            }
          }).fail(function(fx){
            notify('error','Error','Falló la preparación rápida: ' + (fx.responseText || fx.status));
          }).always(function(){
            closeLoading();
          });
        });
    }).always(function(){
      console.log('Plan FEFO completado');
      $btnFefo.prop('disabled', false).text('Generar el plan de picking (FEFO)');
      closeLoading();
    });
  }

  // Confirmar reposición → estado EN_PREPARACION
  $btnConfirmRepos.on('click', function(){
    askConfirm('Confirmar reposición','¿Confirmar que la reposición ha sido completada?','warning','Sí, confirmar','Cancelar').then(dec => { if (!dec.isConfirmed) return; 
      $btnConfirmRepos.prop('disabled', true).text('Confirmando...');
      showLoading('Confirmando','Actualizando estado del pedido');
      $.ajax({
      url: joinUrl('api/operaciones/so_confirm_reposicion.php'),
      method: 'POST',
      contentType: 'application/json; charset=utf-8',
      dataType: 'json',
      data: JSON.stringify({ so_id: soId })
      }).done(function(r){
        if (r && r.ok) {
          notify('success','Reposición confirmada','El pedido está listo para confirmación final.');
          // Recargar resumen y actualizar botones
          cargarResumenPedido();
        } else {
          notify('error','Error', (r && r.error) ? r.error : 'Error al confirmar reposición');
          $btnConfirmRepos.prop('disabled', false).text('Confirmar Reposición');
        }
      }).fail(function(xhr){
        notify('error','Error', 'Error al confirmar reposición: ' + (xhr.responseText || xhr.status));
        $btnConfirmRepos.prop('disabled', false).text('Confirmar Reposición');
      }).always(function(){ closeLoading(); });
    });
  });

  // Iniciar reposición → estado REPOSICION
  $btnStartRepos.on('click', function(){
    askConfirm('Iniciar Reposición','¿Pasar el pedido a estado REPOSICION para iniciar la reposición en piso?','warning','Sí, iniciar','Cancelar')
      .then(dec => { if (!dec.isConfirmed) return; 
        $btnStartRepos.prop('disabled', true).text('Cambiando...');
        showLoading('Cambiando estado','Marcando pedido en REPOSICION');
        $.ajax({
          url: joinUrl('api/operaciones/so_set_estado.php'),
          method: 'POST',
          dataType: 'json',
          data: { so_id: soId, estado: 'REPOSICION' }
        }).done(function(r){
          if (r && r.ok) {
            notify('success','Estado actualizado','El pedido pasó a REPOSICION.');
            cargarResumenPedido();
          } else {
            notify('error','Error', (r && r.error) ? r.error : 'No se pudo cambiar a REPOSICION');
            $btnStartRepos.prop('disabled', false).text('Iniciar Reposición');
          }
        }).fail(function(xhr){
          notify('error','Error', 'Error cambiando estado: ' + (xhr.responseText || xhr.status));
          $btnStartRepos.prop('disabled', false).text('Iniciar Reposición');
        }).always(function(){
          closeLoading();
        });
      });
  });

  // Confirmar preparación → estado PREPARADO (o PARCIAL si faltantes)
  $btnConfirm.on('click', function(){
    askConfirm('Confirmar preparación','¿Confirmar la preparación de este pedido?','warning','Sí, confirmar','Cancelar').then(dec => { if (!dec.isConfirmed) return; 
      $btnConfirm.prop('disabled', true).text('Confirmando...');
      showLoading('Confirmando','Cerrando preparación del pedido');
      $.ajax({
      url: joinUrl('api/operaciones/so_confirm_preparacion.php'),
      method: 'POST',
      contentType: 'application/json; charset=utf-8',
      dataType: 'json',
      data: JSON.stringify({ so_id: soId })
      }).done(function(r){
        if (r && r.ok) {
          const msg = `Estado: ${r.estado}. Pendientes UV: ${r.pendientes?.uv||0}, UC: ${r.pendientes?.uc||0}`;
          notify('success','Preparación confirmada', msg);
          window.location.href = joinUrl('salidas/listado');
        } else {
          notify('error','Error', (r && r.error) ? r.error : 'Error al confirmar preparación');
        }
      }).fail(function(xhr){
        notify('error','Error', 'Fallo la solicitud: ' + (xhr.responseText || xhr.status));
      }).always(function(){
        $btnConfirm.prop('disabled', false).text('Confirmar preparación');
        closeLoading();
      });
    });
  });

  // Ver movimientos generados
  $btnMovs.on('click', function(){
    const url = joinUrl('api/operaciones/so_pre_movimientos.php');
    $btnMovs.prop('disabled', true).text('Cargando...');
    $.getJSON(url, { so_id: soId }, function(r){
  if (!r || !r.ok) { notify('error','Error', r && r.error ? r.error : 'Error obteniendo movimientos'); return; }
      const data = r.data || [];
      const $tbl = $('#tblMovs');
      if (!movsTable) {
        movsTable = $tbl.DataTable({
          data,
            columns:[
              {data:'created_at', title:'Fecha'},
              {data:'tipo', title:'Tipo'},
              {data:'motivo', title:'Motivo'},
              {data:'producto_code', title:'Producto'},
              {data:'lote_codigo', title:'Lote'},
              {data:'fecha_vencimiento', title:'Venc'},
              {data:'pallet_id', title:'Pallet'},
              {data:'from_code', title:'Desde'},
              {data:'to_code', title:'Hasta'},
              {data:'delta_uv', title:'UV'},
              {data:'delta_uc', title:'UC'}
            ],
            language:{ url:'https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json' },
            order:[[0,'desc']]
        });
      } else {
        movsTable.clear().rows.add(data).draw();
      }
      // Scroll to movimientos table
      document.getElementById('tblMovs').scrollIntoView({ behavior: 'smooth' });
    }).always(function(){
      $btnMovs.prop('disabled', false).text('Movimientos');
    });
  });
});
