// public/page-scripts/pages/salidas/salidas_scripts.js
// DataTables: Operaciones → Salidas (so_pedido confirmados)

$(document).ready(function () {
  const BASE = typeof window !== "undefined" && window.BASE_URL ? window.BASE_URL : "/";
  const joinUrl = (p) => (BASE.endsWith("/") ? BASE : BASE + "/") + p.replace(/^\/+/, "");

  const tableId = "salidasTable";
  const ajaxUrl = "/api/operaciones/so_list.php";

  const columns = [
    {
      data: null,
      defaultContent: "",
      className: "select-checkbox",
      orderable: false,
      searchable: false,
      title: "",
      width: "20px",
    },
    {
      data: "so_pedido.id",
      title: "Acción",
      orderable: false,
      render: (id, _t, row) => {
        const soId = id || row?.so_pedido?.id;
        const estadoCode = row?.estado?.code || '';
        
        // Lógica de botones según estado
        if (estadoCode === 'PREPARADO') {
          return `<button type="button" data-so-id="${soId}" class="btn btn-sm btn-warning btn-start-embarque">Embarcar</button>`;
        } else if (estadoCode === 'REPOSICION') {
          return `<button type="button" data-so-id="${soId}" class="btn btn-sm btn-info btn-confirm-reposicion">Confirmar Reposición</button>`;
        } else {
          return `<button type="button" data-so-id="${soId}" class="btn btn-sm btn-success btn-start-prep">Preparar</button>`;
        }
      },
    },
    { data: "so_pedido.id", title: "ID", visible: false },
    { data: "so_pedido.codigo", title: "Código" },
    { data: "so_pedido.cliente_ref", title: "Cliente" },
    { data: "so_pedido.fecha_pedido", title: "Fecha" },
    { data: "so_pedido.created_at", title: "Creado", visible: false },
    { data: "estado.code", title: "Estado" },
    { data: "resumen.destinatarios", title: "Dest.", className: "text-end" },
    { data: "resumen.items", title: "Ítems", className: "text-end" },
    { data: "resumen.expected_uv", title: "UV", className: "text-end" },
    { data: "resumen.expected_uc", title: "UC", className: "text-end" },
  ];

  // THEAD dinámico si falta
  const $table = $("#" + tableId);
  if ($table.find("thead").length === 0) {
    let thead = "<thead><tr>";
    columns.forEach((col) => (thead += `<th>${col.title ? col.title : ""}</th>`));
    thead += "</tr></thead>";
    $table.prepend(thead);
  }

  // Inicialización (usa helper base de tu layout)
  const { tableInstance } = initializeBaseDataTable({
    tableId,
    ajaxUrl,
    columns,
    buttons: ["excel", "csv", "pdf"],
    select: { style: "os", selector: "td.select-checkbox" },
    // Ordenar por creado_at desc (columna oculta en índice 7 después de inserción)
    // Recomputamos índice: cols visibles/ocultas hasta ahora: [0:sel,1:acción,2:id(h),3:código,4:cliente,5:fecha,6:creado(h),7:estado,8:dest,9:items,10:uv,11:uc]
    order: [[6, "desc"]],
  });

  // Preparar: navegar al módulo de preparación con so_id
  $(document).on('click', '.btn-start-prep', function(){
    const soId = parseInt($(this).attr('data-so-id'), 10);
    if (!soId) return;
    window.location.href = joinUrl('salidas/preparacion') + '?so_id=' + soId;
  });

  // Confirmar Reposición: cambiar estado a PREPARACION
  $(document).on('click', '.btn-confirm-reposicion', function(){
    const soId = parseInt($(this).attr('data-so-id'), 10);
    if (!soId) return;
    
    if (confirm('¿Confirmar que la reposición ha sido completada?')) {
      // Cambiar estado a PREPARACION (EN_PREPARACION)
      $.post(joinUrl('api/operaciones/so_confirm_reposicion.php'), { so_id: soId })
        .done(function(response) {
          if (response.ok) {
            alert('Reposición confirmada. El pedido ahora está listo para preparación.');
            // Recargar tabla
            $('#' + tableId).DataTable().ajax.reload();
          } else {
            alert('Error: ' + (response.error || 'No se pudo confirmar la reposición'));
          }
        })
        .fail(function() {
          alert('Error de conexión al confirmar reposición');
        });
    }
  });

  // Embarcar: navegar al módulo de embarque con so_id
  $(document).on('click', '.btn-start-embarque', function(){
    const soId = parseInt($(this).attr('data-so-id'), 10);
    if (!soId) return;
    // Navegar a la lista de embarques con referencia al pedido
    window.location.href = joinUrl('salidas/embarque') + '?so_id=' + soId;
  });
});
