$(function () {
  const API = joinUrl("api/testing/wh_in.php");

  function log(obj) {
    const $c = $("#console");
    $c.text(typeof obj === "string" ? obj : JSON.stringify(obj, null, 2));
  }
  function ajaxJSON(action, payload, $btn) {
    $btn?.prop("disabled", true).data("orig", $btn.text()).text("Enviando…");
    return $.ajax({
      url: API + "?action=" + encodeURIComponent(action),
      method: "POST",
      data: JSON.stringify(payload),
      contentType: "application/json; charset=utf-8",
      dataType: "json",
    })
      .always(() => {
        if ($btn) $btn.prop("disabled", false).text($btn.data("orig"));
      })
      .done((res) => log(res))
      .fail((xhr) => {
        let msg = xhr.responseText;
        try {
          msg = JSON.parse(msg);
        } catch (e) {}
        log({ ok: false, status: xhr.status, error: msg });
      });
  }

  // ==== Ingreso ====
  function addItemRow(item) {
    const row = $(`
      <tr>
        <td><input type="number" class="form-control form-control-sm" name="producto_id"></td>
        <td><input type="text"   class="form-control form-control-sm" name="lote_codigo"></td>
        <td><input type="date"   class="form-control form-control-sm" name="fecha_produccion"></td>
        <td><input type="date"   class="form-control form-control-sm" name="fecha_vencimiento"></td>
        <td><input type="number" class="form-control form-control-sm" name="uv_cajas" value="0" min="0"></td>
        <td><input type="number" class="form-control form-control-sm" name="uc_unidades" value="0" min="0"></td>
        <td><button type="button" class="btn btn-sm btn-outline-danger btn-del">✕</button></td>
      </tr>
    `);
    if (item) {
      for (const k in item) {
        row.find(`[name="${k}"]`).val(item[k]);
      }
    }
    row.on("click", ".btn-del", function () {
      row.remove();
    });
    $("#items-body").append(row);
  }

  $("#btn-add-item").on("click", () => addItemRow());
  $("#btn-fill-sample").on("click", () => {
    $("#items-body").empty();
    addItemRow({
      producto_id: 1,
      lote_codigo: "L-TEST-01",
      fecha_produccion: "2025-09-01",
      fecha_vencimiento: "2026-09-01",
      uv_cajas: 10,
      uc_unidades: 0,
    });
    addItemRow({
      producto_id: 2,
      lote_codigo: "L-TEST-02",
      uv_cajas: 5,
      uc_unidades: 12,
    });
  });
  $("#clear-ingreso").on("click", () => {
    $("#items-body").empty();
    log("Listo para ejecutar…");
  });

  $("#form-ingreso").on("submit", function (e) {
    e.preventDefault();
    const $f = $(this),
      $btn = $f.find('button[type="submit"]');
    const items = [];
    $("#items-body tr").each(function () {
      const $r = $(this);
      const i = {
        producto_id: Number($r.find('[name="producto_id"]').val() || 0),
        lote_codigo: $r.find('[name="lote_codigo"]').val() || "",
        fecha_produccion: $r.find('[name="fecha_produccion"]').val() || null,
        fecha_vencimiento: $r.find('[name="fecha_vencimiento"]').val() || null,
        uv_cajas: Number($r.find('[name="uv_cajas"]').val() || 0),
        uc_unidades: Number($r.find('[name="uc_unidades"]').val() || 0),
      };
      items.push(i);
    });
    const payload = {
      deposito_code: $f.find('[name="deposito_code"]').val(),
      pallet_codigo: $f.find('[name="pallet_codigo"]').val(),
      pos_code: $f.find('[name="pos_code"]').val() || null,
      estado_code: $f.find('[name="estado_code"]').val() || null,
      items,
      overwrite: Number($f.find('[name="overwrite"]').val() || 0),
    };
    ajaxJSON("ingreso", payload, $btn);
  });

  // ==== MOVE ====
  $("#form-move").on("submit", function (e) {
    e.preventDefault();
    const $f = $(this),
      $btn = $f.find('button[type="submit"]');
    const payload = {
      deposito_code: $f.find('[name="deposito_code"]').val(),
      pallet_codigo: $f.find('[name="pallet_codigo"]').val(),
      to_pos_code: $f.find('[name="to_pos_code"]').val(),
      motivo: $f.find('[name="motivo"]').val() || null,
      estado_dest: $f.find('[name="estado_dest"]').val() || null,
    };
    ajaxJSON("reposicion", payload, $btn);
  });

  // ==== OUT parcial ====
  $("#form-out-parcial").on("submit", function (e) {
    e.preventDefault();
    const $f = $(this),
      $btn = $f.find('button[type="submit"]');
    const payload = {
      deposito_code: $f.find('[name="deposito_code"]').val(),
      pallet_codigo: $f.find('[name="pallet_codigo"]').val(),
      producto_id: Number($f.find('[name="producto_id"]').val() || 0),
      lote_codigo: $f.find('[name="lote_codigo"]').val(),
      delta_uv: Number($f.find('[name="delta_uv"]').val() || 0),
      delta_uc: Number($f.find('[name="delta_uc"]').val() || 0),
      referencia: $f.find('[name="referencia"]').val() || null,
    };
    ajaxJSON("salida_parcial", payload, $btn);
  });

  // ==== OUT total ====
  $("#form-out-total").on("submit", function (e) {
    e.preventDefault();
    const $f = $(this),
      $btn = $f.find('button[type="submit"]');
    const payload = {
      deposito_code: $f.find('[name="deposito_code"]').val(),
      pallet_codigo: $f.find('[name="pallet_codigo"]').val(),
      referencia: $f.find('[name="referencia"]').val() || null,
    };
    ajaxJSON("salida_total", payload, $btn);
  });

});
