<?php
declare(strict_types=1);

// Raíz del proyecto = carpeta que contiene composer.json
$ROOT    = dirname(__DIR__);
$srcDir  = $ROOT . '/storage/models';
$dstDir  = $ROOT . '/public/assets/storage';
$srcFile = $srcDir . '/sol_ingreso_packing_modelo.xlsx';
$dstFile = $dstDir . '/sol_ingreso_packing_modelo.xlsx';

function ensureDir(string $dir): void {
    if (!is_dir($dir) && !@mkdir($dir, 0775, true) && !is_dir($dir)) {
        throw new RuntimeException("No se pudo crear el directorio: {$dir}");
    }
}
function copyFile(string $from, string $to): void {
    if (!@copy($from, $to)) {
        $err = error_get_last();
        throw new RuntimeException("No se pudo copiar.\nOrigen: {$from}\nDestino: {$to}\nError: ".($err['message']??'desconocido'));
    }
}

try {
    echo "== Publicar modelo de Packing List ==\n";
    echo "Origen esperado: {$srcFile}\n";

    if (!file_exists($srcFile)) {
        throw new RuntimeException("No existe el modelo maestro. Copia el archivo a: {$srcFile}");
    }

    ensureDir($dstDir);
    copyFile($srcFile, $dstFile);
    @chmod($dstFile, 0644);

    echo "OK → Copiado a: {$dstFile}\n";
    echo "URL pública: /assets/storage/sol_ingreso_packing_modelo.xlsx\n";
    exit(0);
} catch (Throwable $e) {
    fwrite(STDERR, "[ERROR] ".$e->getMessage()."\n");
    exit(1);
}
