<?php

/*
 * Example PHP implementation used for the index.html example
 */

// DataTables PHP library
include( "../lib/DataTables.php" );

// Alias Editor classes so they are easy to use
use
	DataTables\Editor,
	DataTables\Editor\Field,
	DataTables\Editor\Format,
	DataTables\Editor\Mjoin,
	DataTables\Editor\Options,
	DataTables\Editor\Upload,
	DataTables\Editor\Validate,
    DataTables\Editor\ValidateOptions,
    DataTables\Editor\SearchBuilderOptions;

// Build our Editor instance and process the data coming from _POST
Editor::inst( $db, 'users' )
	->field( 
        Field::inst( 'users.first_name' ),
		Field::inst( 'users.last_name' )
            ->columnControl( Options::inst()
				->table( 'users' )
				->value( 'last_name' )
				->label( 'last_name' )
            ),
		Field::inst( 'users.phone' ),
        Field::inst( 'users.site' )
            ->options( Options::inst()
				->table( 'sites' )
				->value( 'id' )
				->label( 'name' )
			)
            ->validator( Validate::dbValues() ),
        Field::inst( 'sites.name' )
            ->columnControl( Options::inst()
				->table( 'sites' )
				->value( 'name' )
				->label( 'name' )
            )
    )
    ->leftJoin( 'sites', 'sites.id', '=', 'users.site' )
    ->debug(true)
	->process($_POST)
    ->json();