<?php
require_once 'config/db.php';

try {
    $pdo = get_pdo();
    
    echo "Agregando estado REPOSICION...\n";
    
    // Verificar si ya existe
    $stmt = $pdo->prepare("SELECT id FROM so_pedido_estado WHERE code = 'REPOSICION'");
    $stmt->execute();
    if ($stmt->fetchColumn()) {
        echo "Estado REPOSICION ya existe.\n";
        exit;
    }
    
    // Obtener el próximo ID disponible
    $stmt = $pdo->query("SELECT MAX(id) + 1 as next_id FROM so_pedido_estado");
    $nextId = $stmt->fetchColumn();
    
    // Insertar REPOSICION con el siguiente ID disponible
    $stmt = $pdo->prepare("
        INSERT INTO so_pedido_estado (id, code, nombre, orden, activo) 
        VALUES (?, 'REPOSICION', 'En reposición', ?, 1)
    ");
    $stmt->execute([$nextId, $nextId]);
    
    echo "Estado REPOSICION agregado exitosamente con ID: $nextId\n";
    
    // Mostrar estados actualizados
    echo "\nEstados actuales:\n";
    $result = $pdo->query('SELECT * FROM so_pedido_estado ORDER BY orden');
    while($row = $result->fetch()) {
        echo $row['id'] . ' - ' . $row['code'] . ' - ' . $row['nombre'] . "\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>